<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opportunity StructType
 * Meta information extracted from the WSDL
 * - type: tranSales:Opportunity
 * @subpackage Structs
 */
class Opportunity extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The estimatedBudget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedBudget;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The taxPointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPointDate;
    /**
     * The oneTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $oneTime;
    /**
     * The recurWeekly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recurWeekly;
    /**
     * The recurMonthly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recurMonthly;
    /**
     * The recurQuarterly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recurQuarterly;
    /**
     * The recurAnnually
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recurAnnually;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The salesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesRep;
    /**
     * The contribPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contribPct;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partner;
    /**
     * The salesGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesGroup;
    /**
     * The syncSalesTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncSalesTeams;
    /**
     * The leadSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $leadSource;
    /**
     * The entityStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityStatus;
    /**
     * The probability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $probability;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The expectedCloseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedCloseDate;
    /**
     * The daysOpen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $daysOpen;
    /**
     * The forecastType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $forecastType;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The projectedTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $projectedTotal;
    /**
     * The rangeLow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rangeLow;
    /**
     * The rangeHigh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rangeHigh;
    /**
     * The projAltSalesAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $projAltSalesAmt;
    /**
     * The altSalesRangeLow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altSalesRangeLow;
    /**
     * The altSalesRangeHigh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altSalesRangeHigh;
    /**
     * The weightedTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weightedTotal;
    /**
     * The actionItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $actionItem;
    /**
     * The winLossReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $winLossReason;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The isBudgetApproved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBudgetApproved;
    /**
     * The tax2Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Total;
    /**
     * The salesReadiness
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesReadiness;
    /**
     * The totalCostEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalCostEstimate;
    /**
     * The buyingTimeFrame
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $buyingTimeFrame;
    /**
     * The estGrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfit;
    /**
     * The buyingReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $buyingReason;
    /**
     * The estGrossProfitPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfitPercent;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shippingAddress;
    /**
     * The shipIsResidential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $shipIsResidential;
    /**
     * The shipAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddressList;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The closeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $closeDate;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The vatRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNum;
    /**
     * The syncPartnerTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncPartnerTeams;
    /**
     * The salesTeamList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpportunitySalesTeamList
     */
    public $salesTeamList;
    /**
     * The partnersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpportunityPartnersList
     */
    public $partnersList;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpportunityItemList
     */
    public $itemList;
    /**
     * The competitorsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpportunityCompetitorsList
     */
    public $competitorsList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Opportunity
     * @uses Opportunity::setCustomForm()
     * @uses Opportunity::setCurrency()
     * @uses Opportunity::setEstimatedBudget()
     * @uses Opportunity::setEntity()
     * @uses Opportunity::setJob()
     * @uses Opportunity::setTitle()
     * @uses Opportunity::setTranId()
     * @uses Opportunity::setEntityTaxRegNum()
     * @uses Opportunity::setTaxPointDate()
     * @uses Opportunity::setOneTime()
     * @uses Opportunity::setRecurWeekly()
     * @uses Opportunity::setRecurMonthly()
     * @uses Opportunity::setRecurQuarterly()
     * @uses Opportunity::setRecurAnnually()
     * @uses Opportunity::setSource()
     * @uses Opportunity::setSalesRep()
     * @uses Opportunity::setContribPct()
     * @uses Opportunity::setPartner()
     * @uses Opportunity::setSalesGroup()
     * @uses Opportunity::setSyncSalesTeams()
     * @uses Opportunity::setLeadSource()
     * @uses Opportunity::setEntityStatus()
     * @uses Opportunity::setProbability()
     * @uses Opportunity::setTranDate()
     * @uses Opportunity::setExpectedCloseDate()
     * @uses Opportunity::setDaysOpen()
     * @uses Opportunity::setForecastType()
     * @uses Opportunity::setCurrencyName()
     * @uses Opportunity::setExchangeRate()
     * @uses Opportunity::setProjectedTotal()
     * @uses Opportunity::setRangeLow()
     * @uses Opportunity::setRangeHigh()
     * @uses Opportunity::setProjAltSalesAmt()
     * @uses Opportunity::setAltSalesRangeLow()
     * @uses Opportunity::setAltSalesRangeHigh()
     * @uses Opportunity::setWeightedTotal()
     * @uses Opportunity::setActionItem()
     * @uses Opportunity::setWinLossReason()
     * @uses Opportunity::setMemo()
     * @uses Opportunity::setTaxTotal()
     * @uses Opportunity::setIsBudgetApproved()
     * @uses Opportunity::setTax2Total()
     * @uses Opportunity::setSalesReadiness()
     * @uses Opportunity::setTotalCostEstimate()
     * @uses Opportunity::setBuyingTimeFrame()
     * @uses Opportunity::setEstGrossProfit()
     * @uses Opportunity::setBuyingReason()
     * @uses Opportunity::setEstGrossProfitPercent()
     * @uses Opportunity::setBillingAddress()
     * @uses Opportunity::setBillAddressList()
     * @uses Opportunity::setShippingAddress()
     * @uses Opportunity::setShipIsResidential()
     * @uses Opportunity::setShipAddressList()
     * @uses Opportunity::setClass()
     * @uses Opportunity::setCloseDate()
     * @uses Opportunity::setCreatedDate()
     * @uses Opportunity::setLastModifiedDate()
     * @uses Opportunity::setNexus()
     * @uses Opportunity::setSubsidiaryTaxRegNum()
     * @uses Opportunity::setTaxRegOverride()
     * @uses Opportunity::setTaxDetailsOverride()
     * @uses Opportunity::setDepartment()
     * @uses Opportunity::setLocation()
     * @uses Opportunity::setSubsidiary()
     * @uses Opportunity::setStatus()
     * @uses Opportunity::setVatRegNum()
     * @uses Opportunity::setSyncPartnerTeams()
     * @uses Opportunity::setSalesTeamList()
     * @uses Opportunity::setPartnersList()
     * @uses Opportunity::setItemList()
     * @uses Opportunity::setCompetitorsList()
     * @uses Opportunity::setAccountingBookDetailList()
     * @uses Opportunity::setTaxDetailsList()
     * @uses Opportunity::setCustomFieldList()
     * @uses Opportunity::setInternalId()
     * @uses Opportunity::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $currency
     * @param float $estimatedBudget
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $job
     * @param string $title
     * @param string $tranId
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param string $taxPointDate
     * @param float $oneTime
     * @param float $recurWeekly
     * @param float $recurMonthly
     * @param float $recurQuarterly
     * @param float $recurAnnually
     * @param string $source
     * @param \StructType\RecordRef $salesRep
     * @param string $contribPct
     * @param \StructType\RecordRef $partner
     * @param \StructType\RecordRef $salesGroup
     * @param bool $syncSalesTeams
     * @param \StructType\RecordRef $leadSource
     * @param \StructType\RecordRef $entityStatus
     * @param float $probability
     * @param string $tranDate
     * @param string $expectedCloseDate
     * @param int $daysOpen
     * @param \StructType\RecordRef $forecastType
     * @param string $currencyName
     * @param float $exchangeRate
     * @param float $projectedTotal
     * @param float $rangeLow
     * @param float $rangeHigh
     * @param float $projAltSalesAmt
     * @param float $altSalesRangeLow
     * @param float $altSalesRangeHigh
     * @param float $weightedTotal
     * @param string $actionItem
     * @param \StructType\RecordRef $winLossReason
     * @param string $memo
     * @param float $taxTotal
     * @param bool $isBudgetApproved
     * @param float $tax2Total
     * @param \StructType\RecordRef $salesReadiness
     * @param float $totalCostEstimate
     * @param \StructType\RecordRef $buyingTimeFrame
     * @param float $estGrossProfit
     * @param \StructType\RecordRef $buyingReason
     * @param float $estGrossProfitPercent
     * @param \StructType\Address $billingAddress
     * @param \StructType\RecordRef $billAddressList
     * @param \StructType\Address $shippingAddress
     * @param bool $shipIsResidential
     * @param \StructType\RecordRef $shipAddressList
     * @param \StructType\RecordRef $class
     * @param string $closeDate
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param string $status
     * @param string $vatRegNum
     * @param bool $syncPartnerTeams
     * @param \StructType\OpportunitySalesTeamList $salesTeamList
     * @param \StructType\OpportunityPartnersList $partnersList
     * @param \StructType\OpportunityItemList $itemList
     * @param \StructType\OpportunityCompetitorsList $competitorsList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, \StructType\RecordRef $currency = null, $estimatedBudget = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $job = null, $title = null, $tranId = null, \StructType\RecordRef $entityTaxRegNum = null, $taxPointDate = null, $oneTime = null, $recurWeekly = null, $recurMonthly = null, $recurQuarterly = null, $recurAnnually = null, $source = null, \StructType\RecordRef $salesRep = null, $contribPct = null, \StructType\RecordRef $partner = null, \StructType\RecordRef $salesGroup = null, $syncSalesTeams = null, \StructType\RecordRef $leadSource = null, \StructType\RecordRef $entityStatus = null, $probability = null, $tranDate = null, $expectedCloseDate = null, $daysOpen = null, \StructType\RecordRef $forecastType = null, $currencyName = null, $exchangeRate = null, $projectedTotal = null, $rangeLow = null, $rangeHigh = null, $projAltSalesAmt = null, $altSalesRangeLow = null, $altSalesRangeHigh = null, $weightedTotal = null, $actionItem = null, \StructType\RecordRef $winLossReason = null, $memo = null, $taxTotal = null, $isBudgetApproved = null, $tax2Total = null, \StructType\RecordRef $salesReadiness = null, $totalCostEstimate = null, \StructType\RecordRef $buyingTimeFrame = null, $estGrossProfit = null, \StructType\RecordRef $buyingReason = null, $estGrossProfitPercent = null, \StructType\Address $billingAddress = null, \StructType\RecordRef $billAddressList = null, \StructType\Address $shippingAddress = null, $shipIsResidential = null, \StructType\RecordRef $shipAddressList = null, \StructType\RecordRef $class = null, $closeDate = null, $createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $department = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, $status = null, $vatRegNum = null, $syncPartnerTeams = null, \StructType\OpportunitySalesTeamList $salesTeamList = null, \StructType\OpportunityPartnersList $partnersList = null, \StructType\OpportunityItemList $itemList = null, \StructType\OpportunityCompetitorsList $competitorsList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setCurrency($currency)
            ->setEstimatedBudget($estimatedBudget)
            ->setEntity($entity)
            ->setJob($job)
            ->setTitle($title)
            ->setTranId($tranId)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setTaxPointDate($taxPointDate)
            ->setOneTime($oneTime)
            ->setRecurWeekly($recurWeekly)
            ->setRecurMonthly($recurMonthly)
            ->setRecurQuarterly($recurQuarterly)
            ->setRecurAnnually($recurAnnually)
            ->setSource($source)
            ->setSalesRep($salesRep)
            ->setContribPct($contribPct)
            ->setPartner($partner)
            ->setSalesGroup($salesGroup)
            ->setSyncSalesTeams($syncSalesTeams)
            ->setLeadSource($leadSource)
            ->setEntityStatus($entityStatus)
            ->setProbability($probability)
            ->setTranDate($tranDate)
            ->setExpectedCloseDate($expectedCloseDate)
            ->setDaysOpen($daysOpen)
            ->setForecastType($forecastType)
            ->setCurrencyName($currencyName)
            ->setExchangeRate($exchangeRate)
            ->setProjectedTotal($projectedTotal)
            ->setRangeLow($rangeLow)
            ->setRangeHigh($rangeHigh)
            ->setProjAltSalesAmt($projAltSalesAmt)
            ->setAltSalesRangeLow($altSalesRangeLow)
            ->setAltSalesRangeHigh($altSalesRangeHigh)
            ->setWeightedTotal($weightedTotal)
            ->setActionItem($actionItem)
            ->setWinLossReason($winLossReason)
            ->setMemo($memo)
            ->setTaxTotal($taxTotal)
            ->setIsBudgetApproved($isBudgetApproved)
            ->setTax2Total($tax2Total)
            ->setSalesReadiness($salesReadiness)
            ->setTotalCostEstimate($totalCostEstimate)
            ->setBuyingTimeFrame($buyingTimeFrame)
            ->setEstGrossProfit($estGrossProfit)
            ->setBuyingReason($buyingReason)
            ->setEstGrossProfitPercent($estGrossProfitPercent)
            ->setBillingAddress($billingAddress)
            ->setBillAddressList($billAddressList)
            ->setShippingAddress($shippingAddress)
            ->setShipIsResidential($shipIsResidential)
            ->setShipAddressList($shipAddressList)
            ->setClass($class)
            ->setCloseDate($closeDate)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setDepartment($department)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setStatus($status)
            ->setVatRegNum($vatRegNum)
            ->setSyncPartnerTeams($syncPartnerTeams)
            ->setSalesTeamList($salesTeamList)
            ->setPartnersList($partnersList)
            ->setItemList($itemList)
            ->setCompetitorsList($competitorsList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setTaxDetailsList($taxDetailsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Opportunity
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Opportunity
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get estimatedBudget value
     * @return float|null
     */
    public function getEstimatedBudget()
    {
        return $this->estimatedBudget;
    }
    /**
     * Set estimatedBudget value
     * @param float $estimatedBudget
     * @return \StructType\Opportunity
     */
    public function setEstimatedBudget($estimatedBudget = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedBudget) && !(is_float($estimatedBudget) || is_numeric($estimatedBudget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedBudget, true), gettype($estimatedBudget)), __LINE__);
        }
        $this->estimatedBudget = $estimatedBudget;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\Opportunity
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\Opportunity
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Opportunity
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\Opportunity
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\Opportunity
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get taxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->taxPointDate;
    }
    /**
     * Set taxPointDate value
     * @param string $taxPointDate
     * @return \StructType\Opportunity
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->taxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get oneTime value
     * @return float|null
     */
    public function getOneTime()
    {
        return $this->oneTime;
    }
    /**
     * Set oneTime value
     * @param float $oneTime
     * @return \StructType\Opportunity
     */
    public function setOneTime($oneTime = null)
    {
        // validation for constraint: float
        if (!is_null($oneTime) && !(is_float($oneTime) || is_numeric($oneTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oneTime, true), gettype($oneTime)), __LINE__);
        }
        $this->oneTime = $oneTime;
        return $this;
    }
    /**
     * Get recurWeekly value
     * @return float|null
     */
    public function getRecurWeekly()
    {
        return $this->recurWeekly;
    }
    /**
     * Set recurWeekly value
     * @param float $recurWeekly
     * @return \StructType\Opportunity
     */
    public function setRecurWeekly($recurWeekly = null)
    {
        // validation for constraint: float
        if (!is_null($recurWeekly) && !(is_float($recurWeekly) || is_numeric($recurWeekly))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recurWeekly, true), gettype($recurWeekly)), __LINE__);
        }
        $this->recurWeekly = $recurWeekly;
        return $this;
    }
    /**
     * Get recurMonthly value
     * @return float|null
     */
    public function getRecurMonthly()
    {
        return $this->recurMonthly;
    }
    /**
     * Set recurMonthly value
     * @param float $recurMonthly
     * @return \StructType\Opportunity
     */
    public function setRecurMonthly($recurMonthly = null)
    {
        // validation for constraint: float
        if (!is_null($recurMonthly) && !(is_float($recurMonthly) || is_numeric($recurMonthly))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recurMonthly, true), gettype($recurMonthly)), __LINE__);
        }
        $this->recurMonthly = $recurMonthly;
        return $this;
    }
    /**
     * Get recurQuarterly value
     * @return float|null
     */
    public function getRecurQuarterly()
    {
        return $this->recurQuarterly;
    }
    /**
     * Set recurQuarterly value
     * @param float $recurQuarterly
     * @return \StructType\Opportunity
     */
    public function setRecurQuarterly($recurQuarterly = null)
    {
        // validation for constraint: float
        if (!is_null($recurQuarterly) && !(is_float($recurQuarterly) || is_numeric($recurQuarterly))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recurQuarterly, true), gettype($recurQuarterly)), __LINE__);
        }
        $this->recurQuarterly = $recurQuarterly;
        return $this;
    }
    /**
     * Get recurAnnually value
     * @return float|null
     */
    public function getRecurAnnually()
    {
        return $this->recurAnnually;
    }
    /**
     * Set recurAnnually value
     * @param float $recurAnnually
     * @return \StructType\Opportunity
     */
    public function setRecurAnnually($recurAnnually = null)
    {
        // validation for constraint: float
        if (!is_null($recurAnnually) && !(is_float($recurAnnually) || is_numeric($recurAnnually))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recurAnnually, true), gettype($recurAnnually)), __LINE__);
        }
        $this->recurAnnually = $recurAnnually;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\Opportunity
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get salesRep value
     * @return \StructType\RecordRef|null
     */
    public function getSalesRep()
    {
        return $this->salesRep;
    }
    /**
     * Set salesRep value
     * @param \StructType\RecordRef $salesRep
     * @return \StructType\Opportunity
     */
    public function setSalesRep(\StructType\RecordRef $salesRep = null)
    {
        $this->salesRep = $salesRep;
        return $this;
    }
    /**
     * Get contribPct value
     * @return string|null
     */
    public function getContribPct()
    {
        return $this->contribPct;
    }
    /**
     * Set contribPct value
     * @param string $contribPct
     * @return \StructType\Opportunity
     */
    public function setContribPct($contribPct = null)
    {
        // validation for constraint: string
        if (!is_null($contribPct) && !is_string($contribPct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contribPct, true), gettype($contribPct)), __LINE__);
        }
        $this->contribPct = $contribPct;
        return $this;
    }
    /**
     * Get partner value
     * @return \StructType\RecordRef|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\RecordRef $partner
     * @return \StructType\Opportunity
     */
    public function setPartner(\StructType\RecordRef $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get salesGroup value
     * @return \StructType\RecordRef|null
     */
    public function getSalesGroup()
    {
        return $this->salesGroup;
    }
    /**
     * Set salesGroup value
     * @param \StructType\RecordRef $salesGroup
     * @return \StructType\Opportunity
     */
    public function setSalesGroup(\StructType\RecordRef $salesGroup = null)
    {
        $this->salesGroup = $salesGroup;
        return $this;
    }
    /**
     * Get syncSalesTeams value
     * @return bool|null
     */
    public function getSyncSalesTeams()
    {
        return $this->syncSalesTeams;
    }
    /**
     * Set syncSalesTeams value
     * @param bool $syncSalesTeams
     * @return \StructType\Opportunity
     */
    public function setSyncSalesTeams($syncSalesTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncSalesTeams) && !is_bool($syncSalesTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncSalesTeams, true), gettype($syncSalesTeams)), __LINE__);
        }
        $this->syncSalesTeams = $syncSalesTeams;
        return $this;
    }
    /**
     * Get leadSource value
     * @return \StructType\RecordRef|null
     */
    public function getLeadSource()
    {
        return $this->leadSource;
    }
    /**
     * Set leadSource value
     * @param \StructType\RecordRef $leadSource
     * @return \StructType\Opportunity
     */
    public function setLeadSource(\StructType\RecordRef $leadSource = null)
    {
        $this->leadSource = $leadSource;
        return $this;
    }
    /**
     * Get entityStatus value
     * @return \StructType\RecordRef|null
     */
    public function getEntityStatus()
    {
        return $this->entityStatus;
    }
    /**
     * Set entityStatus value
     * @param \StructType\RecordRef $entityStatus
     * @return \StructType\Opportunity
     */
    public function setEntityStatus(\StructType\RecordRef $entityStatus = null)
    {
        $this->entityStatus = $entityStatus;
        return $this;
    }
    /**
     * Get probability value
     * @return float|null
     */
    public function getProbability()
    {
        return $this->probability;
    }
    /**
     * Set probability value
     * @param float $probability
     * @return \StructType\Opportunity
     */
    public function setProbability($probability = null)
    {
        // validation for constraint: float
        if (!is_null($probability) && !(is_float($probability) || is_numeric($probability))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($probability, true), gettype($probability)), __LINE__);
        }
        $this->probability = $probability;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\Opportunity
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get expectedCloseDate value
     * @return string|null
     */
    public function getExpectedCloseDate()
    {
        return $this->expectedCloseDate;
    }
    /**
     * Set expectedCloseDate value
     * @param string $expectedCloseDate
     * @return \StructType\Opportunity
     */
    public function setExpectedCloseDate($expectedCloseDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedCloseDate) && !is_string($expectedCloseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedCloseDate, true), gettype($expectedCloseDate)), __LINE__);
        }
        $this->expectedCloseDate = $expectedCloseDate;
        return $this;
    }
    /**
     * Get daysOpen value
     * @return int|null
     */
    public function getDaysOpen()
    {
        return $this->daysOpen;
    }
    /**
     * Set daysOpen value
     * @param int $daysOpen
     * @return \StructType\Opportunity
     */
    public function setDaysOpen($daysOpen = null)
    {
        // validation for constraint: int
        if (!is_null($daysOpen) && !(is_int($daysOpen) || ctype_digit($daysOpen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysOpen, true), gettype($daysOpen)), __LINE__);
        }
        $this->daysOpen = $daysOpen;
        return $this;
    }
    /**
     * Get forecastType value
     * @return \StructType\RecordRef|null
     */
    public function getForecastType()
    {
        return $this->forecastType;
    }
    /**
     * Set forecastType value
     * @param \StructType\RecordRef $forecastType
     * @return \StructType\Opportunity
     */
    public function setForecastType(\StructType\RecordRef $forecastType = null)
    {
        $this->forecastType = $forecastType;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\Opportunity
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Opportunity
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get projectedTotal value
     * @return float|null
     */
    public function getProjectedTotal()
    {
        return $this->projectedTotal;
    }
    /**
     * Set projectedTotal value
     * @param float $projectedTotal
     * @return \StructType\Opportunity
     */
    public function setProjectedTotal($projectedTotal = null)
    {
        // validation for constraint: float
        if (!is_null($projectedTotal) && !(is_float($projectedTotal) || is_numeric($projectedTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($projectedTotal, true), gettype($projectedTotal)), __LINE__);
        }
        $this->projectedTotal = $projectedTotal;
        return $this;
    }
    /**
     * Get rangeLow value
     * @return float|null
     */
    public function getRangeLow()
    {
        return $this->rangeLow;
    }
    /**
     * Set rangeLow value
     * @param float $rangeLow
     * @return \StructType\Opportunity
     */
    public function setRangeLow($rangeLow = null)
    {
        // validation for constraint: float
        if (!is_null($rangeLow) && !(is_float($rangeLow) || is_numeric($rangeLow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rangeLow, true), gettype($rangeLow)), __LINE__);
        }
        $this->rangeLow = $rangeLow;
        return $this;
    }
    /**
     * Get rangeHigh value
     * @return float|null
     */
    public function getRangeHigh()
    {
        return $this->rangeHigh;
    }
    /**
     * Set rangeHigh value
     * @param float $rangeHigh
     * @return \StructType\Opportunity
     */
    public function setRangeHigh($rangeHigh = null)
    {
        // validation for constraint: float
        if (!is_null($rangeHigh) && !(is_float($rangeHigh) || is_numeric($rangeHigh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rangeHigh, true), gettype($rangeHigh)), __LINE__);
        }
        $this->rangeHigh = $rangeHigh;
        return $this;
    }
    /**
     * Get projAltSalesAmt value
     * @return float|null
     */
    public function getProjAltSalesAmt()
    {
        return $this->projAltSalesAmt;
    }
    /**
     * Set projAltSalesAmt value
     * @param float $projAltSalesAmt
     * @return \StructType\Opportunity
     */
    public function setProjAltSalesAmt($projAltSalesAmt = null)
    {
        // validation for constraint: float
        if (!is_null($projAltSalesAmt) && !(is_float($projAltSalesAmt) || is_numeric($projAltSalesAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($projAltSalesAmt, true), gettype($projAltSalesAmt)), __LINE__);
        }
        $this->projAltSalesAmt = $projAltSalesAmt;
        return $this;
    }
    /**
     * Get altSalesRangeLow value
     * @return float|null
     */
    public function getAltSalesRangeLow()
    {
        return $this->altSalesRangeLow;
    }
    /**
     * Set altSalesRangeLow value
     * @param float $altSalesRangeLow
     * @return \StructType\Opportunity
     */
    public function setAltSalesRangeLow($altSalesRangeLow = null)
    {
        // validation for constraint: float
        if (!is_null($altSalesRangeLow) && !(is_float($altSalesRangeLow) || is_numeric($altSalesRangeLow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altSalesRangeLow, true), gettype($altSalesRangeLow)), __LINE__);
        }
        $this->altSalesRangeLow = $altSalesRangeLow;
        return $this;
    }
    /**
     * Get altSalesRangeHigh value
     * @return float|null
     */
    public function getAltSalesRangeHigh()
    {
        return $this->altSalesRangeHigh;
    }
    /**
     * Set altSalesRangeHigh value
     * @param float $altSalesRangeHigh
     * @return \StructType\Opportunity
     */
    public function setAltSalesRangeHigh($altSalesRangeHigh = null)
    {
        // validation for constraint: float
        if (!is_null($altSalesRangeHigh) && !(is_float($altSalesRangeHigh) || is_numeric($altSalesRangeHigh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altSalesRangeHigh, true), gettype($altSalesRangeHigh)), __LINE__);
        }
        $this->altSalesRangeHigh = $altSalesRangeHigh;
        return $this;
    }
    /**
     * Get weightedTotal value
     * @return float|null
     */
    public function getWeightedTotal()
    {
        return $this->weightedTotal;
    }
    /**
     * Set weightedTotal value
     * @param float $weightedTotal
     * @return \StructType\Opportunity
     */
    public function setWeightedTotal($weightedTotal = null)
    {
        // validation for constraint: float
        if (!is_null($weightedTotal) && !(is_float($weightedTotal) || is_numeric($weightedTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weightedTotal, true), gettype($weightedTotal)), __LINE__);
        }
        $this->weightedTotal = $weightedTotal;
        return $this;
    }
    /**
     * Get actionItem value
     * @return string|null
     */
    public function getActionItem()
    {
        return $this->actionItem;
    }
    /**
     * Set actionItem value
     * @param string $actionItem
     * @return \StructType\Opportunity
     */
    public function setActionItem($actionItem = null)
    {
        // validation for constraint: string
        if (!is_null($actionItem) && !is_string($actionItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionItem, true), gettype($actionItem)), __LINE__);
        }
        $this->actionItem = $actionItem;
        return $this;
    }
    /**
     * Get winLossReason value
     * @return \StructType\RecordRef|null
     */
    public function getWinLossReason()
    {
        return $this->winLossReason;
    }
    /**
     * Set winLossReason value
     * @param \StructType\RecordRef $winLossReason
     * @return \StructType\Opportunity
     */
    public function setWinLossReason(\StructType\RecordRef $winLossReason = null)
    {
        $this->winLossReason = $winLossReason;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\Opportunity
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\Opportunity
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get isBudgetApproved value
     * @return bool|null
     */
    public function getIsBudgetApproved()
    {
        return $this->isBudgetApproved;
    }
    /**
     * Set isBudgetApproved value
     * @param bool $isBudgetApproved
     * @return \StructType\Opportunity
     */
    public function setIsBudgetApproved($isBudgetApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBudgetApproved) && !is_bool($isBudgetApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBudgetApproved, true), gettype($isBudgetApproved)), __LINE__);
        }
        $this->isBudgetApproved = $isBudgetApproved;
        return $this;
    }
    /**
     * Get tax2Total value
     * @return float|null
     */
    public function getTax2Total()
    {
        return $this->tax2Total;
    }
    /**
     * Set tax2Total value
     * @param float $tax2Total
     * @return \StructType\Opportunity
     */
    public function setTax2Total($tax2Total = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Total) && !(is_float($tax2Total) || is_numeric($tax2Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Total, true), gettype($tax2Total)), __LINE__);
        }
        $this->tax2Total = $tax2Total;
        return $this;
    }
    /**
     * Get salesReadiness value
     * @return \StructType\RecordRef|null
     */
    public function getSalesReadiness()
    {
        return $this->salesReadiness;
    }
    /**
     * Set salesReadiness value
     * @param \StructType\RecordRef $salesReadiness
     * @return \StructType\Opportunity
     */
    public function setSalesReadiness(\StructType\RecordRef $salesReadiness = null)
    {
        $this->salesReadiness = $salesReadiness;
        return $this;
    }
    /**
     * Get totalCostEstimate value
     * @return float|null
     */
    public function getTotalCostEstimate()
    {
        return $this->totalCostEstimate;
    }
    /**
     * Set totalCostEstimate value
     * @param float $totalCostEstimate
     * @return \StructType\Opportunity
     */
    public function setTotalCostEstimate($totalCostEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($totalCostEstimate) && !(is_float($totalCostEstimate) || is_numeric($totalCostEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCostEstimate, true), gettype($totalCostEstimate)), __LINE__);
        }
        $this->totalCostEstimate = $totalCostEstimate;
        return $this;
    }
    /**
     * Get buyingTimeFrame value
     * @return \StructType\RecordRef|null
     */
    public function getBuyingTimeFrame()
    {
        return $this->buyingTimeFrame;
    }
    /**
     * Set buyingTimeFrame value
     * @param \StructType\RecordRef $buyingTimeFrame
     * @return \StructType\Opportunity
     */
    public function setBuyingTimeFrame(\StructType\RecordRef $buyingTimeFrame = null)
    {
        $this->buyingTimeFrame = $buyingTimeFrame;
        return $this;
    }
    /**
     * Get estGrossProfit value
     * @return float|null
     */
    public function getEstGrossProfit()
    {
        return $this->estGrossProfit;
    }
    /**
     * Set estGrossProfit value
     * @param float $estGrossProfit
     * @return \StructType\Opportunity
     */
    public function setEstGrossProfit($estGrossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfit) && !(is_float($estGrossProfit) || is_numeric($estGrossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfit, true), gettype($estGrossProfit)), __LINE__);
        }
        $this->estGrossProfit = $estGrossProfit;
        return $this;
    }
    /**
     * Get buyingReason value
     * @return \StructType\RecordRef|null
     */
    public function getBuyingReason()
    {
        return $this->buyingReason;
    }
    /**
     * Set buyingReason value
     * @param \StructType\RecordRef $buyingReason
     * @return \StructType\Opportunity
     */
    public function setBuyingReason(\StructType\RecordRef $buyingReason = null)
    {
        $this->buyingReason = $buyingReason;
        return $this;
    }
    /**
     * Get estGrossProfitPercent value
     * @return float|null
     */
    public function getEstGrossProfitPercent()
    {
        return $this->estGrossProfitPercent;
    }
    /**
     * Set estGrossProfitPercent value
     * @param float $estGrossProfitPercent
     * @return \StructType\Opportunity
     */
    public function setEstGrossProfitPercent($estGrossProfitPercent = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfitPercent) && !(is_float($estGrossProfitPercent) || is_numeric($estGrossProfitPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfitPercent, true), gettype($estGrossProfitPercent)), __LINE__);
        }
        $this->estGrossProfitPercent = $estGrossProfitPercent;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\Opportunity
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\Opportunity
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\Address $shippingAddress
     * @return \StructType\Opportunity
     */
    public function setShippingAddress(\StructType\Address $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get shipIsResidential value
     * @return bool|null
     */
    public function getShipIsResidential()
    {
        return $this->shipIsResidential;
    }
    /**
     * Set shipIsResidential value
     * @param bool $shipIsResidential
     * @return \StructType\Opportunity
     */
    public function setShipIsResidential($shipIsResidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipIsResidential) && !is_bool($shipIsResidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipIsResidential, true), gettype($shipIsResidential)), __LINE__);
        }
        $this->shipIsResidential = $shipIsResidential;
        return $this;
    }
    /**
     * Get shipAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddressList()
    {
        return $this->shipAddressList;
    }
    /**
     * Set shipAddressList value
     * @param \StructType\RecordRef $shipAddressList
     * @return \StructType\Opportunity
     */
    public function setShipAddressList(\StructType\RecordRef $shipAddressList = null)
    {
        $this->shipAddressList = $shipAddressList;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Opportunity
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get closeDate value
     * @return string|null
     */
    public function getCloseDate()
    {
        return $this->closeDate;
    }
    /**
     * Set closeDate value
     * @param string $closeDate
     * @return \StructType\Opportunity
     */
    public function setCloseDate($closeDate = null)
    {
        // validation for constraint: string
        if (!is_null($closeDate) && !is_string($closeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closeDate, true), gettype($closeDate)), __LINE__);
        }
        $this->closeDate = $closeDate;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Opportunity
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Opportunity
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\Opportunity
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\Opportunity
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\Opportunity
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\Opportunity
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Opportunity
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Opportunity
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\Opportunity
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Opportunity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get vatRegNum value
     * @return string|null
     */
    public function getVatRegNum()
    {
        return $this->vatRegNum;
    }
    /**
     * Set vatRegNum value
     * @param string $vatRegNum
     * @return \StructType\Opportunity
     */
    public function setVatRegNum($vatRegNum = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNum) && !is_string($vatRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNum, true), gettype($vatRegNum)), __LINE__);
        }
        $this->vatRegNum = $vatRegNum;
        return $this;
    }
    /**
     * Get syncPartnerTeams value
     * @return bool|null
     */
    public function getSyncPartnerTeams()
    {
        return $this->syncPartnerTeams;
    }
    /**
     * Set syncPartnerTeams value
     * @param bool $syncPartnerTeams
     * @return \StructType\Opportunity
     */
    public function setSyncPartnerTeams($syncPartnerTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncPartnerTeams) && !is_bool($syncPartnerTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncPartnerTeams, true), gettype($syncPartnerTeams)), __LINE__);
        }
        $this->syncPartnerTeams = $syncPartnerTeams;
        return $this;
    }
    /**
     * Get salesTeamList value
     * @return \StructType\OpportunitySalesTeamList|null
     */
    public function getSalesTeamList()
    {
        return $this->salesTeamList;
    }
    /**
     * Set salesTeamList value
     * @param \StructType\OpportunitySalesTeamList $salesTeamList
     * @return \StructType\Opportunity
     */
    public function setSalesTeamList(\StructType\OpportunitySalesTeamList $salesTeamList = null)
    {
        $this->salesTeamList = $salesTeamList;
        return $this;
    }
    /**
     * Get partnersList value
     * @return \StructType\OpportunityPartnersList|null
     */
    public function getPartnersList()
    {
        return $this->partnersList;
    }
    /**
     * Set partnersList value
     * @param \StructType\OpportunityPartnersList $partnersList
     * @return \StructType\Opportunity
     */
    public function setPartnersList(\StructType\OpportunityPartnersList $partnersList = null)
    {
        $this->partnersList = $partnersList;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\OpportunityItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\OpportunityItemList $itemList
     * @return \StructType\Opportunity
     */
    public function setItemList(\StructType\OpportunityItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get competitorsList value
     * @return \StructType\OpportunityCompetitorsList|null
     */
    public function getCompetitorsList()
    {
        return $this->competitorsList;
    }
    /**
     * Set competitorsList value
     * @param \StructType\OpportunityCompetitorsList $competitorsList
     * @return \StructType\Opportunity
     */
    public function setCompetitorsList(\StructType\OpportunityCompetitorsList $competitorsList = null)
    {
        $this->competitorsList = $competitorsList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\Opportunity
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\Opportunity
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Opportunity
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Opportunity
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Opportunity
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
