<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NexusSearchRowBasic StructType
 * @subpackage Structs
 */
class NexusSearchRowBasic extends SearchRowBasic
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $country;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $description;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The parentNexus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $parentNexus;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $state;
    /**
     * The taxAgency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $taxAgency;
    /**
     * The taxDateFromFulfillment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $taxDateFromFulfillment;
    /**
     * Constructor method for NexusSearchRowBasic
     * @uses NexusSearchRowBasic::setCountry()
     * @uses NexusSearchRowBasic::setDescription()
     * @uses NexusSearchRowBasic::setExternalId()
     * @uses NexusSearchRowBasic::setInternalId()
     * @uses NexusSearchRowBasic::setIsInactive()
     * @uses NexusSearchRowBasic::setParentNexus()
     * @uses NexusSearchRowBasic::setState()
     * @uses NexusSearchRowBasic::setTaxAgency()
     * @uses NexusSearchRowBasic::setTaxDateFromFulfillment()
     * @param \StructType\SearchColumnEnumSelectField[] $country
     * @param \StructType\SearchColumnStringField[] $description
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnSelectField[] $parentNexus
     * @param \StructType\SearchColumnSelectField[] $state
     * @param \StructType\SearchColumnSelectField[] $taxAgency
     * @param \StructType\SearchColumnBooleanField[] $taxDateFromFulfillment
     */
    public function __construct(array $country = array(), array $description = array(), array $externalId = array(), array $internalId = array(), array $isInactive = array(), array $parentNexus = array(), array $state = array(), array $taxAgency = array(), array $taxDateFromFulfillment = array())
    {
        $this
            ->setCountry($country)
            ->setDescription($description)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setIsInactive($isInactive)
            ->setParentNexus($parentNexus)
            ->setState($state)
            ->setTaxAgency($taxAgency)
            ->setTaxDateFromFulfillment($taxDateFromFulfillment);
    }
    /**
     * Get country value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * This method is responsible for validating the values passed to the setCountry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountryForArrayConstraintsFromSetCountry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nexusSearchRowBasicCountryItem) {
            // validation for constraint: itemType
            if (!$nexusSearchRowBasicCountryItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($nexusSearchRowBasicCountryItem) ? get_class($nexusSearchRowBasicCountryItem) : sprintf('%s(%s)', gettype($nexusSearchRowBasicCountryItem), var_export($nexusSearchRowBasicCountryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The country property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set country value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $country
     * @return \StructType\NexusSearchRowBasic
     */
    public function setCountry(array $country = array())
    {
        // validation for constraint: array
        if ('' !== ($countryArrayErrorMessage = self::validateCountryForArrayConstraintsFromSetCountry($country))) {
            throw new \InvalidArgumentException($countryArrayErrorMessage, __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Add item to country value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\NexusSearchRowBasic
     */
    public function addToCountry(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The country property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->country[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nexusSearchRowBasicDescriptionItem) {
            // validation for constraint: itemType
            if (!$nexusSearchRowBasicDescriptionItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($nexusSearchRowBasicDescriptionItem) ? get_class($nexusSearchRowBasicDescriptionItem) : sprintf('%s(%s)', gettype($nexusSearchRowBasicDescriptionItem), var_export($nexusSearchRowBasicDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $description
     * @return \StructType\NexusSearchRowBasic
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\NexusSearchRowBasic
     */
    public function addToDescription(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nexusSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$nexusSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($nexusSearchRowBasicExternalIdItem) ? get_class($nexusSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($nexusSearchRowBasicExternalIdItem), var_export($nexusSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\NexusSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\NexusSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nexusSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$nexusSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($nexusSearchRowBasicInternalIdItem) ? get_class($nexusSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($nexusSearchRowBasicInternalIdItem), var_export($nexusSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\NexusSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\NexusSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nexusSearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$nexusSearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($nexusSearchRowBasicIsInactiveItem) ? get_class($nexusSearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($nexusSearchRowBasicIsInactiveItem), var_export($nexusSearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\NexusSearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\NexusSearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get parentNexus value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getParentNexus()
    {
        return $this->parentNexus;
    }
    /**
     * This method is responsible for validating the values passed to the setParentNexus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParentNexus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParentNexusForArrayConstraintsFromSetParentNexus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nexusSearchRowBasicParentNexusItem) {
            // validation for constraint: itemType
            if (!$nexusSearchRowBasicParentNexusItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($nexusSearchRowBasicParentNexusItem) ? get_class($nexusSearchRowBasicParentNexusItem) : sprintf('%s(%s)', gettype($nexusSearchRowBasicParentNexusItem), var_export($nexusSearchRowBasicParentNexusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parentNexus property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parentNexus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $parentNexus
     * @return \StructType\NexusSearchRowBasic
     */
    public function setParentNexus(array $parentNexus = array())
    {
        // validation for constraint: array
        if ('' !== ($parentNexusArrayErrorMessage = self::validateParentNexusForArrayConstraintsFromSetParentNexus($parentNexus))) {
            throw new \InvalidArgumentException($parentNexusArrayErrorMessage, __LINE__);
        }
        $this->parentNexus = $parentNexus;
        return $this;
    }
    /**
     * Add item to parentNexus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\NexusSearchRowBasic
     */
    public function addToParentNexus(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The parentNexus property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parentNexus[] = $item;
        return $this;
    }
    /**
     * Get state value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * This method is responsible for validating the values passed to the setState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStateForArrayConstraintsFromSetState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nexusSearchRowBasicStateItem) {
            // validation for constraint: itemType
            if (!$nexusSearchRowBasicStateItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($nexusSearchRowBasicStateItem) ? get_class($nexusSearchRowBasicStateItem) : sprintf('%s(%s)', gettype($nexusSearchRowBasicStateItem), var_export($nexusSearchRowBasicStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The state property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set state value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $state
     * @return \StructType\NexusSearchRowBasic
     */
    public function setState(array $state = array())
    {
        // validation for constraint: array
        if ('' !== ($stateArrayErrorMessage = self::validateStateForArrayConstraintsFromSetState($state))) {
            throw new \InvalidArgumentException($stateArrayErrorMessage, __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Add item to state value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\NexusSearchRowBasic
     */
    public function addToState(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The state property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->state[] = $item;
        return $this;
    }
    /**
     * Get taxAgency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getTaxAgency()
    {
        return $this->taxAgency;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxAgency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxAgency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxAgencyForArrayConstraintsFromSetTaxAgency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nexusSearchRowBasicTaxAgencyItem) {
            // validation for constraint: itemType
            if (!$nexusSearchRowBasicTaxAgencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($nexusSearchRowBasicTaxAgencyItem) ? get_class($nexusSearchRowBasicTaxAgencyItem) : sprintf('%s(%s)', gettype($nexusSearchRowBasicTaxAgencyItem), var_export($nexusSearchRowBasicTaxAgencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxAgency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxAgency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $taxAgency
     * @return \StructType\NexusSearchRowBasic
     */
    public function setTaxAgency(array $taxAgency = array())
    {
        // validation for constraint: array
        if ('' !== ($taxAgencyArrayErrorMessage = self::validateTaxAgencyForArrayConstraintsFromSetTaxAgency($taxAgency))) {
            throw new \InvalidArgumentException($taxAgencyArrayErrorMessage, __LINE__);
        }
        $this->taxAgency = $taxAgency;
        return $this;
    }
    /**
     * Add item to taxAgency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\NexusSearchRowBasic
     */
    public function addToTaxAgency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The taxAgency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxAgency[] = $item;
        return $this;
    }
    /**
     * Get taxDateFromFulfillment value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getTaxDateFromFulfillment()
    {
        return $this->taxDateFromFulfillment;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxDateFromFulfillment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxDateFromFulfillment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxDateFromFulfillmentForArrayConstraintsFromSetTaxDateFromFulfillment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nexusSearchRowBasicTaxDateFromFulfillmentItem) {
            // validation for constraint: itemType
            if (!$nexusSearchRowBasicTaxDateFromFulfillmentItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($nexusSearchRowBasicTaxDateFromFulfillmentItem) ? get_class($nexusSearchRowBasicTaxDateFromFulfillmentItem) : sprintf('%s(%s)', gettype($nexusSearchRowBasicTaxDateFromFulfillmentItem), var_export($nexusSearchRowBasicTaxDateFromFulfillmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxDateFromFulfillment property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxDateFromFulfillment value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $taxDateFromFulfillment
     * @return \StructType\NexusSearchRowBasic
     */
    public function setTaxDateFromFulfillment(array $taxDateFromFulfillment = array())
    {
        // validation for constraint: array
        if ('' !== ($taxDateFromFulfillmentArrayErrorMessage = self::validateTaxDateFromFulfillmentForArrayConstraintsFromSetTaxDateFromFulfillment($taxDateFromFulfillment))) {
            throw new \InvalidArgumentException($taxDateFromFulfillmentArrayErrorMessage, __LINE__);
        }
        $this->taxDateFromFulfillment = $taxDateFromFulfillment;
        return $this;
    }
    /**
     * Add item to taxDateFromFulfillment value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\NexusSearchRowBasic
     */
    public function addToTaxDateFromFulfillment(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The taxDateFromFulfillment property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxDateFromFulfillment[] = $item;
        return $this;
    }
}
