<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Nexus StructType
 * @subpackage Structs
 */
class Nexus extends Record
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $state;
    /**
     * The taxAgency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxAgency;
    /**
     * The taxAgencyPst
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxAgencyPst;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The parentNexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parentNexus;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The taxDateFromFulfillment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDateFromFulfillment;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Nexus
     * @uses Nexus::setCountry()
     * @uses Nexus::setState()
     * @uses Nexus::setTaxAgency()
     * @uses Nexus::setTaxAgencyPst()
     * @uses Nexus::setTaxCode()
     * @uses Nexus::setDescription()
     * @uses Nexus::setParentNexus()
     * @uses Nexus::setIsInactive()
     * @uses Nexus::setTaxDateFromFulfillment()
     * @uses Nexus::setInternalId()
     * @uses Nexus::setExternalId()
     * @param string $country
     * @param \StructType\RecordRef $state
     * @param \StructType\RecordRef $taxAgency
     * @param \StructType\RecordRef $taxAgencyPst
     * @param \StructType\RecordRef $taxCode
     * @param string $description
     * @param \StructType\RecordRef $parentNexus
     * @param bool $isInactive
     * @param bool $taxDateFromFulfillment
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($country = null, \StructType\RecordRef $state = null, \StructType\RecordRef $taxAgency = null, \StructType\RecordRef $taxAgencyPst = null, \StructType\RecordRef $taxCode = null, $description = null, \StructType\RecordRef $parentNexus = null, $isInactive = null, $taxDateFromFulfillment = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCountry($country)
            ->setState($state)
            ->setTaxAgency($taxAgency)
            ->setTaxAgencyPst($taxAgencyPst)
            ->setTaxCode($taxCode)
            ->setDescription($description)
            ->setParentNexus($parentNexus)
            ->setIsInactive($isInactive)
            ->setTaxDateFromFulfillment($taxDateFromFulfillment)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\Nexus
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get state value
     * @return \StructType\RecordRef|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param \StructType\RecordRef $state
     * @return \StructType\Nexus
     */
    public function setState(\StructType\RecordRef $state = null)
    {
        $this->state = $state;
        return $this;
    }
    /**
     * Get taxAgency value
     * @return \StructType\RecordRef|null
     */
    public function getTaxAgency()
    {
        return $this->taxAgency;
    }
    /**
     * Set taxAgency value
     * @param \StructType\RecordRef $taxAgency
     * @return \StructType\Nexus
     */
    public function setTaxAgency(\StructType\RecordRef $taxAgency = null)
    {
        $this->taxAgency = $taxAgency;
        return $this;
    }
    /**
     * Get taxAgencyPst value
     * @return \StructType\RecordRef|null
     */
    public function getTaxAgencyPst()
    {
        return $this->taxAgencyPst;
    }
    /**
     * Set taxAgencyPst value
     * @param \StructType\RecordRef $taxAgencyPst
     * @return \StructType\Nexus
     */
    public function setTaxAgencyPst(\StructType\RecordRef $taxAgencyPst = null)
    {
        $this->taxAgencyPst = $taxAgencyPst;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\Nexus
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Nexus
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get parentNexus value
     * @return \StructType\RecordRef|null
     */
    public function getParentNexus()
    {
        return $this->parentNexus;
    }
    /**
     * Set parentNexus value
     * @param \StructType\RecordRef $parentNexus
     * @return \StructType\Nexus
     */
    public function setParentNexus(\StructType\RecordRef $parentNexus = null)
    {
        $this->parentNexus = $parentNexus;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Nexus
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get taxDateFromFulfillment value
     * @return bool|null
     */
    public function getTaxDateFromFulfillment()
    {
        return $this->taxDateFromFulfillment;
    }
    /**
     * Set taxDateFromFulfillment value
     * @param bool $taxDateFromFulfillment
     * @return \StructType\Nexus
     */
    public function setTaxDateFromFulfillment($taxDateFromFulfillment = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDateFromFulfillment) && !is_bool($taxDateFromFulfillment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDateFromFulfillment, true), gettype($taxDateFromFulfillment)), __LINE__);
        }
        $this->taxDateFromFulfillment = $taxDateFromFulfillment;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Nexus
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Nexus
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
