<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * Meta information extracted from the WSDL
 * - type: generalComm:Message
 * @subpackage Structs
 */
class Message extends Record
{
    /**
     * The author
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $author;
    /**
     * The authorEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authorEmail;
    /**
     * The recipient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $recipient;
    /**
     * The recipientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recipientEmail;
    /**
     * The cc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cc;
    /**
     * The bcc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bcc;
    /**
     * The messageDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageDate;
    /**
     * The recordName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recordName;
    /**
     * The recordTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recordTypeName;
    /**
     * The subject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subject;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The emailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $emailed;
    /**
     * The activity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $activity;
    /**
     * The compressAttachments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $compressAttachments;
    /**
     * The incoming
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $incoming;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The transaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transaction;
    /**
     * The mediaItemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageMediaItemList
     */
    public $mediaItemList;
    /**
     * The dateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateTime;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Message
     * @uses Message::setAuthor()
     * @uses Message::setAuthorEmail()
     * @uses Message::setRecipient()
     * @uses Message::setRecipientEmail()
     * @uses Message::setCc()
     * @uses Message::setBcc()
     * @uses Message::setMessageDate()
     * @uses Message::setRecordName()
     * @uses Message::setRecordTypeName()
     * @uses Message::setSubject()
     * @uses Message::setMessage()
     * @uses Message::setEmailed()
     * @uses Message::setActivity()
     * @uses Message::setCompressAttachments()
     * @uses Message::setIncoming()
     * @uses Message::setLastModifiedDate()
     * @uses Message::setTransaction()
     * @uses Message::setMediaItemList()
     * @uses Message::setDateTime()
     * @uses Message::setInternalId()
     * @uses Message::setExternalId()
     * @param \StructType\RecordRef $author
     * @param string $authorEmail
     * @param \StructType\RecordRef $recipient
     * @param string $recipientEmail
     * @param string $cc
     * @param string $bcc
     * @param string $messageDate
     * @param string $recordName
     * @param string $recordTypeName
     * @param string $subject
     * @param string $message
     * @param bool $emailed
     * @param \StructType\RecordRef $activity
     * @param bool $compressAttachments
     * @param bool $incoming
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $transaction
     * @param \StructType\MessageMediaItemList $mediaItemList
     * @param string $dateTime
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $author = null, $authorEmail = null, \StructType\RecordRef $recipient = null, $recipientEmail = null, $cc = null, $bcc = null, $messageDate = null, $recordName = null, $recordTypeName = null, $subject = null, $message = null, $emailed = null, \StructType\RecordRef $activity = null, $compressAttachments = null, $incoming = null, $lastModifiedDate = null, \StructType\RecordRef $transaction = null, \StructType\MessageMediaItemList $mediaItemList = null, $dateTime = null, $internalId = null, $externalId = null)
    {
        $this
            ->setAuthor($author)
            ->setAuthorEmail($authorEmail)
            ->setRecipient($recipient)
            ->setRecipientEmail($recipientEmail)
            ->setCc($cc)
            ->setBcc($bcc)
            ->setMessageDate($messageDate)
            ->setRecordName($recordName)
            ->setRecordTypeName($recordTypeName)
            ->setSubject($subject)
            ->setMessage($message)
            ->setEmailed($emailed)
            ->setActivity($activity)
            ->setCompressAttachments($compressAttachments)
            ->setIncoming($incoming)
            ->setLastModifiedDate($lastModifiedDate)
            ->setTransaction($transaction)
            ->setMediaItemList($mediaItemList)
            ->setDateTime($dateTime)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get author value
     * @return \StructType\RecordRef|null
     */
    public function getAuthor()
    {
        return $this->author;
    }
    /**
     * Set author value
     * @param \StructType\RecordRef $author
     * @return \StructType\Message
     */
    public function setAuthor(\StructType\RecordRef $author = null)
    {
        $this->author = $author;
        return $this;
    }
    /**
     * Get authorEmail value
     * @return string|null
     */
    public function getAuthorEmail()
    {
        return $this->authorEmail;
    }
    /**
     * Set authorEmail value
     * @param string $authorEmail
     * @return \StructType\Message
     */
    public function setAuthorEmail($authorEmail = null)
    {
        // validation for constraint: string
        if (!is_null($authorEmail) && !is_string($authorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorEmail, true), gettype($authorEmail)), __LINE__);
        }
        $this->authorEmail = $authorEmail;
        return $this;
    }
    /**
     * Get recipient value
     * @return \StructType\RecordRef|null
     */
    public function getRecipient()
    {
        return $this->recipient;
    }
    /**
     * Set recipient value
     * @param \StructType\RecordRef $recipient
     * @return \StructType\Message
     */
    public function setRecipient(\StructType\RecordRef $recipient = null)
    {
        $this->recipient = $recipient;
        return $this;
    }
    /**
     * Get recipientEmail value
     * @return string|null
     */
    public function getRecipientEmail()
    {
        return $this->recipientEmail;
    }
    /**
     * Set recipientEmail value
     * @param string $recipientEmail
     * @return \StructType\Message
     */
    public function setRecipientEmail($recipientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($recipientEmail) && !is_string($recipientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientEmail, true), gettype($recipientEmail)), __LINE__);
        }
        $this->recipientEmail = $recipientEmail;
        return $this;
    }
    /**
     * Get cc value
     * @return string|null
     */
    public function getCc()
    {
        return $this->cc;
    }
    /**
     * Set cc value
     * @param string $cc
     * @return \StructType\Message
     */
    public function setCc($cc = null)
    {
        // validation for constraint: string
        if (!is_null($cc) && !is_string($cc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cc, true), gettype($cc)), __LINE__);
        }
        $this->cc = $cc;
        return $this;
    }
    /**
     * Get bcc value
     * @return string|null
     */
    public function getBcc()
    {
        return $this->bcc;
    }
    /**
     * Set bcc value
     * @param string $bcc
     * @return \StructType\Message
     */
    public function setBcc($bcc = null)
    {
        // validation for constraint: string
        if (!is_null($bcc) && !is_string($bcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bcc, true), gettype($bcc)), __LINE__);
        }
        $this->bcc = $bcc;
        return $this;
    }
    /**
     * Get messageDate value
     * @return string|null
     */
    public function getMessageDate()
    {
        return $this->messageDate;
    }
    /**
     * Set messageDate value
     * @param string $messageDate
     * @return \StructType\Message
     */
    public function setMessageDate($messageDate = null)
    {
        // validation for constraint: string
        if (!is_null($messageDate) && !is_string($messageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageDate, true), gettype($messageDate)), __LINE__);
        }
        $this->messageDate = $messageDate;
        return $this;
    }
    /**
     * Get recordName value
     * @return string|null
     */
    public function getRecordName()
    {
        return $this->recordName;
    }
    /**
     * Set recordName value
     * @param string $recordName
     * @return \StructType\Message
     */
    public function setRecordName($recordName = null)
    {
        // validation for constraint: string
        if (!is_null($recordName) && !is_string($recordName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordName, true), gettype($recordName)), __LINE__);
        }
        $this->recordName = $recordName;
        return $this;
    }
    /**
     * Get recordTypeName value
     * @return string|null
     */
    public function getRecordTypeName()
    {
        return $this->recordTypeName;
    }
    /**
     * Set recordTypeName value
     * @param string $recordTypeName
     * @return \StructType\Message
     */
    public function setRecordTypeName($recordTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($recordTypeName) && !is_string($recordTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordTypeName, true), gettype($recordTypeName)), __LINE__);
        }
        $this->recordTypeName = $recordTypeName;
        return $this;
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \StructType\Message
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Message
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get emailed value
     * @return bool|null
     */
    public function getEmailed()
    {
        return $this->emailed;
    }
    /**
     * Set emailed value
     * @param bool $emailed
     * @return \StructType\Message
     */
    public function setEmailed($emailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailed) && !is_bool($emailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailed, true), gettype($emailed)), __LINE__);
        }
        $this->emailed = $emailed;
        return $this;
    }
    /**
     * Get activity value
     * @return \StructType\RecordRef|null
     */
    public function getActivity()
    {
        return $this->activity;
    }
    /**
     * Set activity value
     * @param \StructType\RecordRef $activity
     * @return \StructType\Message
     */
    public function setActivity(\StructType\RecordRef $activity = null)
    {
        $this->activity = $activity;
        return $this;
    }
    /**
     * Get compressAttachments value
     * @return bool|null
     */
    public function getCompressAttachments()
    {
        return $this->compressAttachments;
    }
    /**
     * Set compressAttachments value
     * @param bool $compressAttachments
     * @return \StructType\Message
     */
    public function setCompressAttachments($compressAttachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($compressAttachments) && !is_bool($compressAttachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compressAttachments, true), gettype($compressAttachments)), __LINE__);
        }
        $this->compressAttachments = $compressAttachments;
        return $this;
    }
    /**
     * Get incoming value
     * @return bool|null
     */
    public function getIncoming()
    {
        return $this->incoming;
    }
    /**
     * Set incoming value
     * @param bool $incoming
     * @return \StructType\Message
     */
    public function setIncoming($incoming = null)
    {
        // validation for constraint: boolean
        if (!is_null($incoming) && !is_bool($incoming)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($incoming, true), gettype($incoming)), __LINE__);
        }
        $this->incoming = $incoming;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Message
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get transaction value
     * @return \StructType\RecordRef|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @param \StructType\RecordRef $transaction
     * @return \StructType\Message
     */
    public function setTransaction(\StructType\RecordRef $transaction = null)
    {
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Get mediaItemList value
     * @return \StructType\MessageMediaItemList|null
     */
    public function getMediaItemList()
    {
        return $this->mediaItemList;
    }
    /**
     * Set mediaItemList value
     * @param \StructType\MessageMediaItemList $mediaItemList
     * @return \StructType\Message
     */
    public function setMediaItemList(\StructType\MessageMediaItemList $mediaItemList = null)
    {
        $this->mediaItemList = $mediaItemList;
        return $this;
    }
    /**
     * Get dateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->dateTime;
    }
    /**
     * Set dateTime value
     * @param string $dateTime
     * @return \StructType\Message
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->dateTime = $dateTime;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Message
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Message
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
