<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManufacturingRoutingRoutingStep StructType
 * @subpackage Structs
 */
class ManufacturingRoutingRoutingStep extends AbstractStructBase
{
    /**
     * The operationSequence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationSequence;
    /**
     * The operationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationName;
    /**
     * The manufacturingWorkCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $manufacturingWorkCenter;
    /**
     * The machineResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $machineResources;
    /**
     * The laborResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $laborResources;
    /**
     * The manufacturingCostTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $manufacturingCostTemplate;
    /**
     * The setupTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $setupTime;
    /**
     * The runRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $runRate;
    /**
     * The lagType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lagType;
    /**
     * The lagAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lagAmount;
    /**
     * The lagUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lagUnits;
    /**
     * Constructor method for ManufacturingRoutingRoutingStep
     * @uses ManufacturingRoutingRoutingStep::setOperationSequence()
     * @uses ManufacturingRoutingRoutingStep::setOperationName()
     * @uses ManufacturingRoutingRoutingStep::setManufacturingWorkCenter()
     * @uses ManufacturingRoutingRoutingStep::setMachineResources()
     * @uses ManufacturingRoutingRoutingStep::setLaborResources()
     * @uses ManufacturingRoutingRoutingStep::setManufacturingCostTemplate()
     * @uses ManufacturingRoutingRoutingStep::setSetupTime()
     * @uses ManufacturingRoutingRoutingStep::setRunRate()
     * @uses ManufacturingRoutingRoutingStep::setLagType()
     * @uses ManufacturingRoutingRoutingStep::setLagAmount()
     * @uses ManufacturingRoutingRoutingStep::setLagUnits()
     * @param int $operationSequence
     * @param string $operationName
     * @param \StructType\RecordRef $manufacturingWorkCenter
     * @param float $machineResources
     * @param float $laborResources
     * @param \StructType\RecordRef $manufacturingCostTemplate
     * @param float $setupTime
     * @param float $runRate
     * @param string $lagType
     * @param int $lagAmount
     * @param string $lagUnits
     */
    public function __construct($operationSequence = null, $operationName = null, \StructType\RecordRef $manufacturingWorkCenter = null, $machineResources = null, $laborResources = null, \StructType\RecordRef $manufacturingCostTemplate = null, $setupTime = null, $runRate = null, $lagType = null, $lagAmount = null, $lagUnits = null)
    {
        $this
            ->setOperationSequence($operationSequence)
            ->setOperationName($operationName)
            ->setManufacturingWorkCenter($manufacturingWorkCenter)
            ->setMachineResources($machineResources)
            ->setLaborResources($laborResources)
            ->setManufacturingCostTemplate($manufacturingCostTemplate)
            ->setSetupTime($setupTime)
            ->setRunRate($runRate)
            ->setLagType($lagType)
            ->setLagAmount($lagAmount)
            ->setLagUnits($lagUnits);
    }
    /**
     * Get operationSequence value
     * @return int|null
     */
    public function getOperationSequence()
    {
        return $this->operationSequence;
    }
    /**
     * Set operationSequence value
     * @param int $operationSequence
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setOperationSequence($operationSequence = null)
    {
        // validation for constraint: int
        if (!is_null($operationSequence) && !(is_int($operationSequence) || ctype_digit($operationSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationSequence, true), gettype($operationSequence)), __LINE__);
        }
        $this->operationSequence = $operationSequence;
        return $this;
    }
    /**
     * Get operationName value
     * @return string|null
     */
    public function getOperationName()
    {
        return $this->operationName;
    }
    /**
     * Set operationName value
     * @param string $operationName
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setOperationName($operationName = null)
    {
        // validation for constraint: string
        if (!is_null($operationName) && !is_string($operationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationName, true), gettype($operationName)), __LINE__);
        }
        $this->operationName = $operationName;
        return $this;
    }
    /**
     * Get manufacturingWorkCenter value
     * @return \StructType\RecordRef|null
     */
    public function getManufacturingWorkCenter()
    {
        return $this->manufacturingWorkCenter;
    }
    /**
     * Set manufacturingWorkCenter value
     * @param \StructType\RecordRef $manufacturingWorkCenter
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setManufacturingWorkCenter(\StructType\RecordRef $manufacturingWorkCenter = null)
    {
        $this->manufacturingWorkCenter = $manufacturingWorkCenter;
        return $this;
    }
    /**
     * Get machineResources value
     * @return float|null
     */
    public function getMachineResources()
    {
        return $this->machineResources;
    }
    /**
     * Set machineResources value
     * @param float $machineResources
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setMachineResources($machineResources = null)
    {
        // validation for constraint: float
        if (!is_null($machineResources) && !(is_float($machineResources) || is_numeric($machineResources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($machineResources, true), gettype($machineResources)), __LINE__);
        }
        $this->machineResources = $machineResources;
        return $this;
    }
    /**
     * Get laborResources value
     * @return float|null
     */
    public function getLaborResources()
    {
        return $this->laborResources;
    }
    /**
     * Set laborResources value
     * @param float $laborResources
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setLaborResources($laborResources = null)
    {
        // validation for constraint: float
        if (!is_null($laborResources) && !(is_float($laborResources) || is_numeric($laborResources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laborResources, true), gettype($laborResources)), __LINE__);
        }
        $this->laborResources = $laborResources;
        return $this;
    }
    /**
     * Get manufacturingCostTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getManufacturingCostTemplate()
    {
        return $this->manufacturingCostTemplate;
    }
    /**
     * Set manufacturingCostTemplate value
     * @param \StructType\RecordRef $manufacturingCostTemplate
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setManufacturingCostTemplate(\StructType\RecordRef $manufacturingCostTemplate = null)
    {
        $this->manufacturingCostTemplate = $manufacturingCostTemplate;
        return $this;
    }
    /**
     * Get setupTime value
     * @return float|null
     */
    public function getSetupTime()
    {
        return $this->setupTime;
    }
    /**
     * Set setupTime value
     * @param float $setupTime
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setSetupTime($setupTime = null)
    {
        // validation for constraint: float
        if (!is_null($setupTime) && !(is_float($setupTime) || is_numeric($setupTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($setupTime, true), gettype($setupTime)), __LINE__);
        }
        $this->setupTime = $setupTime;
        return $this;
    }
    /**
     * Get runRate value
     * @return float|null
     */
    public function getRunRate()
    {
        return $this->runRate;
    }
    /**
     * Set runRate value
     * @param float $runRate
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setRunRate($runRate = null)
    {
        // validation for constraint: float
        if (!is_null($runRate) && !(is_float($runRate) || is_numeric($runRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($runRate, true), gettype($runRate)), __LINE__);
        }
        $this->runRate = $runRate;
        return $this;
    }
    /**
     * Get lagType value
     * @return string|null
     */
    public function getLagType()
    {
        return $this->lagType;
    }
    /**
     * Set lagType value
     * @uses \EnumType\ManufacturingLagType::valueIsValid()
     * @uses \EnumType\ManufacturingLagType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lagType
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setLagType($lagType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ManufacturingLagType::valueIsValid($lagType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ManufacturingLagType', is_array($lagType) ? implode(', ', $lagType) : var_export($lagType, true), implode(', ', \EnumType\ManufacturingLagType::getValidValues())), __LINE__);
        }
        $this->lagType = $lagType;
        return $this;
    }
    /**
     * Get lagAmount value
     * @return int|null
     */
    public function getLagAmount()
    {
        return $this->lagAmount;
    }
    /**
     * Set lagAmount value
     * @param int $lagAmount
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setLagAmount($lagAmount = null)
    {
        // validation for constraint: int
        if (!is_null($lagAmount) && !(is_int($lagAmount) || ctype_digit($lagAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lagAmount, true), gettype($lagAmount)), __LINE__);
        }
        $this->lagAmount = $lagAmount;
        return $this;
    }
    /**
     * Get lagUnits value
     * @return string|null
     */
    public function getLagUnits()
    {
        return $this->lagUnits;
    }
    /**
     * Set lagUnits value
     * @param string $lagUnits
     * @return \StructType\ManufacturingRoutingRoutingStep
     */
    public function setLagUnits($lagUnits = null)
    {
        // validation for constraint: string
        if (!is_null($lagUnits) && !is_string($lagUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lagUnits, true), gettype($lagUnits)), __LINE__);
        }
        $this->lagUnits = $lagUnits;
        return $this;
    }
}
