<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationSearchRowBasic StructType
 * @subpackage Structs
 */
class LocationSearchRowBasic extends SearchRowBasic
{
    /**
     * The address1
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $address1;
    /**
     * The address2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $address2;
    /**
     * The address3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $address3;
    /**
     * The allowStorePickup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $allowStorePickup;
    /**
     * The autoAssignmentRegionSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $autoAssignmentRegionSetting;
    /**
     * The bufferStock
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $bufferStock;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $country;
    /**
     * The dailyShippingCapacity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $dailyShippingCapacity;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $endTime;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The geolocationMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $geolocationMethod;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isFriday
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isFriday;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The isIncludeInCt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isIncludeInCt;
    /**
     * The isMonday
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isMonday;
    /**
     * The isOffice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isOffice;
    /**
     * The isSaturday
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isSaturday;
    /**
     * The isSunday
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isSunday;
    /**
     * The isThursday
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isThursday;
    /**
     * The isTuesday
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isTuesday;
    /**
     * The isWednesday
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isWednesday;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $latitude;
    /**
     * The locationType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $locationType;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $longitude;
    /**
     * The makeInventoryAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $makeInventoryAvailable;
    /**
     * The makeInventoryAvailableStore
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $makeInventoryAvailableStore;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * The nameNoHierarchy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $nameNoHierarchy;
    /**
     * The nextPickupCutOffTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $nextPickupCutOffTime;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $phone;
    /**
     * The sameDayPickupCutOffTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $sameDayPickupCutOffTime;
    /**
     * The startTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $startTime;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $state;
    /**
     * The storePickupBufferStock
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $storePickupBufferStock;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiary;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $timeZone;
    /**
     * The totalShippingCapacity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $totalShippingCapacity;
    /**
     * The tranPrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $tranPrefix;
    /**
     * The usesBins
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $usesBins;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $zip;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for LocationSearchRowBasic
     * @uses LocationSearchRowBasic::setAddress1()
     * @uses LocationSearchRowBasic::setAddress2()
     * @uses LocationSearchRowBasic::setAddress3()
     * @uses LocationSearchRowBasic::setAllowStorePickup()
     * @uses LocationSearchRowBasic::setAutoAssignmentRegionSetting()
     * @uses LocationSearchRowBasic::setBufferStock()
     * @uses LocationSearchRowBasic::setCity()
     * @uses LocationSearchRowBasic::setCountry()
     * @uses LocationSearchRowBasic::setDailyShippingCapacity()
     * @uses LocationSearchRowBasic::setEndTime()
     * @uses LocationSearchRowBasic::setExternalId()
     * @uses LocationSearchRowBasic::setGeolocationMethod()
     * @uses LocationSearchRowBasic::setInternalId()
     * @uses LocationSearchRowBasic::setIsFriday()
     * @uses LocationSearchRowBasic::setIsInactive()
     * @uses LocationSearchRowBasic::setIsIncludeInCt()
     * @uses LocationSearchRowBasic::setIsMonday()
     * @uses LocationSearchRowBasic::setIsOffice()
     * @uses LocationSearchRowBasic::setIsSaturday()
     * @uses LocationSearchRowBasic::setIsSunday()
     * @uses LocationSearchRowBasic::setIsThursday()
     * @uses LocationSearchRowBasic::setIsTuesday()
     * @uses LocationSearchRowBasic::setIsWednesday()
     * @uses LocationSearchRowBasic::setLatitude()
     * @uses LocationSearchRowBasic::setLocationType()
     * @uses LocationSearchRowBasic::setLongitude()
     * @uses LocationSearchRowBasic::setMakeInventoryAvailable()
     * @uses LocationSearchRowBasic::setMakeInventoryAvailableStore()
     * @uses LocationSearchRowBasic::setName()
     * @uses LocationSearchRowBasic::setNameNoHierarchy()
     * @uses LocationSearchRowBasic::setNextPickupCutOffTime()
     * @uses LocationSearchRowBasic::setPhone()
     * @uses LocationSearchRowBasic::setSameDayPickupCutOffTime()
     * @uses LocationSearchRowBasic::setStartTime()
     * @uses LocationSearchRowBasic::setState()
     * @uses LocationSearchRowBasic::setStorePickupBufferStock()
     * @uses LocationSearchRowBasic::setSubsidiary()
     * @uses LocationSearchRowBasic::setTimeZone()
     * @uses LocationSearchRowBasic::setTotalShippingCapacity()
     * @uses LocationSearchRowBasic::setTranPrefix()
     * @uses LocationSearchRowBasic::setUsesBins()
     * @uses LocationSearchRowBasic::setZip()
     * @uses LocationSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnStringField[] $address1
     * @param \StructType\SearchColumnStringField[] $address2
     * @param \StructType\SearchColumnStringField[] $address3
     * @param \StructType\SearchColumnBooleanField[] $allowStorePickup
     * @param \StructType\SearchColumnEnumSelectField[] $autoAssignmentRegionSetting
     * @param \StructType\SearchColumnLongField[] $bufferStock
     * @param \StructType\SearchColumnStringField[] $city
     * @param \StructType\SearchColumnEnumSelectField[] $country
     * @param \StructType\SearchColumnLongField[] $dailyShippingCapacity
     * @param \StructType\SearchColumnDateField[] $endTime
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnEnumSelectField[] $geolocationMethod
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isFriday
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnBooleanField[] $isIncludeInCt
     * @param \StructType\SearchColumnBooleanField[] $isMonday
     * @param \StructType\SearchColumnBooleanField[] $isOffice
     * @param \StructType\SearchColumnBooleanField[] $isSaturday
     * @param \StructType\SearchColumnBooleanField[] $isSunday
     * @param \StructType\SearchColumnBooleanField[] $isThursday
     * @param \StructType\SearchColumnBooleanField[] $isTuesday
     * @param \StructType\SearchColumnBooleanField[] $isWednesday
     * @param \StructType\SearchColumnDoubleField[] $latitude
     * @param \StructType\SearchColumnEnumSelectField[] $locationType
     * @param \StructType\SearchColumnDoubleField[] $longitude
     * @param \StructType\SearchColumnBooleanField[] $makeInventoryAvailable
     * @param \StructType\SearchColumnBooleanField[] $makeInventoryAvailableStore
     * @param \StructType\SearchColumnStringField[] $name
     * @param \StructType\SearchColumnStringField[] $nameNoHierarchy
     * @param \StructType\SearchColumnDateField[] $nextPickupCutOffTime
     * @param \StructType\SearchColumnStringField[] $phone
     * @param \StructType\SearchColumnDateField[] $sameDayPickupCutOffTime
     * @param \StructType\SearchColumnDateField[] $startTime
     * @param \StructType\SearchColumnStringField[] $state
     * @param \StructType\SearchColumnDoubleField[] $storePickupBufferStock
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @param \StructType\SearchColumnEnumSelectField[] $timeZone
     * @param \StructType\SearchColumnLongField[] $totalShippingCapacity
     * @param \StructType\SearchColumnStringField[] $tranPrefix
     * @param \StructType\SearchColumnBooleanField[] $usesBins
     * @param \StructType\SearchColumnStringField[] $zip
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $address1 = array(), array $address2 = array(), array $address3 = array(), array $allowStorePickup = array(), array $autoAssignmentRegionSetting = array(), array $bufferStock = array(), array $city = array(), array $country = array(), array $dailyShippingCapacity = array(), array $endTime = array(), array $externalId = array(), array $geolocationMethod = array(), array $internalId = array(), array $isFriday = array(), array $isInactive = array(), array $isIncludeInCt = array(), array $isMonday = array(), array $isOffice = array(), array $isSaturday = array(), array $isSunday = array(), array $isThursday = array(), array $isTuesday = array(), array $isWednesday = array(), array $latitude = array(), array $locationType = array(), array $longitude = array(), array $makeInventoryAvailable = array(), array $makeInventoryAvailableStore = array(), array $name = array(), array $nameNoHierarchy = array(), array $nextPickupCutOffTime = array(), array $phone = array(), array $sameDayPickupCutOffTime = array(), array $startTime = array(), array $state = array(), array $storePickupBufferStock = array(), array $subsidiary = array(), array $timeZone = array(), array $totalShippingCapacity = array(), array $tranPrefix = array(), array $usesBins = array(), array $zip = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAllowStorePickup($allowStorePickup)
            ->setAutoAssignmentRegionSetting($autoAssignmentRegionSetting)
            ->setBufferStock($bufferStock)
            ->setCity($city)
            ->setCountry($country)
            ->setDailyShippingCapacity($dailyShippingCapacity)
            ->setEndTime($endTime)
            ->setExternalId($externalId)
            ->setGeolocationMethod($geolocationMethod)
            ->setInternalId($internalId)
            ->setIsFriday($isFriday)
            ->setIsInactive($isInactive)
            ->setIsIncludeInCt($isIncludeInCt)
            ->setIsMonday($isMonday)
            ->setIsOffice($isOffice)
            ->setIsSaturday($isSaturday)
            ->setIsSunday($isSunday)
            ->setIsThursday($isThursday)
            ->setIsTuesday($isTuesday)
            ->setIsWednesday($isWednesday)
            ->setLatitude($latitude)
            ->setLocationType($locationType)
            ->setLongitude($longitude)
            ->setMakeInventoryAvailable($makeInventoryAvailable)
            ->setMakeInventoryAvailableStore($makeInventoryAvailableStore)
            ->setName($name)
            ->setNameNoHierarchy($nameNoHierarchy)
            ->setNextPickupCutOffTime($nextPickupCutOffTime)
            ->setPhone($phone)
            ->setSameDayPickupCutOffTime($sameDayPickupCutOffTime)
            ->setStartTime($startTime)
            ->setState($state)
            ->setStorePickupBufferStock($storePickupBufferStock)
            ->setSubsidiary($subsidiary)
            ->setTimeZone($timeZone)
            ->setTotalShippingCapacity($totalShippingCapacity)
            ->setTranPrefix($tranPrefix)
            ->setUsesBins($usesBins)
            ->setZip($zip)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get address1 value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress1 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress1 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress1ForArrayConstraintsFromSetAddress1(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicAddress1Item) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicAddress1Item instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicAddress1Item) ? get_class($locationSearchRowBasicAddress1Item) : sprintf('%s(%s)', gettype($locationSearchRowBasicAddress1Item), var_export($locationSearchRowBasicAddress1Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address1 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address1 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $address1
     * @return \StructType\LocationSearchRowBasic
     */
    public function setAddress1(array $address1 = array())
    {
        // validation for constraint: array
        if ('' !== ($address1ArrayErrorMessage = self::validateAddress1ForArrayConstraintsFromSetAddress1($address1))) {
            throw new \InvalidArgumentException($address1ArrayErrorMessage, __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Add item to address1 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToAddress1(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The address1 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->address1[] = $item;
        return $this;
    }
    /**
     * Get address2 value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress2ForArrayConstraintsFromSetAddress2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicAddress2Item) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicAddress2Item instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicAddress2Item) ? get_class($locationSearchRowBasicAddress2Item) : sprintf('%s(%s)', gettype($locationSearchRowBasicAddress2Item), var_export($locationSearchRowBasicAddress2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address2 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $address2
     * @return \StructType\LocationSearchRowBasic
     */
    public function setAddress2(array $address2 = array())
    {
        // validation for constraint: array
        if ('' !== ($address2ArrayErrorMessage = self::validateAddress2ForArrayConstraintsFromSetAddress2($address2))) {
            throw new \InvalidArgumentException($address2ArrayErrorMessage, __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Add item to address2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToAddress2(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The address2 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->address2[] = $item;
        return $this;
    }
    /**
     * Get address3 value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAddress3()
    {
        return $this->address3;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress3ForArrayConstraintsFromSetAddress3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicAddress3Item) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicAddress3Item instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicAddress3Item) ? get_class($locationSearchRowBasicAddress3Item) : sprintf('%s(%s)', gettype($locationSearchRowBasicAddress3Item), var_export($locationSearchRowBasicAddress3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address3 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address3 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $address3
     * @return \StructType\LocationSearchRowBasic
     */
    public function setAddress3(array $address3 = array())
    {
        // validation for constraint: array
        if ('' !== ($address3ArrayErrorMessage = self::validateAddress3ForArrayConstraintsFromSetAddress3($address3))) {
            throw new \InvalidArgumentException($address3ArrayErrorMessage, __LINE__);
        }
        $this->address3 = $address3;
        return $this;
    }
    /**
     * Add item to address3 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToAddress3(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The address3 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->address3[] = $item;
        return $this;
    }
    /**
     * Get allowStorePickup value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getAllowStorePickup()
    {
        return $this->allowStorePickup;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowStorePickup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowStorePickup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowStorePickupForArrayConstraintsFromSetAllowStorePickup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicAllowStorePickupItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicAllowStorePickupItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicAllowStorePickupItem) ? get_class($locationSearchRowBasicAllowStorePickupItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicAllowStorePickupItem), var_export($locationSearchRowBasicAllowStorePickupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The allowStorePickup property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set allowStorePickup value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $allowStorePickup
     * @return \StructType\LocationSearchRowBasic
     */
    public function setAllowStorePickup(array $allowStorePickup = array())
    {
        // validation for constraint: array
        if ('' !== ($allowStorePickupArrayErrorMessage = self::validateAllowStorePickupForArrayConstraintsFromSetAllowStorePickup($allowStorePickup))) {
            throw new \InvalidArgumentException($allowStorePickupArrayErrorMessage, __LINE__);
        }
        $this->allowStorePickup = $allowStorePickup;
        return $this;
    }
    /**
     * Add item to allowStorePickup value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToAllowStorePickup(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The allowStorePickup property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->allowStorePickup[] = $item;
        return $this;
    }
    /**
     * Get autoAssignmentRegionSetting value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getAutoAssignmentRegionSetting()
    {
        return $this->autoAssignmentRegionSetting;
    }
    /**
     * This method is responsible for validating the values passed to the setAutoAssignmentRegionSetting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAutoAssignmentRegionSetting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAutoAssignmentRegionSettingForArrayConstraintsFromSetAutoAssignmentRegionSetting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicAutoAssignmentRegionSettingItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicAutoAssignmentRegionSettingItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($locationSearchRowBasicAutoAssignmentRegionSettingItem) ? get_class($locationSearchRowBasicAutoAssignmentRegionSettingItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicAutoAssignmentRegionSettingItem), var_export($locationSearchRowBasicAutoAssignmentRegionSettingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The autoAssignmentRegionSetting property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set autoAssignmentRegionSetting value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $autoAssignmentRegionSetting
     * @return \StructType\LocationSearchRowBasic
     */
    public function setAutoAssignmentRegionSetting(array $autoAssignmentRegionSetting = array())
    {
        // validation for constraint: array
        if ('' !== ($autoAssignmentRegionSettingArrayErrorMessage = self::validateAutoAssignmentRegionSettingForArrayConstraintsFromSetAutoAssignmentRegionSetting($autoAssignmentRegionSetting))) {
            throw new \InvalidArgumentException($autoAssignmentRegionSettingArrayErrorMessage, __LINE__);
        }
        $this->autoAssignmentRegionSetting = $autoAssignmentRegionSetting;
        return $this;
    }
    /**
     * Add item to autoAssignmentRegionSetting value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToAutoAssignmentRegionSetting(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The autoAssignmentRegionSetting property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->autoAssignmentRegionSetting[] = $item;
        return $this;
    }
    /**
     * Get bufferStock value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getBufferStock()
    {
        return $this->bufferStock;
    }
    /**
     * This method is responsible for validating the values passed to the setBufferStock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBufferStock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBufferStockForArrayConstraintsFromSetBufferStock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicBufferStockItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicBufferStockItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($locationSearchRowBasicBufferStockItem) ? get_class($locationSearchRowBasicBufferStockItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicBufferStockItem), var_export($locationSearchRowBasicBufferStockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bufferStock property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bufferStock value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $bufferStock
     * @return \StructType\LocationSearchRowBasic
     */
    public function setBufferStock(array $bufferStock = array())
    {
        // validation for constraint: array
        if ('' !== ($bufferStockArrayErrorMessage = self::validateBufferStockForArrayConstraintsFromSetBufferStock($bufferStock))) {
            throw new \InvalidArgumentException($bufferStockArrayErrorMessage, __LINE__);
        }
        $this->bufferStock = $bufferStock;
        return $this;
    }
    /**
     * Add item to bufferStock value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToBufferStock(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The bufferStock property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bufferStock[] = $item;
        return $this;
    }
    /**
     * Get city value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * This method is responsible for validating the values passed to the setCity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCityForArrayConstraintsFromSetCity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicCityItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicCityItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicCityItem) ? get_class($locationSearchRowBasicCityItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicCityItem), var_export($locationSearchRowBasicCityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The city property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set city value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $city
     * @return \StructType\LocationSearchRowBasic
     */
    public function setCity(array $city = array())
    {
        // validation for constraint: array
        if ('' !== ($cityArrayErrorMessage = self::validateCityForArrayConstraintsFromSetCity($city))) {
            throw new \InvalidArgumentException($cityArrayErrorMessage, __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Add item to city value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToCity(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The city property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->city[] = $item;
        return $this;
    }
    /**
     * Get country value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * This method is responsible for validating the values passed to the setCountry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountryForArrayConstraintsFromSetCountry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicCountryItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicCountryItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($locationSearchRowBasicCountryItem) ? get_class($locationSearchRowBasicCountryItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicCountryItem), var_export($locationSearchRowBasicCountryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The country property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set country value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $country
     * @return \StructType\LocationSearchRowBasic
     */
    public function setCountry(array $country = array())
    {
        // validation for constraint: array
        if ('' !== ($countryArrayErrorMessage = self::validateCountryForArrayConstraintsFromSetCountry($country))) {
            throw new \InvalidArgumentException($countryArrayErrorMessage, __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Add item to country value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToCountry(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The country property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->country[] = $item;
        return $this;
    }
    /**
     * Get dailyShippingCapacity value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getDailyShippingCapacity()
    {
        return $this->dailyShippingCapacity;
    }
    /**
     * This method is responsible for validating the values passed to the setDailyShippingCapacity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDailyShippingCapacity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDailyShippingCapacityForArrayConstraintsFromSetDailyShippingCapacity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicDailyShippingCapacityItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicDailyShippingCapacityItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($locationSearchRowBasicDailyShippingCapacityItem) ? get_class($locationSearchRowBasicDailyShippingCapacityItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicDailyShippingCapacityItem), var_export($locationSearchRowBasicDailyShippingCapacityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dailyShippingCapacity property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dailyShippingCapacity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $dailyShippingCapacity
     * @return \StructType\LocationSearchRowBasic
     */
    public function setDailyShippingCapacity(array $dailyShippingCapacity = array())
    {
        // validation for constraint: array
        if ('' !== ($dailyShippingCapacityArrayErrorMessage = self::validateDailyShippingCapacityForArrayConstraintsFromSetDailyShippingCapacity($dailyShippingCapacity))) {
            throw new \InvalidArgumentException($dailyShippingCapacityArrayErrorMessage, __LINE__);
        }
        $this->dailyShippingCapacity = $dailyShippingCapacity;
        return $this;
    }
    /**
     * Add item to dailyShippingCapacity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToDailyShippingCapacity(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The dailyShippingCapacity property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dailyShippingCapacity[] = $item;
        return $this;
    }
    /**
     * Get endTime value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * This method is responsible for validating the values passed to the setEndTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndTimeForArrayConstraintsFromSetEndTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicEndTimeItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicEndTimeItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($locationSearchRowBasicEndTimeItem) ? get_class($locationSearchRowBasicEndTimeItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicEndTimeItem), var_export($locationSearchRowBasicEndTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The endTime property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set endTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $endTime
     * @return \StructType\LocationSearchRowBasic
     */
    public function setEndTime(array $endTime = array())
    {
        // validation for constraint: array
        if ('' !== ($endTimeArrayErrorMessage = self::validateEndTimeForArrayConstraintsFromSetEndTime($endTime))) {
            throw new \InvalidArgumentException($endTimeArrayErrorMessage, __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Add item to endTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToEndTime(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The endTime property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->endTime[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($locationSearchRowBasicExternalIdItem) ? get_class($locationSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicExternalIdItem), var_export($locationSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\LocationSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get geolocationMethod value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getGeolocationMethod()
    {
        return $this->geolocationMethod;
    }
    /**
     * This method is responsible for validating the values passed to the setGeolocationMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeolocationMethod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeolocationMethodForArrayConstraintsFromSetGeolocationMethod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicGeolocationMethodItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicGeolocationMethodItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($locationSearchRowBasicGeolocationMethodItem) ? get_class($locationSearchRowBasicGeolocationMethodItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicGeolocationMethodItem), var_export($locationSearchRowBasicGeolocationMethodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The geolocationMethod property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set geolocationMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $geolocationMethod
     * @return \StructType\LocationSearchRowBasic
     */
    public function setGeolocationMethod(array $geolocationMethod = array())
    {
        // validation for constraint: array
        if ('' !== ($geolocationMethodArrayErrorMessage = self::validateGeolocationMethodForArrayConstraintsFromSetGeolocationMethod($geolocationMethod))) {
            throw new \InvalidArgumentException($geolocationMethodArrayErrorMessage, __LINE__);
        }
        $this->geolocationMethod = $geolocationMethod;
        return $this;
    }
    /**
     * Add item to geolocationMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToGeolocationMethod(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The geolocationMethod property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->geolocationMethod[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($locationSearchRowBasicInternalIdItem) ? get_class($locationSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicInternalIdItem), var_export($locationSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\LocationSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isFriday value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsFriday()
    {
        return $this->isFriday;
    }
    /**
     * This method is responsible for validating the values passed to the setIsFriday method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsFriday method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsFridayForArrayConstraintsFromSetIsFriday(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsFridayItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsFridayItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsFridayItem) ? get_class($locationSearchRowBasicIsFridayItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsFridayItem), var_export($locationSearchRowBasicIsFridayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isFriday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isFriday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isFriday
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsFriday(array $isFriday = array())
    {
        // validation for constraint: array
        if ('' !== ($isFridayArrayErrorMessage = self::validateIsFridayForArrayConstraintsFromSetIsFriday($isFriday))) {
            throw new \InvalidArgumentException($isFridayArrayErrorMessage, __LINE__);
        }
        $this->isFriday = $isFriday;
        return $this;
    }
    /**
     * Add item to isFriday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsFriday(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isFriday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isFriday[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsInactiveItem) ? get_class($locationSearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsInactiveItem), var_export($locationSearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get isIncludeInCt value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsIncludeInCt()
    {
        return $this->isIncludeInCt;
    }
    /**
     * This method is responsible for validating the values passed to the setIsIncludeInCt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsIncludeInCt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsIncludeInCtForArrayConstraintsFromSetIsIncludeInCt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsIncludeInCtItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsIncludeInCtItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsIncludeInCtItem) ? get_class($locationSearchRowBasicIsIncludeInCtItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsIncludeInCtItem), var_export($locationSearchRowBasicIsIncludeInCtItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isIncludeInCt property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isIncludeInCt value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isIncludeInCt
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsIncludeInCt(array $isIncludeInCt = array())
    {
        // validation for constraint: array
        if ('' !== ($isIncludeInCtArrayErrorMessage = self::validateIsIncludeInCtForArrayConstraintsFromSetIsIncludeInCt($isIncludeInCt))) {
            throw new \InvalidArgumentException($isIncludeInCtArrayErrorMessage, __LINE__);
        }
        $this->isIncludeInCt = $isIncludeInCt;
        return $this;
    }
    /**
     * Add item to isIncludeInCt value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsIncludeInCt(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isIncludeInCt property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isIncludeInCt[] = $item;
        return $this;
    }
    /**
     * Get isMonday value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsMonday()
    {
        return $this->isMonday;
    }
    /**
     * This method is responsible for validating the values passed to the setIsMonday method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsMonday method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsMondayForArrayConstraintsFromSetIsMonday(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsMondayItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsMondayItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsMondayItem) ? get_class($locationSearchRowBasicIsMondayItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsMondayItem), var_export($locationSearchRowBasicIsMondayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isMonday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isMonday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isMonday
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsMonday(array $isMonday = array())
    {
        // validation for constraint: array
        if ('' !== ($isMondayArrayErrorMessage = self::validateIsMondayForArrayConstraintsFromSetIsMonday($isMonday))) {
            throw new \InvalidArgumentException($isMondayArrayErrorMessage, __LINE__);
        }
        $this->isMonday = $isMonday;
        return $this;
    }
    /**
     * Add item to isMonday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsMonday(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isMonday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isMonday[] = $item;
        return $this;
    }
    /**
     * Get isOffice value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsOffice()
    {
        return $this->isOffice;
    }
    /**
     * This method is responsible for validating the values passed to the setIsOffice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsOffice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsOfficeForArrayConstraintsFromSetIsOffice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsOfficeItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsOfficeItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsOfficeItem) ? get_class($locationSearchRowBasicIsOfficeItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsOfficeItem), var_export($locationSearchRowBasicIsOfficeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isOffice property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isOffice value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isOffice
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsOffice(array $isOffice = array())
    {
        // validation for constraint: array
        if ('' !== ($isOfficeArrayErrorMessage = self::validateIsOfficeForArrayConstraintsFromSetIsOffice($isOffice))) {
            throw new \InvalidArgumentException($isOfficeArrayErrorMessage, __LINE__);
        }
        $this->isOffice = $isOffice;
        return $this;
    }
    /**
     * Add item to isOffice value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsOffice(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isOffice property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isOffice[] = $item;
        return $this;
    }
    /**
     * Get isSaturday value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsSaturday()
    {
        return $this->isSaturday;
    }
    /**
     * This method is responsible for validating the values passed to the setIsSaturday method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsSaturday method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsSaturdayForArrayConstraintsFromSetIsSaturday(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsSaturdayItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsSaturdayItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsSaturdayItem) ? get_class($locationSearchRowBasicIsSaturdayItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsSaturdayItem), var_export($locationSearchRowBasicIsSaturdayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isSaturday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isSaturday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isSaturday
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsSaturday(array $isSaturday = array())
    {
        // validation for constraint: array
        if ('' !== ($isSaturdayArrayErrorMessage = self::validateIsSaturdayForArrayConstraintsFromSetIsSaturday($isSaturday))) {
            throw new \InvalidArgumentException($isSaturdayArrayErrorMessage, __LINE__);
        }
        $this->isSaturday = $isSaturday;
        return $this;
    }
    /**
     * Add item to isSaturday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsSaturday(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isSaturday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isSaturday[] = $item;
        return $this;
    }
    /**
     * Get isSunday value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsSunday()
    {
        return $this->isSunday;
    }
    /**
     * This method is responsible for validating the values passed to the setIsSunday method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsSunday method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsSundayForArrayConstraintsFromSetIsSunday(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsSundayItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsSundayItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsSundayItem) ? get_class($locationSearchRowBasicIsSundayItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsSundayItem), var_export($locationSearchRowBasicIsSundayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isSunday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isSunday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isSunday
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsSunday(array $isSunday = array())
    {
        // validation for constraint: array
        if ('' !== ($isSundayArrayErrorMessage = self::validateIsSundayForArrayConstraintsFromSetIsSunday($isSunday))) {
            throw new \InvalidArgumentException($isSundayArrayErrorMessage, __LINE__);
        }
        $this->isSunday = $isSunday;
        return $this;
    }
    /**
     * Add item to isSunday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsSunday(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isSunday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isSunday[] = $item;
        return $this;
    }
    /**
     * Get isThursday value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsThursday()
    {
        return $this->isThursday;
    }
    /**
     * This method is responsible for validating the values passed to the setIsThursday method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsThursday method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsThursdayForArrayConstraintsFromSetIsThursday(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsThursdayItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsThursdayItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsThursdayItem) ? get_class($locationSearchRowBasicIsThursdayItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsThursdayItem), var_export($locationSearchRowBasicIsThursdayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isThursday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isThursday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isThursday
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsThursday(array $isThursday = array())
    {
        // validation for constraint: array
        if ('' !== ($isThursdayArrayErrorMessage = self::validateIsThursdayForArrayConstraintsFromSetIsThursday($isThursday))) {
            throw new \InvalidArgumentException($isThursdayArrayErrorMessage, __LINE__);
        }
        $this->isThursday = $isThursday;
        return $this;
    }
    /**
     * Add item to isThursday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsThursday(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isThursday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isThursday[] = $item;
        return $this;
    }
    /**
     * Get isTuesday value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsTuesday()
    {
        return $this->isTuesday;
    }
    /**
     * This method is responsible for validating the values passed to the setIsTuesday method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsTuesday method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsTuesdayForArrayConstraintsFromSetIsTuesday(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsTuesdayItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsTuesdayItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsTuesdayItem) ? get_class($locationSearchRowBasicIsTuesdayItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsTuesdayItem), var_export($locationSearchRowBasicIsTuesdayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isTuesday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isTuesday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isTuesday
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsTuesday(array $isTuesday = array())
    {
        // validation for constraint: array
        if ('' !== ($isTuesdayArrayErrorMessage = self::validateIsTuesdayForArrayConstraintsFromSetIsTuesday($isTuesday))) {
            throw new \InvalidArgumentException($isTuesdayArrayErrorMessage, __LINE__);
        }
        $this->isTuesday = $isTuesday;
        return $this;
    }
    /**
     * Add item to isTuesday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsTuesday(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isTuesday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isTuesday[] = $item;
        return $this;
    }
    /**
     * Get isWednesday value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsWednesday()
    {
        return $this->isWednesday;
    }
    /**
     * This method is responsible for validating the values passed to the setIsWednesday method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsWednesday method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsWednesdayForArrayConstraintsFromSetIsWednesday(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicIsWednesdayItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicIsWednesdayItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicIsWednesdayItem) ? get_class($locationSearchRowBasicIsWednesdayItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicIsWednesdayItem), var_export($locationSearchRowBasicIsWednesdayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isWednesday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isWednesday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isWednesday
     * @return \StructType\LocationSearchRowBasic
     */
    public function setIsWednesday(array $isWednesday = array())
    {
        // validation for constraint: array
        if ('' !== ($isWednesdayArrayErrorMessage = self::validateIsWednesdayForArrayConstraintsFromSetIsWednesday($isWednesday))) {
            throw new \InvalidArgumentException($isWednesdayArrayErrorMessage, __LINE__);
        }
        $this->isWednesday = $isWednesday;
        return $this;
    }
    /**
     * Add item to isWednesday value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToIsWednesday(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isWednesday property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isWednesday[] = $item;
        return $this;
    }
    /**
     * Get latitude value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * This method is responsible for validating the values passed to the setLatitude method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLatitude method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLatitudeForArrayConstraintsFromSetLatitude(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicLatitudeItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicLatitudeItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($locationSearchRowBasicLatitudeItem) ? get_class($locationSearchRowBasicLatitudeItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicLatitudeItem), var_export($locationSearchRowBasicLatitudeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The latitude property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set latitude value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $latitude
     * @return \StructType\LocationSearchRowBasic
     */
    public function setLatitude(array $latitude = array())
    {
        // validation for constraint: array
        if ('' !== ($latitudeArrayErrorMessage = self::validateLatitudeForArrayConstraintsFromSetLatitude($latitude))) {
            throw new \InvalidArgumentException($latitudeArrayErrorMessage, __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Add item to latitude value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToLatitude(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The latitude property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->latitude[] = $item;
        return $this;
    }
    /**
     * Get locationType value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getLocationType()
    {
        return $this->locationType;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationTypeForArrayConstraintsFromSetLocationType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicLocationTypeItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicLocationTypeItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($locationSearchRowBasicLocationTypeItem) ? get_class($locationSearchRowBasicLocationTypeItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicLocationTypeItem), var_export($locationSearchRowBasicLocationTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The locationType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set locationType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $locationType
     * @return \StructType\LocationSearchRowBasic
     */
    public function setLocationType(array $locationType = array())
    {
        // validation for constraint: array
        if ('' !== ($locationTypeArrayErrorMessage = self::validateLocationTypeForArrayConstraintsFromSetLocationType($locationType))) {
            throw new \InvalidArgumentException($locationTypeArrayErrorMessage, __LINE__);
        }
        $this->locationType = $locationType;
        return $this;
    }
    /**
     * Add item to locationType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToLocationType(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The locationType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->locationType[] = $item;
        return $this;
    }
    /**
     * Get longitude value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * This method is responsible for validating the values passed to the setLongitude method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLongitude method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLongitudeForArrayConstraintsFromSetLongitude(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicLongitudeItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicLongitudeItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($locationSearchRowBasicLongitudeItem) ? get_class($locationSearchRowBasicLongitudeItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicLongitudeItem), var_export($locationSearchRowBasicLongitudeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The longitude property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set longitude value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $longitude
     * @return \StructType\LocationSearchRowBasic
     */
    public function setLongitude(array $longitude = array())
    {
        // validation for constraint: array
        if ('' !== ($longitudeArrayErrorMessage = self::validateLongitudeForArrayConstraintsFromSetLongitude($longitude))) {
            throw new \InvalidArgumentException($longitudeArrayErrorMessage, __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Add item to longitude value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToLongitude(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The longitude property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->longitude[] = $item;
        return $this;
    }
    /**
     * Get makeInventoryAvailable value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getMakeInventoryAvailable()
    {
        return $this->makeInventoryAvailable;
    }
    /**
     * This method is responsible for validating the values passed to the setMakeInventoryAvailable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMakeInventoryAvailable method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMakeInventoryAvailableForArrayConstraintsFromSetMakeInventoryAvailable(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicMakeInventoryAvailableItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicMakeInventoryAvailableItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicMakeInventoryAvailableItem) ? get_class($locationSearchRowBasicMakeInventoryAvailableItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicMakeInventoryAvailableItem), var_export($locationSearchRowBasicMakeInventoryAvailableItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The makeInventoryAvailable property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set makeInventoryAvailable value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $makeInventoryAvailable
     * @return \StructType\LocationSearchRowBasic
     */
    public function setMakeInventoryAvailable(array $makeInventoryAvailable = array())
    {
        // validation for constraint: array
        if ('' !== ($makeInventoryAvailableArrayErrorMessage = self::validateMakeInventoryAvailableForArrayConstraintsFromSetMakeInventoryAvailable($makeInventoryAvailable))) {
            throw new \InvalidArgumentException($makeInventoryAvailableArrayErrorMessage, __LINE__);
        }
        $this->makeInventoryAvailable = $makeInventoryAvailable;
        return $this;
    }
    /**
     * Add item to makeInventoryAvailable value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToMakeInventoryAvailable(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The makeInventoryAvailable property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->makeInventoryAvailable[] = $item;
        return $this;
    }
    /**
     * Get makeInventoryAvailableStore value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getMakeInventoryAvailableStore()
    {
        return $this->makeInventoryAvailableStore;
    }
    /**
     * This method is responsible for validating the values passed to the setMakeInventoryAvailableStore method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMakeInventoryAvailableStore method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMakeInventoryAvailableStoreForArrayConstraintsFromSetMakeInventoryAvailableStore(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicMakeInventoryAvailableStoreItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicMakeInventoryAvailableStoreItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicMakeInventoryAvailableStoreItem) ? get_class($locationSearchRowBasicMakeInventoryAvailableStoreItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicMakeInventoryAvailableStoreItem), var_export($locationSearchRowBasicMakeInventoryAvailableStoreItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The makeInventoryAvailableStore property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set makeInventoryAvailableStore value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $makeInventoryAvailableStore
     * @return \StructType\LocationSearchRowBasic
     */
    public function setMakeInventoryAvailableStore(array $makeInventoryAvailableStore = array())
    {
        // validation for constraint: array
        if ('' !== ($makeInventoryAvailableStoreArrayErrorMessage = self::validateMakeInventoryAvailableStoreForArrayConstraintsFromSetMakeInventoryAvailableStore($makeInventoryAvailableStore))) {
            throw new \InvalidArgumentException($makeInventoryAvailableStoreArrayErrorMessage, __LINE__);
        }
        $this->makeInventoryAvailableStore = $makeInventoryAvailableStore;
        return $this;
    }
    /**
     * Add item to makeInventoryAvailableStore value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToMakeInventoryAvailableStore(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The makeInventoryAvailableStore property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->makeInventoryAvailableStore[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicNameItem) ? get_class($locationSearchRowBasicNameItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicNameItem), var_export($locationSearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\LocationSearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get nameNoHierarchy value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getNameNoHierarchy()
    {
        return $this->nameNoHierarchy;
    }
    /**
     * This method is responsible for validating the values passed to the setNameNoHierarchy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameNoHierarchy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameNoHierarchyForArrayConstraintsFromSetNameNoHierarchy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicNameNoHierarchyItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicNameNoHierarchyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicNameNoHierarchyItem) ? get_class($locationSearchRowBasicNameNoHierarchyItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicNameNoHierarchyItem), var_export($locationSearchRowBasicNameNoHierarchyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nameNoHierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nameNoHierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $nameNoHierarchy
     * @return \StructType\LocationSearchRowBasic
     */
    public function setNameNoHierarchy(array $nameNoHierarchy = array())
    {
        // validation for constraint: array
        if ('' !== ($nameNoHierarchyArrayErrorMessage = self::validateNameNoHierarchyForArrayConstraintsFromSetNameNoHierarchy($nameNoHierarchy))) {
            throw new \InvalidArgumentException($nameNoHierarchyArrayErrorMessage, __LINE__);
        }
        $this->nameNoHierarchy = $nameNoHierarchy;
        return $this;
    }
    /**
     * Add item to nameNoHierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToNameNoHierarchy(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The nameNoHierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nameNoHierarchy[] = $item;
        return $this;
    }
    /**
     * Get nextPickupCutOffTime value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getNextPickupCutOffTime()
    {
        return $this->nextPickupCutOffTime;
    }
    /**
     * This method is responsible for validating the values passed to the setNextPickupCutOffTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNextPickupCutOffTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNextPickupCutOffTimeForArrayConstraintsFromSetNextPickupCutOffTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicNextPickupCutOffTimeItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicNextPickupCutOffTimeItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($locationSearchRowBasicNextPickupCutOffTimeItem) ? get_class($locationSearchRowBasicNextPickupCutOffTimeItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicNextPickupCutOffTimeItem), var_export($locationSearchRowBasicNextPickupCutOffTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nextPickupCutOffTime property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nextPickupCutOffTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $nextPickupCutOffTime
     * @return \StructType\LocationSearchRowBasic
     */
    public function setNextPickupCutOffTime(array $nextPickupCutOffTime = array())
    {
        // validation for constraint: array
        if ('' !== ($nextPickupCutOffTimeArrayErrorMessage = self::validateNextPickupCutOffTimeForArrayConstraintsFromSetNextPickupCutOffTime($nextPickupCutOffTime))) {
            throw new \InvalidArgumentException($nextPickupCutOffTimeArrayErrorMessage, __LINE__);
        }
        $this->nextPickupCutOffTime = $nextPickupCutOffTime;
        return $this;
    }
    /**
     * Add item to nextPickupCutOffTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToNextPickupCutOffTime(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The nextPickupCutOffTime property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nextPickupCutOffTime[] = $item;
        return $this;
    }
    /**
     * Get phone value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * This method is responsible for validating the values passed to the setPhone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoneForArrayConstraintsFromSetPhone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicPhoneItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicPhoneItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicPhoneItem) ? get_class($locationSearchRowBasicPhoneItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicPhoneItem), var_export($locationSearchRowBasicPhoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The phone property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set phone value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $phone
     * @return \StructType\LocationSearchRowBasic
     */
    public function setPhone(array $phone = array())
    {
        // validation for constraint: array
        if ('' !== ($phoneArrayErrorMessage = self::validatePhoneForArrayConstraintsFromSetPhone($phone))) {
            throw new \InvalidArgumentException($phoneArrayErrorMessage, __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Add item to phone value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToPhone(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The phone property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->phone[] = $item;
        return $this;
    }
    /**
     * Get sameDayPickupCutOffTime value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getSameDayPickupCutOffTime()
    {
        return $this->sameDayPickupCutOffTime;
    }
    /**
     * This method is responsible for validating the values passed to the setSameDayPickupCutOffTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSameDayPickupCutOffTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSameDayPickupCutOffTimeForArrayConstraintsFromSetSameDayPickupCutOffTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicSameDayPickupCutOffTimeItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicSameDayPickupCutOffTimeItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($locationSearchRowBasicSameDayPickupCutOffTimeItem) ? get_class($locationSearchRowBasicSameDayPickupCutOffTimeItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicSameDayPickupCutOffTimeItem), var_export($locationSearchRowBasicSameDayPickupCutOffTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sameDayPickupCutOffTime property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sameDayPickupCutOffTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $sameDayPickupCutOffTime
     * @return \StructType\LocationSearchRowBasic
     */
    public function setSameDayPickupCutOffTime(array $sameDayPickupCutOffTime = array())
    {
        // validation for constraint: array
        if ('' !== ($sameDayPickupCutOffTimeArrayErrorMessage = self::validateSameDayPickupCutOffTimeForArrayConstraintsFromSetSameDayPickupCutOffTime($sameDayPickupCutOffTime))) {
            throw new \InvalidArgumentException($sameDayPickupCutOffTimeArrayErrorMessage, __LINE__);
        }
        $this->sameDayPickupCutOffTime = $sameDayPickupCutOffTime;
        return $this;
    }
    /**
     * Add item to sameDayPickupCutOffTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToSameDayPickupCutOffTime(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The sameDayPickupCutOffTime property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sameDayPickupCutOffTime[] = $item;
        return $this;
    }
    /**
     * Get startTime value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * This method is responsible for validating the values passed to the setStartTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartTimeForArrayConstraintsFromSetStartTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicStartTimeItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicStartTimeItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($locationSearchRowBasicStartTimeItem) ? get_class($locationSearchRowBasicStartTimeItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicStartTimeItem), var_export($locationSearchRowBasicStartTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The startTime property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set startTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $startTime
     * @return \StructType\LocationSearchRowBasic
     */
    public function setStartTime(array $startTime = array())
    {
        // validation for constraint: array
        if ('' !== ($startTimeArrayErrorMessage = self::validateStartTimeForArrayConstraintsFromSetStartTime($startTime))) {
            throw new \InvalidArgumentException($startTimeArrayErrorMessage, __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Add item to startTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToStartTime(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The startTime property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->startTime[] = $item;
        return $this;
    }
    /**
     * Get state value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * This method is responsible for validating the values passed to the setState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStateForArrayConstraintsFromSetState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicStateItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicStateItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicStateItem) ? get_class($locationSearchRowBasicStateItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicStateItem), var_export($locationSearchRowBasicStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The state property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set state value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $state
     * @return \StructType\LocationSearchRowBasic
     */
    public function setState(array $state = array())
    {
        // validation for constraint: array
        if ('' !== ($stateArrayErrorMessage = self::validateStateForArrayConstraintsFromSetState($state))) {
            throw new \InvalidArgumentException($stateArrayErrorMessage, __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Add item to state value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToState(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The state property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->state[] = $item;
        return $this;
    }
    /**
     * Get storePickupBufferStock value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getStorePickupBufferStock()
    {
        return $this->storePickupBufferStock;
    }
    /**
     * This method is responsible for validating the values passed to the setStorePickupBufferStock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStorePickupBufferStock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStorePickupBufferStockForArrayConstraintsFromSetStorePickupBufferStock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicStorePickupBufferStockItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicStorePickupBufferStockItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($locationSearchRowBasicStorePickupBufferStockItem) ? get_class($locationSearchRowBasicStorePickupBufferStockItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicStorePickupBufferStockItem), var_export($locationSearchRowBasicStorePickupBufferStockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The storePickupBufferStock property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set storePickupBufferStock value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $storePickupBufferStock
     * @return \StructType\LocationSearchRowBasic
     */
    public function setStorePickupBufferStock(array $storePickupBufferStock = array())
    {
        // validation for constraint: array
        if ('' !== ($storePickupBufferStockArrayErrorMessage = self::validateStorePickupBufferStockForArrayConstraintsFromSetStorePickupBufferStock($storePickupBufferStock))) {
            throw new \InvalidArgumentException($storePickupBufferStockArrayErrorMessage, __LINE__);
        }
        $this->storePickupBufferStock = $storePickupBufferStock;
        return $this;
    }
    /**
     * Add item to storePickupBufferStock value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToStorePickupBufferStock(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The storePickupBufferStock property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->storePickupBufferStock[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($locationSearchRowBasicSubsidiaryItem) ? get_class($locationSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicSubsidiaryItem), var_export($locationSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @return \StructType\LocationSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get timeZone value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * This method is responsible for validating the values passed to the setTimeZone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTimeZone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimeZoneForArrayConstraintsFromSetTimeZone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicTimeZoneItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicTimeZoneItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($locationSearchRowBasicTimeZoneItem) ? get_class($locationSearchRowBasicTimeZoneItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicTimeZoneItem), var_export($locationSearchRowBasicTimeZoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The timeZone property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set timeZone value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $timeZone
     * @return \StructType\LocationSearchRowBasic
     */
    public function setTimeZone(array $timeZone = array())
    {
        // validation for constraint: array
        if ('' !== ($timeZoneArrayErrorMessage = self::validateTimeZoneForArrayConstraintsFromSetTimeZone($timeZone))) {
            throw new \InvalidArgumentException($timeZoneArrayErrorMessage, __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Add item to timeZone value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToTimeZone(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The timeZone property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->timeZone[] = $item;
        return $this;
    }
    /**
     * Get totalShippingCapacity value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getTotalShippingCapacity()
    {
        return $this->totalShippingCapacity;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalShippingCapacity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalShippingCapacity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalShippingCapacityForArrayConstraintsFromSetTotalShippingCapacity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicTotalShippingCapacityItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicTotalShippingCapacityItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($locationSearchRowBasicTotalShippingCapacityItem) ? get_class($locationSearchRowBasicTotalShippingCapacityItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicTotalShippingCapacityItem), var_export($locationSearchRowBasicTotalShippingCapacityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The totalShippingCapacity property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set totalShippingCapacity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $totalShippingCapacity
     * @return \StructType\LocationSearchRowBasic
     */
    public function setTotalShippingCapacity(array $totalShippingCapacity = array())
    {
        // validation for constraint: array
        if ('' !== ($totalShippingCapacityArrayErrorMessage = self::validateTotalShippingCapacityForArrayConstraintsFromSetTotalShippingCapacity($totalShippingCapacity))) {
            throw new \InvalidArgumentException($totalShippingCapacityArrayErrorMessage, __LINE__);
        }
        $this->totalShippingCapacity = $totalShippingCapacity;
        return $this;
    }
    /**
     * Add item to totalShippingCapacity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToTotalShippingCapacity(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The totalShippingCapacity property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->totalShippingCapacity[] = $item;
        return $this;
    }
    /**
     * Get tranPrefix value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getTranPrefix()
    {
        return $this->tranPrefix;
    }
    /**
     * This method is responsible for validating the values passed to the setTranPrefix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTranPrefix method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTranPrefixForArrayConstraintsFromSetTranPrefix(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicTranPrefixItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicTranPrefixItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicTranPrefixItem) ? get_class($locationSearchRowBasicTranPrefixItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicTranPrefixItem), var_export($locationSearchRowBasicTranPrefixItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tranPrefix property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tranPrefix value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $tranPrefix
     * @return \StructType\LocationSearchRowBasic
     */
    public function setTranPrefix(array $tranPrefix = array())
    {
        // validation for constraint: array
        if ('' !== ($tranPrefixArrayErrorMessage = self::validateTranPrefixForArrayConstraintsFromSetTranPrefix($tranPrefix))) {
            throw new \InvalidArgumentException($tranPrefixArrayErrorMessage, __LINE__);
        }
        $this->tranPrefix = $tranPrefix;
        return $this;
    }
    /**
     * Add item to tranPrefix value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToTranPrefix(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The tranPrefix property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tranPrefix[] = $item;
        return $this;
    }
    /**
     * Get usesBins value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getUsesBins()
    {
        return $this->usesBins;
    }
    /**
     * This method is responsible for validating the values passed to the setUsesBins method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsesBins method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsesBinsForArrayConstraintsFromSetUsesBins(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicUsesBinsItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicUsesBinsItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($locationSearchRowBasicUsesBinsItem) ? get_class($locationSearchRowBasicUsesBinsItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicUsesBinsItem), var_export($locationSearchRowBasicUsesBinsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The usesBins property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set usesBins value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $usesBins
     * @return \StructType\LocationSearchRowBasic
     */
    public function setUsesBins(array $usesBins = array())
    {
        // validation for constraint: array
        if ('' !== ($usesBinsArrayErrorMessage = self::validateUsesBinsForArrayConstraintsFromSetUsesBins($usesBins))) {
            throw new \InvalidArgumentException($usesBinsArrayErrorMessage, __LINE__);
        }
        $this->usesBins = $usesBins;
        return $this;
    }
    /**
     * Add item to usesBins value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToUsesBins(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The usesBins property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->usesBins[] = $item;
        return $this;
    }
    /**
     * Get zip value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * This method is responsible for validating the values passed to the setZip method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZip method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZipForArrayConstraintsFromSetZip(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchRowBasicZipItem) {
            // validation for constraint: itemType
            if (!$locationSearchRowBasicZipItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($locationSearchRowBasicZipItem) ? get_class($locationSearchRowBasicZipItem) : sprintf('%s(%s)', gettype($locationSearchRowBasicZipItem), var_export($locationSearchRowBasicZipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zip property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zip value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $zip
     * @return \StructType\LocationSearchRowBasic
     */
    public function setZip(array $zip = array())
    {
        // validation for constraint: array
        if ('' !== ($zipArrayErrorMessage = self::validateZipForArrayConstraintsFromSetZip($zip))) {
            throw new \InvalidArgumentException($zipArrayErrorMessage, __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Add item to zip value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\LocationSearchRowBasic
     */
    public function addToZip(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The zip property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zip[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\LocationSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
