<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationRegionsList StructType
 * @subpackage Structs
 */
class LocationRegionsList extends AbstractStructBase
{
    /**
     * The locationRegions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationRegions[]
     */
    public $locationRegions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for LocationRegionsList
     * @uses LocationRegionsList::setLocationRegions()
     * @uses LocationRegionsList::setReplaceAll()
     * @param \StructType\LocationRegions[] $locationRegions
     * @param bool $replaceAll
     */
    public function __construct(array $locationRegions = array(), $replaceAll = true)
    {
        $this
            ->setLocationRegions($locationRegions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get locationRegions value
     * @return \StructType\LocationRegions[]|null
     */
    public function getLocationRegions()
    {
        return $this->locationRegions;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationRegions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationRegions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationRegionsForArrayConstraintsFromSetLocationRegions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationRegionsListLocationRegionsItem) {
            // validation for constraint: itemType
            if (!$locationRegionsListLocationRegionsItem instanceof \StructType\LocationRegions) {
                $invalidValues[] = is_object($locationRegionsListLocationRegionsItem) ? get_class($locationRegionsListLocationRegionsItem) : sprintf('%s(%s)', gettype($locationRegionsListLocationRegionsItem), var_export($locationRegionsListLocationRegionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The locationRegions property can only contain items of type \StructType\LocationRegions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set locationRegions value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationRegions[] $locationRegions
     * @return \StructType\LocationRegionsList
     */
    public function setLocationRegions(array $locationRegions = array())
    {
        // validation for constraint: array
        if ('' !== ($locationRegionsArrayErrorMessage = self::validateLocationRegionsForArrayConstraintsFromSetLocationRegions($locationRegions))) {
            throw new \InvalidArgumentException($locationRegionsArrayErrorMessage, __LINE__);
        }
        $this->locationRegions = $locationRegions;
        return $this;
    }
    /**
     * Add item to locationRegions value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationRegions $item
     * @return \StructType\LocationRegionsList
     */
    public function addToLocationRegions(\StructType\LocationRegions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationRegions) {
            throw new \InvalidArgumentException(sprintf('The locationRegions property can only contain items of type \StructType\LocationRegions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->locationRegions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\LocationRegionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
