<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitItemHierarchyVersionsList StructType
 * @subpackage Structs
 */
class KitItemHierarchyVersionsList extends AbstractStructBase
{
    /**
     * The kitItemHierarchyVersions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KitItemHierarchyVersions[]
     */
    public $kitItemHierarchyVersions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for KitItemHierarchyVersionsList
     * @uses KitItemHierarchyVersionsList::setKitItemHierarchyVersions()
     * @uses KitItemHierarchyVersionsList::setReplaceAll()
     * @param \StructType\KitItemHierarchyVersions[] $kitItemHierarchyVersions
     * @param bool $replaceAll
     */
    public function __construct(array $kitItemHierarchyVersions = array(), $replaceAll = true)
    {
        $this
            ->setKitItemHierarchyVersions($kitItemHierarchyVersions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get kitItemHierarchyVersions value
     * @return \StructType\KitItemHierarchyVersions[]|null
     */
    public function getKitItemHierarchyVersions()
    {
        return $this->kitItemHierarchyVersions;
    }
    /**
     * This method is responsible for validating the values passed to the setKitItemHierarchyVersions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKitItemHierarchyVersions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKitItemHierarchyVersionsForArrayConstraintsFromSetKitItemHierarchyVersions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kitItemHierarchyVersionsListKitItemHierarchyVersionsItem) {
            // validation for constraint: itemType
            if (!$kitItemHierarchyVersionsListKitItemHierarchyVersionsItem instanceof \StructType\KitItemHierarchyVersions) {
                $invalidValues[] = is_object($kitItemHierarchyVersionsListKitItemHierarchyVersionsItem) ? get_class($kitItemHierarchyVersionsListKitItemHierarchyVersionsItem) : sprintf('%s(%s)', gettype($kitItemHierarchyVersionsListKitItemHierarchyVersionsItem), var_export($kitItemHierarchyVersionsListKitItemHierarchyVersionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kitItemHierarchyVersions property can only contain items of type \StructType\KitItemHierarchyVersions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kitItemHierarchyVersions value
     * @throws \InvalidArgumentException
     * @param \StructType\KitItemHierarchyVersions[] $kitItemHierarchyVersions
     * @return \StructType\KitItemHierarchyVersionsList
     */
    public function setKitItemHierarchyVersions(array $kitItemHierarchyVersions = array())
    {
        // validation for constraint: array
        if ('' !== ($kitItemHierarchyVersionsArrayErrorMessage = self::validateKitItemHierarchyVersionsForArrayConstraintsFromSetKitItemHierarchyVersions($kitItemHierarchyVersions))) {
            throw new \InvalidArgumentException($kitItemHierarchyVersionsArrayErrorMessage, __LINE__);
        }
        $this->kitItemHierarchyVersions = $kitItemHierarchyVersions;
        return $this;
    }
    /**
     * Add item to kitItemHierarchyVersions value
     * @throws \InvalidArgumentException
     * @param \StructType\KitItemHierarchyVersions $item
     * @return \StructType\KitItemHierarchyVersionsList
     */
    public function addToKitItemHierarchyVersions(\StructType\KitItemHierarchyVersions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KitItemHierarchyVersions) {
            throw new \InvalidArgumentException(sprintf('The kitItemHierarchyVersions property can only contain items of type \StructType\KitItemHierarchyVersions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kitItemHierarchyVersions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\KitItemHierarchyVersionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
