<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemVendor StructType
 * @subpackage Structs
 */
class ItemVendor extends AbstractStructBase
{
    /**
     * The vendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $vendor;
    /**
     * The vendorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorCode;
    /**
     * The vendorCurrencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorCurrencyName;
    /**
     * The vendorCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $vendorCurrency;
    /**
     * The purchasePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchasePrice;
    /**
     * The preferredVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $preferredVendor;
    /**
     * The schedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $schedule;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * Constructor method for ItemVendor
     * @uses ItemVendor::setVendor()
     * @uses ItemVendor::setVendorCode()
     * @uses ItemVendor::setVendorCurrencyName()
     * @uses ItemVendor::setVendorCurrency()
     * @uses ItemVendor::setPurchasePrice()
     * @uses ItemVendor::setPreferredVendor()
     * @uses ItemVendor::setSchedule()
     * @uses ItemVendor::setSubsidiary()
     * @param \StructType\RecordRef $vendor
     * @param string $vendorCode
     * @param string $vendorCurrencyName
     * @param \StructType\RecordRef $vendorCurrency
     * @param float $purchasePrice
     * @param bool $preferredVendor
     * @param \StructType\RecordRef $schedule
     * @param \StructType\RecordRef $subsidiary
     */
    public function __construct(\StructType\RecordRef $vendor = null, $vendorCode = null, $vendorCurrencyName = null, \StructType\RecordRef $vendorCurrency = null, $purchasePrice = null, $preferredVendor = null, \StructType\RecordRef $schedule = null, \StructType\RecordRef $subsidiary = null)
    {
        $this
            ->setVendor($vendor)
            ->setVendorCode($vendorCode)
            ->setVendorCurrencyName($vendorCurrencyName)
            ->setVendorCurrency($vendorCurrency)
            ->setPurchasePrice($purchasePrice)
            ->setPreferredVendor($preferredVendor)
            ->setSchedule($schedule)
            ->setSubsidiary($subsidiary);
    }
    /**
     * Get vendor value
     * @return \StructType\RecordRef|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * Set vendor value
     * @param \StructType\RecordRef $vendor
     * @return \StructType\ItemVendor
     */
    public function setVendor(\StructType\RecordRef $vendor = null)
    {
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Get vendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->vendorCode;
    }
    /**
     * Set vendorCode value
     * @param string $vendorCode
     * @return \StructType\ItemVendor
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->vendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get vendorCurrencyName value
     * @return string|null
     */
    public function getVendorCurrencyName()
    {
        return $this->vendorCurrencyName;
    }
    /**
     * Set vendorCurrencyName value
     * @param string $vendorCurrencyName
     * @return \StructType\ItemVendor
     */
    public function setVendorCurrencyName($vendorCurrencyName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCurrencyName) && !is_string($vendorCurrencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCurrencyName, true), gettype($vendorCurrencyName)), __LINE__);
        }
        $this->vendorCurrencyName = $vendorCurrencyName;
        return $this;
    }
    /**
     * Get vendorCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getVendorCurrency()
    {
        return $this->vendorCurrency;
    }
    /**
     * Set vendorCurrency value
     * @param \StructType\RecordRef $vendorCurrency
     * @return \StructType\ItemVendor
     */
    public function setVendorCurrency(\StructType\RecordRef $vendorCurrency = null)
    {
        $this->vendorCurrency = $vendorCurrency;
        return $this;
    }
    /**
     * Get purchasePrice value
     * @return float|null
     */
    public function getPurchasePrice()
    {
        return $this->purchasePrice;
    }
    /**
     * Set purchasePrice value
     * @param float $purchasePrice
     * @return \StructType\ItemVendor
     */
    public function setPurchasePrice($purchasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($purchasePrice) && !(is_float($purchasePrice) || is_numeric($purchasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchasePrice, true), gettype($purchasePrice)), __LINE__);
        }
        $this->purchasePrice = $purchasePrice;
        return $this;
    }
    /**
     * Get preferredVendor value
     * @return bool|null
     */
    public function getPreferredVendor()
    {
        return $this->preferredVendor;
    }
    /**
     * Set preferredVendor value
     * @param bool $preferredVendor
     * @return \StructType\ItemVendor
     */
    public function setPreferredVendor($preferredVendor = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferredVendor) && !is_bool($preferredVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferredVendor, true), gettype($preferredVendor)), __LINE__);
        }
        $this->preferredVendor = $preferredVendor;
        return $this;
    }
    /**
     * Get schedule value
     * @return \StructType\RecordRef|null
     */
    public function getSchedule()
    {
        return $this->schedule;
    }
    /**
     * Set schedule value
     * @param \StructType\RecordRef $schedule
     * @return \StructType\ItemVendor
     */
    public function setSchedule(\StructType\RecordRef $schedule = null)
    {
        $this->schedule = $schedule;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\ItemVendor
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
}
