<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSupplyPlanOrder StructType
 * @subpackage Structs
 */
class ItemSupplyPlanOrder extends AbstractStructBase
{
    /**
     * The orderLineId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderLineId;
    /**
     * The orderDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderDate;
    /**
     * The receiptDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $receiptDate;
    /**
     * The sourceLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $sourceLocation;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The orderCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $orderCreated;
    /**
     * The orderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderType;
    /**
     * Constructor method for ItemSupplyPlanOrder
     * @uses ItemSupplyPlanOrder::setOrderLineId()
     * @uses ItemSupplyPlanOrder::setOrderDate()
     * @uses ItemSupplyPlanOrder::setReceiptDate()
     * @uses ItemSupplyPlanOrder::setSourceLocation()
     * @uses ItemSupplyPlanOrder::setQuantity()
     * @uses ItemSupplyPlanOrder::setOrderCreated()
     * @uses ItemSupplyPlanOrder::setOrderType()
     * @param int $orderLineId
     * @param string $orderDate
     * @param string $receiptDate
     * @param \StructType\RecordRef $sourceLocation
     * @param float $quantity
     * @param bool $orderCreated
     * @param string $orderType
     */
    public function __construct($orderLineId = null, $orderDate = null, $receiptDate = null, \StructType\RecordRef $sourceLocation = null, $quantity = null, $orderCreated = null, $orderType = null)
    {
        $this
            ->setOrderLineId($orderLineId)
            ->setOrderDate($orderDate)
            ->setReceiptDate($receiptDate)
            ->setSourceLocation($sourceLocation)
            ->setQuantity($quantity)
            ->setOrderCreated($orderCreated)
            ->setOrderType($orderType);
    }
    /**
     * Get orderLineId value
     * @return int|null
     */
    public function getOrderLineId()
    {
        return $this->orderLineId;
    }
    /**
     * Set orderLineId value
     * @param int $orderLineId
     * @return \StructType\ItemSupplyPlanOrder
     */
    public function setOrderLineId($orderLineId = null)
    {
        // validation for constraint: int
        if (!is_null($orderLineId) && !(is_int($orderLineId) || ctype_digit($orderLineId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLineId, true), gettype($orderLineId)), __LINE__);
        }
        $this->orderLineId = $orderLineId;
        return $this;
    }
    /**
     * Get orderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }
    /**
     * Set orderDate value
     * @param string $orderDate
     * @return \StructType\ItemSupplyPlanOrder
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->orderDate = $orderDate;
        return $this;
    }
    /**
     * Get receiptDate value
     * @return string|null
     */
    public function getReceiptDate()
    {
        return $this->receiptDate;
    }
    /**
     * Set receiptDate value
     * @param string $receiptDate
     * @return \StructType\ItemSupplyPlanOrder
     */
    public function setReceiptDate($receiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($receiptDate) && !is_string($receiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptDate, true), gettype($receiptDate)), __LINE__);
        }
        $this->receiptDate = $receiptDate;
        return $this;
    }
    /**
     * Get sourceLocation value
     * @return \StructType\RecordRef|null
     */
    public function getSourceLocation()
    {
        return $this->sourceLocation;
    }
    /**
     * Set sourceLocation value
     * @param \StructType\RecordRef $sourceLocation
     * @return \StructType\ItemSupplyPlanOrder
     */
    public function setSourceLocation(\StructType\RecordRef $sourceLocation = null)
    {
        $this->sourceLocation = $sourceLocation;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\ItemSupplyPlanOrder
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get orderCreated value
     * @return bool|null
     */
    public function getOrderCreated()
    {
        return $this->orderCreated;
    }
    /**
     * Set orderCreated value
     * @param bool $orderCreated
     * @return \StructType\ItemSupplyPlanOrder
     */
    public function setOrderCreated($orderCreated = null)
    {
        // validation for constraint: boolean
        if (!is_null($orderCreated) && !is_bool($orderCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($orderCreated, true), gettype($orderCreated)), __LINE__);
        }
        $this->orderCreated = $orderCreated;
        return $this;
    }
    /**
     * Get orderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @uses \EnumType\ItemSupplyPlanOrderType::valueIsValid()
     * @uses \EnumType\ItemSupplyPlanOrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \StructType\ItemSupplyPlanOrder
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemSupplyPlanOrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemSupplyPlanOrderType', is_array($orderType) ? implode(', ', $orderType) : var_export($orderType, true), implode(', ', \EnumType\ItemSupplyPlanOrderType::getValidValues())), __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
}
