<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemReceiptItem StructType
 * @subpackage Structs
 */
class ItemReceiptItem extends AbstractStructBase
{
    /**
     * The itemReceive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $itemReceive;
    /**
     * The jobName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $jobName;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The orderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderLine;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The itemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The onHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $onHand;
    /**
     * The quantityRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityRemaining;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The unitsDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitsDisplay;
    /**
     * The unitCostOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unitCostOverride;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The restock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $restock;
    /**
     * The billVarianceStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billVarianceStatus;
    /**
     * The isDropShipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDropShipment;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The landedCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LandedCost
     */
    public $landedCost;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ItemReceiptItem
     * @uses ItemReceiptItem::setItemReceive()
     * @uses ItemReceiptItem::setJobName()
     * @uses ItemReceiptItem::setItem()
     * @uses ItemReceiptItem::setOrderLine()
     * @uses ItemReceiptItem::setLine()
     * @uses ItemReceiptItem::setItemName()
     * @uses ItemReceiptItem::setDescription()
     * @uses ItemReceiptItem::setLocation()
     * @uses ItemReceiptItem::setOnHand()
     * @uses ItemReceiptItem::setQuantityRemaining()
     * @uses ItemReceiptItem::setQuantity()
     * @uses ItemReceiptItem::setUnitsDisplay()
     * @uses ItemReceiptItem::setUnitCostOverride()
     * @uses ItemReceiptItem::setInventoryDetail()
     * @uses ItemReceiptItem::setSerialNumbers()
     * @uses ItemReceiptItem::setBinNumbers()
     * @uses ItemReceiptItem::setExpirationDate()
     * @uses ItemReceiptItem::setRate()
     * @uses ItemReceiptItem::setCurrency()
     * @uses ItemReceiptItem::setRestock()
     * @uses ItemReceiptItem::setBillVarianceStatus()
     * @uses ItemReceiptItem::setIsDropShipment()
     * @uses ItemReceiptItem::setOptions()
     * @uses ItemReceiptItem::setLandedCost()
     * @uses ItemReceiptItem::setCustomFieldList()
     * @param bool $itemReceive
     * @param string $jobName
     * @param \StructType\RecordRef $item
     * @param int $orderLine
     * @param int $line
     * @param string $itemName
     * @param string $description
     * @param \StructType\RecordRef $location
     * @param float $onHand
     * @param float $quantityRemaining
     * @param float $quantity
     * @param string $unitsDisplay
     * @param float $unitCostOverride
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $serialNumbers
     * @param string $binNumbers
     * @param string $expirationDate
     * @param string $rate
     * @param string $currency
     * @param bool $restock
     * @param string $billVarianceStatus
     * @param bool $isDropShipment
     * @param \StructType\CustomFieldList $options
     * @param \StructType\LandedCost $landedCost
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($itemReceive = null, $jobName = null, \StructType\RecordRef $item = null, $orderLine = null, $line = null, $itemName = null, $description = null, \StructType\RecordRef $location = null, $onHand = null, $quantityRemaining = null, $quantity = null, $unitsDisplay = null, $unitCostOverride = null, \StructType\InventoryDetail $inventoryDetail = null, $serialNumbers = null, $binNumbers = null, $expirationDate = null, $rate = null, $currency = null, $restock = null, $billVarianceStatus = null, $isDropShipment = null, \StructType\CustomFieldList $options = null, \StructType\LandedCost $landedCost = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setItemReceive($itemReceive)
            ->setJobName($jobName)
            ->setItem($item)
            ->setOrderLine($orderLine)
            ->setLine($line)
            ->setItemName($itemName)
            ->setDescription($description)
            ->setLocation($location)
            ->setOnHand($onHand)
            ->setQuantityRemaining($quantityRemaining)
            ->setQuantity($quantity)
            ->setUnitsDisplay($unitsDisplay)
            ->setUnitCostOverride($unitCostOverride)
            ->setInventoryDetail($inventoryDetail)
            ->setSerialNumbers($serialNumbers)
            ->setBinNumbers($binNumbers)
            ->setExpirationDate($expirationDate)
            ->setRate($rate)
            ->setCurrency($currency)
            ->setRestock($restock)
            ->setBillVarianceStatus($billVarianceStatus)
            ->setIsDropShipment($isDropShipment)
            ->setOptions($options)
            ->setLandedCost($landedCost)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get itemReceive value
     * @return bool|null
     */
    public function getItemReceive()
    {
        return $this->itemReceive;
    }
    /**
     * Set itemReceive value
     * @param bool $itemReceive
     * @return \StructType\ItemReceiptItem
     */
    public function setItemReceive($itemReceive = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemReceive) && !is_bool($itemReceive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($itemReceive, true), gettype($itemReceive)), __LINE__);
        }
        $this->itemReceive = $itemReceive;
        return $this;
    }
    /**
     * Get jobName value
     * @return string|null
     */
    public function getJobName()
    {
        return $this->jobName;
    }
    /**
     * Set jobName value
     * @param string $jobName
     * @return \StructType\ItemReceiptItem
     */
    public function setJobName($jobName = null)
    {
        // validation for constraint: string
        if (!is_null($jobName) && !is_string($jobName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobName, true), gettype($jobName)), __LINE__);
        }
        $this->jobName = $jobName;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\ItemReceiptItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get orderLine value
     * @return int|null
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }
    /**
     * Set orderLine value
     * @param int $orderLine
     * @return \StructType\ItemReceiptItem
     */
    public function setOrderLine($orderLine = null)
    {
        // validation for constraint: int
        if (!is_null($orderLine) && !(is_int($orderLine) || ctype_digit($orderLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLine, true), gettype($orderLine)), __LINE__);
        }
        $this->orderLine = $orderLine;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\ItemReceiptItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \StructType\ItemReceiptItem
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ItemReceiptItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\ItemReceiptItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get onHand value
     * @return float|null
     */
    public function getOnHand()
    {
        return $this->onHand;
    }
    /**
     * Set onHand value
     * @param float $onHand
     * @return \StructType\ItemReceiptItem
     */
    public function setOnHand($onHand = null)
    {
        // validation for constraint: float
        if (!is_null($onHand) && !(is_float($onHand) || is_numeric($onHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onHand, true), gettype($onHand)), __LINE__);
        }
        $this->onHand = $onHand;
        return $this;
    }
    /**
     * Get quantityRemaining value
     * @return float|null
     */
    public function getQuantityRemaining()
    {
        return $this->quantityRemaining;
    }
    /**
     * Set quantityRemaining value
     * @param float $quantityRemaining
     * @return \StructType\ItemReceiptItem
     */
    public function setQuantityRemaining($quantityRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($quantityRemaining) && !(is_float($quantityRemaining) || is_numeric($quantityRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityRemaining, true), gettype($quantityRemaining)), __LINE__);
        }
        $this->quantityRemaining = $quantityRemaining;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\ItemReceiptItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get unitsDisplay value
     * @return string|null
     */
    public function getUnitsDisplay()
    {
        return $this->unitsDisplay;
    }
    /**
     * Set unitsDisplay value
     * @param string $unitsDisplay
     * @return \StructType\ItemReceiptItem
     */
    public function setUnitsDisplay($unitsDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($unitsDisplay) && !is_string($unitsDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitsDisplay, true), gettype($unitsDisplay)), __LINE__);
        }
        $this->unitsDisplay = $unitsDisplay;
        return $this;
    }
    /**
     * Get unitCostOverride value
     * @return float|null
     */
    public function getUnitCostOverride()
    {
        return $this->unitCostOverride;
    }
    /**
     * Set unitCostOverride value
     * @param float $unitCostOverride
     * @return \StructType\ItemReceiptItem
     */
    public function setUnitCostOverride($unitCostOverride = null)
    {
        // validation for constraint: float
        if (!is_null($unitCostOverride) && !(is_float($unitCostOverride) || is_numeric($unitCostOverride))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitCostOverride, true), gettype($unitCostOverride)), __LINE__);
        }
        $this->unitCostOverride = $unitCostOverride;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\ItemReceiptItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\ItemReceiptItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\ItemReceiptItem
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\ItemReceiptItem
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\ItemReceiptItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ItemReceiptItem
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get restock value
     * @return bool|null
     */
    public function getRestock()
    {
        return $this->restock;
    }
    /**
     * Set restock value
     * @param bool $restock
     * @return \StructType\ItemReceiptItem
     */
    public function setRestock($restock = null)
    {
        // validation for constraint: boolean
        if (!is_null($restock) && !is_bool($restock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restock, true), gettype($restock)), __LINE__);
        }
        $this->restock = $restock;
        return $this;
    }
    /**
     * Get billVarianceStatus value
     * @return string|null
     */
    public function getBillVarianceStatus()
    {
        return $this->billVarianceStatus;
    }
    /**
     * Set billVarianceStatus value
     * @uses \EnumType\TransactionBillVarianceStatus::valueIsValid()
     * @uses \EnumType\TransactionBillVarianceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billVarianceStatus
     * @return \StructType\ItemReceiptItem
     */
    public function setBillVarianceStatus($billVarianceStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionBillVarianceStatus::valueIsValid($billVarianceStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionBillVarianceStatus', is_array($billVarianceStatus) ? implode(', ', $billVarianceStatus) : var_export($billVarianceStatus, true), implode(', ', \EnumType\TransactionBillVarianceStatus::getValidValues())), __LINE__);
        }
        $this->billVarianceStatus = $billVarianceStatus;
        return $this;
    }
    /**
     * Get isDropShipment value
     * @return bool|null
     */
    public function getIsDropShipment()
    {
        return $this->isDropShipment;
    }
    /**
     * Set isDropShipment value
     * @param bool $isDropShipment
     * @return \StructType\ItemReceiptItem
     */
    public function setIsDropShipment($isDropShipment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDropShipment) && !is_bool($isDropShipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDropShipment, true), gettype($isDropShipment)), __LINE__);
        }
        $this->isDropShipment = $isDropShipment;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\ItemReceiptItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get landedCost value
     * @return \StructType\LandedCost|null
     */
    public function getLandedCost()
    {
        return $this->landedCost;
    }
    /**
     * Set landedCost value
     * @param \StructType\LandedCost $landedCost
     * @return \StructType\ItemReceiptItem
     */
    public function setLandedCost(\StructType\LandedCost $landedCost = null)
    {
        $this->landedCost = $landedCost;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ItemReceiptItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
