<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemReceipt StructType
 * Meta information extracted from the WSDL
 * - type: tranPurch:ItemReceipt
 * @subpackage Structs
 */
class ItemReceipt extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partner;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The inboundShipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $inboundShipment;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The itemFulfillment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemFulfillment;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The landedCostMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $landedCostMethod;
    /**
     * The landedCostPerLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $landedCostPerLine;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemReceiptItemList
     */
    public $itemList;
    /**
     * The expenseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemReceiptExpenseList
     */
    public $expenseList;
    /**
     * The landedCostsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PurchLandedCostList
     */
    public $landedCostsList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ItemReceipt
     * @uses ItemReceipt::setCreatedDate()
     * @uses ItemReceipt::setLastModifiedDate()
     * @uses ItemReceipt::setCustomForm()
     * @uses ItemReceipt::setExchangeRate()
     * @uses ItemReceipt::setEntity()
     * @uses ItemReceipt::setCurrencyName()
     * @uses ItemReceipt::setSubsidiary()
     * @uses ItemReceipt::setCreatedFrom()
     * @uses ItemReceipt::setTranDate()
     * @uses ItemReceipt::setPartner()
     * @uses ItemReceipt::setPostingPeriod()
     * @uses ItemReceipt::setTranId()
     * @uses ItemReceipt::setInboundShipment()
     * @uses ItemReceipt::setMemo()
     * @uses ItemReceipt::setItemFulfillment()
     * @uses ItemReceipt::setCurrency()
     * @uses ItemReceipt::setLandedCostMethod()
     * @uses ItemReceipt::setLandedCostPerLine()
     * @uses ItemReceipt::setItemList()
     * @uses ItemReceipt::setExpenseList()
     * @uses ItemReceipt::setLandedCostsList()
     * @uses ItemReceipt::setAccountingBookDetailList()
     * @uses ItemReceipt::setCustomFieldList()
     * @uses ItemReceipt::setInternalId()
     * @uses ItemReceipt::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param float $exchangeRate
     * @param \StructType\RecordRef $entity
     * @param string $currencyName
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $createdFrom
     * @param string $tranDate
     * @param \StructType\RecordRef $partner
     * @param \StructType\RecordRef $postingPeriod
     * @param string $tranId
     * @param \StructType\RecordRef $inboundShipment
     * @param string $memo
     * @param \StructType\RecordRef $itemFulfillment
     * @param \StructType\RecordRef $currency
     * @param string $landedCostMethod
     * @param bool $landedCostPerLine
     * @param \StructType\ItemReceiptItemList $itemList
     * @param \StructType\ItemReceiptExpenseList $expenseList
     * @param \StructType\PurchLandedCostList $landedCostsList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, $exchangeRate = null, \StructType\RecordRef $entity = null, $currencyName = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $createdFrom = null, $tranDate = null, \StructType\RecordRef $partner = null, \StructType\RecordRef $postingPeriod = null, $tranId = null, \StructType\RecordRef $inboundShipment = null, $memo = null, \StructType\RecordRef $itemFulfillment = null, \StructType\RecordRef $currency = null, $landedCostMethod = null, $landedCostPerLine = null, \StructType\ItemReceiptItemList $itemList = null, \StructType\ItemReceiptExpenseList $expenseList = null, \StructType\PurchLandedCostList $landedCostsList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setExchangeRate($exchangeRate)
            ->setEntity($entity)
            ->setCurrencyName($currencyName)
            ->setSubsidiary($subsidiary)
            ->setCreatedFrom($createdFrom)
            ->setTranDate($tranDate)
            ->setPartner($partner)
            ->setPostingPeriod($postingPeriod)
            ->setTranId($tranId)
            ->setInboundShipment($inboundShipment)
            ->setMemo($memo)
            ->setItemFulfillment($itemFulfillment)
            ->setCurrency($currency)
            ->setLandedCostMethod($landedCostMethod)
            ->setLandedCostPerLine($landedCostPerLine)
            ->setItemList($itemList)
            ->setExpenseList($expenseList)
            ->setLandedCostsList($landedCostsList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\ItemReceipt
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\ItemReceipt
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ItemReceipt
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\ItemReceipt
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\ItemReceipt
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\ItemReceipt
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\ItemReceipt
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\ItemReceipt
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\ItemReceipt
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get partner value
     * @return \StructType\RecordRef|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\RecordRef $partner
     * @return \StructType\ItemReceipt
     */
    public function setPartner(\StructType\RecordRef $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\ItemReceipt
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\ItemReceipt
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get inboundShipment value
     * @return \StructType\RecordRef|null
     */
    public function getInboundShipment()
    {
        return $this->inboundShipment;
    }
    /**
     * Set inboundShipment value
     * @param \StructType\RecordRef $inboundShipment
     * @return \StructType\ItemReceipt
     */
    public function setInboundShipment(\StructType\RecordRef $inboundShipment = null)
    {
        $this->inboundShipment = $inboundShipment;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\ItemReceipt
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get itemFulfillment value
     * @return \StructType\RecordRef|null
     */
    public function getItemFulfillment()
    {
        return $this->itemFulfillment;
    }
    /**
     * Set itemFulfillment value
     * @param \StructType\RecordRef $itemFulfillment
     * @return \StructType\ItemReceipt
     */
    public function setItemFulfillment(\StructType\RecordRef $itemFulfillment = null)
    {
        $this->itemFulfillment = $itemFulfillment;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\ItemReceipt
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get landedCostMethod value
     * @return string|null
     */
    public function getLandedCostMethod()
    {
        return $this->landedCostMethod;
    }
    /**
     * Set landedCostMethod value
     * @uses \EnumType\LandedCostMethod::valueIsValid()
     * @uses \EnumType\LandedCostMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $landedCostMethod
     * @return \StructType\ItemReceipt
     */
    public function setLandedCostMethod($landedCostMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LandedCostMethod::valueIsValid($landedCostMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LandedCostMethod', is_array($landedCostMethod) ? implode(', ', $landedCostMethod) : var_export($landedCostMethod, true), implode(', ', \EnumType\LandedCostMethod::getValidValues())), __LINE__);
        }
        $this->landedCostMethod = $landedCostMethod;
        return $this;
    }
    /**
     * Get landedCostPerLine value
     * @return bool|null
     */
    public function getLandedCostPerLine()
    {
        return $this->landedCostPerLine;
    }
    /**
     * Set landedCostPerLine value
     * @param bool $landedCostPerLine
     * @return \StructType\ItemReceipt
     */
    public function setLandedCostPerLine($landedCostPerLine = null)
    {
        // validation for constraint: boolean
        if (!is_null($landedCostPerLine) && !is_bool($landedCostPerLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($landedCostPerLine, true), gettype($landedCostPerLine)), __LINE__);
        }
        $this->landedCostPerLine = $landedCostPerLine;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\ItemReceiptItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\ItemReceiptItemList $itemList
     * @return \StructType\ItemReceipt
     */
    public function setItemList(\StructType\ItemReceiptItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get expenseList value
     * @return \StructType\ItemReceiptExpenseList|null
     */
    public function getExpenseList()
    {
        return $this->expenseList;
    }
    /**
     * Set expenseList value
     * @param \StructType\ItemReceiptExpenseList $expenseList
     * @return \StructType\ItemReceipt
     */
    public function setExpenseList(\StructType\ItemReceiptExpenseList $expenseList = null)
    {
        $this->expenseList = $expenseList;
        return $this;
    }
    /**
     * Get landedCostsList value
     * @return \StructType\PurchLandedCostList|null
     */
    public function getLandedCostsList()
    {
        return $this->landedCostsList;
    }
    /**
     * Set landedCostsList value
     * @param \StructType\PurchLandedCostList $landedCostsList
     * @return \StructType\ItemReceipt
     */
    public function setLandedCostsList(\StructType\PurchLandedCostList $landedCostsList = null)
    {
        $this->landedCostsList = $landedCostsList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\ItemReceipt
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ItemReceipt
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ItemReceipt
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ItemReceipt
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
