<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemOptionsList StructType
 * @subpackage Structs
 */
class ItemOptionsList extends AbstractStructBase
{
    /**
     * The itemOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RecordRef[]
     */
    public $itemOptions;
    /**
     * Constructor method for ItemOptionsList
     * @uses ItemOptionsList::setItemOptions()
     * @param \StructType\RecordRef[] $itemOptions
     */
    public function __construct(array $itemOptions = array())
    {
        $this
            ->setItemOptions($itemOptions);
    }
    /**
     * Get itemOptions value
     * @return \StructType\RecordRef[]|null
     */
    public function getItemOptions()
    {
        return $this->itemOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setItemOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemOptionsForArrayConstraintsFromSetItemOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemOptionsListItemOptionsItem) {
            // validation for constraint: itemType
            if (!$itemOptionsListItemOptionsItem instanceof \StructType\RecordRef) {
                $invalidValues[] = is_object($itemOptionsListItemOptionsItem) ? get_class($itemOptionsListItemOptionsItem) : sprintf('%s(%s)', gettype($itemOptionsListItemOptionsItem), var_export($itemOptionsListItemOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemOptions property can only contain items of type \StructType\RecordRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef[] $itemOptions
     * @return \StructType\ItemOptionsList
     */
    public function setItemOptions(array $itemOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($itemOptionsArrayErrorMessage = self::validateItemOptionsForArrayConstraintsFromSetItemOptions($itemOptions))) {
            throw new \InvalidArgumentException($itemOptionsArrayErrorMessage, __LINE__);
        }
        $this->itemOptions = $itemOptions;
        return $this;
    }
    /**
     * Add item to itemOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef $item
     * @return \StructType\ItemOptionsList
     */
    public function addToItemOptions(\StructType\RecordRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecordRef) {
            throw new \InvalidArgumentException(sprintf('The itemOptions property can only contain items of type \StructType\RecordRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemOptions[] = $item;
        return $this;
    }
}
