<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemFulfillmentPackageUpsList StructType
 * @subpackage Structs
 */
class ItemFulfillmentPackageUpsList extends AbstractStructBase
{
    /**
     * The packageUps
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemFulfillmentPackageUps[]
     */
    public $packageUps;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemFulfillmentPackageUpsList
     * @uses ItemFulfillmentPackageUpsList::setPackageUps()
     * @uses ItemFulfillmentPackageUpsList::setReplaceAll()
     * @param \StructType\ItemFulfillmentPackageUps[] $packageUps
     * @param bool $replaceAll
     */
    public function __construct(array $packageUps = array(), $replaceAll = true)
    {
        $this
            ->setPackageUps($packageUps)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get packageUps value
     * @return \StructType\ItemFulfillmentPackageUps[]|null
     */
    public function getPackageUps()
    {
        return $this->packageUps;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageUps method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageUps method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageUpsForArrayConstraintsFromSetPackageUps(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemFulfillmentPackageUpsListPackageUpsItem) {
            // validation for constraint: itemType
            if (!$itemFulfillmentPackageUpsListPackageUpsItem instanceof \StructType\ItemFulfillmentPackageUps) {
                $invalidValues[] = is_object($itemFulfillmentPackageUpsListPackageUpsItem) ? get_class($itemFulfillmentPackageUpsListPackageUpsItem) : sprintf('%s(%s)', gettype($itemFulfillmentPackageUpsListPackageUpsItem), var_export($itemFulfillmentPackageUpsListPackageUpsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packageUps property can only contain items of type \StructType\ItemFulfillmentPackageUps, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packageUps value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemFulfillmentPackageUps[] $packageUps
     * @return \StructType\ItemFulfillmentPackageUpsList
     */
    public function setPackageUps(array $packageUps = array())
    {
        // validation for constraint: array
        if ('' !== ($packageUpsArrayErrorMessage = self::validatePackageUpsForArrayConstraintsFromSetPackageUps($packageUps))) {
            throw new \InvalidArgumentException($packageUpsArrayErrorMessage, __LINE__);
        }
        $this->packageUps = $packageUps;
        return $this;
    }
    /**
     * Add item to packageUps value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemFulfillmentPackageUps $item
     * @return \StructType\ItemFulfillmentPackageUpsList
     */
    public function addToPackageUps(\StructType\ItemFulfillmentPackageUps $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemFulfillmentPackageUps) {
            throw new \InvalidArgumentException(sprintf('The packageUps property can only contain items of type \StructType\ItemFulfillmentPackageUps, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packageUps[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemFulfillmentPackageUpsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
