<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemFulfillmentItemList StructType
 * @subpackage Structs
 */
class ItemFulfillmentItemList extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemFulfillmentItem[]
     */
    public $item;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemFulfillmentItemList
     * @uses ItemFulfillmentItemList::setItem()
     * @uses ItemFulfillmentItemList::setReplaceAll()
     * @param \StructType\ItemFulfillmentItem[] $item
     * @param bool $replaceAll
     */
    public function __construct(array $item = array(), $replaceAll = true)
    {
        $this
            ->setItem($item)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get item value
     * @return \StructType\ItemFulfillmentItem[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemFulfillmentItemListItemItem) {
            // validation for constraint: itemType
            if (!$itemFulfillmentItemListItemItem instanceof \StructType\ItemFulfillmentItem) {
                $invalidValues[] = is_object($itemFulfillmentItemListItemItem) ? get_class($itemFulfillmentItemListItemItem) : sprintf('%s(%s)', gettype($itemFulfillmentItemListItemItem), var_export($itemFulfillmentItemListItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\ItemFulfillmentItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemFulfillmentItem[] $item
     * @return \StructType\ItemFulfillmentItemList
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemFulfillmentItem $item
     * @return \StructType\ItemFulfillmentItemList
     */
    public function addToItem(\StructType\ItemFulfillmentItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemFulfillmentItem) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\ItemFulfillmentItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemFulfillmentItemList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
