<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemDemandPlanSearchRowBasic StructType
 * @subpackage Structs
 */
class ItemDemandPlanSearchRowBasic extends SearchRowBasic
{
    /**
     * The alternateSourceItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $alternateSourceItem;
    /**
     * The analysisDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $analysisDuration;
    /**
     * The demandDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $demandDate;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $item;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $lastModifiedDate;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $location;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $memo;
    /**
     * The projectionDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $projectionDuration;
    /**
     * The projectionInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $projectionInterval;
    /**
     * The projectionMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $projectionMethod;
    /**
     * The projectionStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $projectionStartDate;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantity;
    /**
     * The quantityUom
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityUom;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiary;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $units;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ItemDemandPlanSearchRowBasic
     * @uses ItemDemandPlanSearchRowBasic::setAlternateSourceItem()
     * @uses ItemDemandPlanSearchRowBasic::setAnalysisDuration()
     * @uses ItemDemandPlanSearchRowBasic::setDemandDate()
     * @uses ItemDemandPlanSearchRowBasic::setExternalId()
     * @uses ItemDemandPlanSearchRowBasic::setInternalId()
     * @uses ItemDemandPlanSearchRowBasic::setItem()
     * @uses ItemDemandPlanSearchRowBasic::setLastModifiedDate()
     * @uses ItemDemandPlanSearchRowBasic::setLocation()
     * @uses ItemDemandPlanSearchRowBasic::setMemo()
     * @uses ItemDemandPlanSearchRowBasic::setProjectionDuration()
     * @uses ItemDemandPlanSearchRowBasic::setProjectionInterval()
     * @uses ItemDemandPlanSearchRowBasic::setProjectionMethod()
     * @uses ItemDemandPlanSearchRowBasic::setProjectionStartDate()
     * @uses ItemDemandPlanSearchRowBasic::setQuantity()
     * @uses ItemDemandPlanSearchRowBasic::setQuantityUom()
     * @uses ItemDemandPlanSearchRowBasic::setSubsidiary()
     * @uses ItemDemandPlanSearchRowBasic::setUnits()
     * @uses ItemDemandPlanSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnSelectField[] $alternateSourceItem
     * @param \StructType\SearchColumnLongField[] $analysisDuration
     * @param \StructType\SearchColumnDateField[] $demandDate
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $item
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @param \StructType\SearchColumnSelectField[] $location
     * @param \StructType\SearchColumnStringField[] $memo
     * @param \StructType\SearchColumnLongField[] $projectionDuration
     * @param \StructType\SearchColumnStringField[] $projectionInterval
     * @param \StructType\SearchColumnStringField[] $projectionMethod
     * @param \StructType\SearchColumnDateField[] $projectionStartDate
     * @param \StructType\SearchColumnDoubleField[] $quantity
     * @param \StructType\SearchColumnDoubleField[] $quantityUom
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @param \StructType\SearchColumnSelectField[] $units
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $alternateSourceItem = array(), array $analysisDuration = array(), array $demandDate = array(), array $externalId = array(), array $internalId = array(), array $item = array(), array $lastModifiedDate = array(), array $location = array(), array $memo = array(), array $projectionDuration = array(), array $projectionInterval = array(), array $projectionMethod = array(), array $projectionStartDate = array(), array $quantity = array(), array $quantityUom = array(), array $subsidiary = array(), array $units = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAlternateSourceItem($alternateSourceItem)
            ->setAnalysisDuration($analysisDuration)
            ->setDemandDate($demandDate)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setItem($item)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLocation($location)
            ->setMemo($memo)
            ->setProjectionDuration($projectionDuration)
            ->setProjectionInterval($projectionInterval)
            ->setProjectionMethod($projectionMethod)
            ->setProjectionStartDate($projectionStartDate)
            ->setQuantity($quantity)
            ->setQuantityUom($quantityUom)
            ->setSubsidiary($subsidiary)
            ->setUnits($units)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get alternateSourceItem value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAlternateSourceItem()
    {
        return $this->alternateSourceItem;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternateSourceItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateSourceItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternateSourceItemForArrayConstraintsFromSetAlternateSourceItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicAlternateSourceItemItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicAlternateSourceItemItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicAlternateSourceItemItem) ? get_class($itemDemandPlanSearchRowBasicAlternateSourceItemItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicAlternateSourceItemItem), var_export($itemDemandPlanSearchRowBasicAlternateSourceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The alternateSourceItem property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set alternateSourceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $alternateSourceItem
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setAlternateSourceItem(array $alternateSourceItem = array())
    {
        // validation for constraint: array
        if ('' !== ($alternateSourceItemArrayErrorMessage = self::validateAlternateSourceItemForArrayConstraintsFromSetAlternateSourceItem($alternateSourceItem))) {
            throw new \InvalidArgumentException($alternateSourceItemArrayErrorMessage, __LINE__);
        }
        $this->alternateSourceItem = $alternateSourceItem;
        return $this;
    }
    /**
     * Add item to alternateSourceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToAlternateSourceItem(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The alternateSourceItem property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->alternateSourceItem[] = $item;
        return $this;
    }
    /**
     * Get analysisDuration value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getAnalysisDuration()
    {
        return $this->analysisDuration;
    }
    /**
     * This method is responsible for validating the values passed to the setAnalysisDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnalysisDuration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnalysisDurationForArrayConstraintsFromSetAnalysisDuration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicAnalysisDurationItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicAnalysisDurationItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicAnalysisDurationItem) ? get_class($itemDemandPlanSearchRowBasicAnalysisDurationItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicAnalysisDurationItem), var_export($itemDemandPlanSearchRowBasicAnalysisDurationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The analysisDuration property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set analysisDuration value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $analysisDuration
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setAnalysisDuration(array $analysisDuration = array())
    {
        // validation for constraint: array
        if ('' !== ($analysisDurationArrayErrorMessage = self::validateAnalysisDurationForArrayConstraintsFromSetAnalysisDuration($analysisDuration))) {
            throw new \InvalidArgumentException($analysisDurationArrayErrorMessage, __LINE__);
        }
        $this->analysisDuration = $analysisDuration;
        return $this;
    }
    /**
     * Add item to analysisDuration value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToAnalysisDuration(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The analysisDuration property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->analysisDuration[] = $item;
        return $this;
    }
    /**
     * Get demandDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getDemandDate()
    {
        return $this->demandDate;
    }
    /**
     * This method is responsible for validating the values passed to the setDemandDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDemandDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDemandDateForArrayConstraintsFromSetDemandDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicDemandDateItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicDemandDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicDemandDateItem) ? get_class($itemDemandPlanSearchRowBasicDemandDateItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicDemandDateItem), var_export($itemDemandPlanSearchRowBasicDemandDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The demandDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set demandDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $demandDate
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setDemandDate(array $demandDate = array())
    {
        // validation for constraint: array
        if ('' !== ($demandDateArrayErrorMessage = self::validateDemandDateForArrayConstraintsFromSetDemandDate($demandDate))) {
            throw new \InvalidArgumentException($demandDateArrayErrorMessage, __LINE__);
        }
        $this->demandDate = $demandDate;
        return $this;
    }
    /**
     * Add item to demandDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToDemandDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The demandDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->demandDate[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicExternalIdItem) ? get_class($itemDemandPlanSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicExternalIdItem), var_export($itemDemandPlanSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicInternalIdItem) ? get_class($itemDemandPlanSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicInternalIdItem), var_export($itemDemandPlanSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicItemItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicItemItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicItemItem) ? get_class($itemDemandPlanSearchRowBasicItemItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicItemItem), var_export($itemDemandPlanSearchRowBasicItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToItem(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * This method is responsible for validating the values passed to the setLastModifiedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastModifiedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicLastModifiedDateItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicLastModifiedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicLastModifiedDateItem) ? get_class($itemDemandPlanSearchRowBasicLastModifiedDateItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicLastModifiedDateItem), var_export($itemDemandPlanSearchRowBasicLastModifiedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setLastModifiedDate(array $lastModifiedDate = array())
    {
        // validation for constraint: array
        if ('' !== ($lastModifiedDateArrayErrorMessage = self::validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate($lastModifiedDate))) {
            throw new \InvalidArgumentException($lastModifiedDateArrayErrorMessage, __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Add item to lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToLastModifiedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lastModifiedDate[] = $item;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicLocationItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicLocationItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicLocationItem) ? get_class($itemDemandPlanSearchRowBasicLocationItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicLocationItem), var_export($itemDemandPlanSearchRowBasicLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $location
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Add item to location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToLocation(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->location[] = $item;
        return $this;
    }
    /**
     * Get memo value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * This method is responsible for validating the values passed to the setMemo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMemo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMemoForArrayConstraintsFromSetMemo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicMemoItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicMemoItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicMemoItem) ? get_class($itemDemandPlanSearchRowBasicMemoItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicMemoItem), var_export($itemDemandPlanSearchRowBasicMemoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The memo property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set memo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $memo
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setMemo(array $memo = array())
    {
        // validation for constraint: array
        if ('' !== ($memoArrayErrorMessage = self::validateMemoForArrayConstraintsFromSetMemo($memo))) {
            throw new \InvalidArgumentException($memoArrayErrorMessage, __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Add item to memo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToMemo(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The memo property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->memo[] = $item;
        return $this;
    }
    /**
     * Get projectionDuration value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getProjectionDuration()
    {
        return $this->projectionDuration;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectionDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectionDuration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectionDurationForArrayConstraintsFromSetProjectionDuration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicProjectionDurationItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicProjectionDurationItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicProjectionDurationItem) ? get_class($itemDemandPlanSearchRowBasicProjectionDurationItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicProjectionDurationItem), var_export($itemDemandPlanSearchRowBasicProjectionDurationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The projectionDuration property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set projectionDuration value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $projectionDuration
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setProjectionDuration(array $projectionDuration = array())
    {
        // validation for constraint: array
        if ('' !== ($projectionDurationArrayErrorMessage = self::validateProjectionDurationForArrayConstraintsFromSetProjectionDuration($projectionDuration))) {
            throw new \InvalidArgumentException($projectionDurationArrayErrorMessage, __LINE__);
        }
        $this->projectionDuration = $projectionDuration;
        return $this;
    }
    /**
     * Add item to projectionDuration value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToProjectionDuration(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The projectionDuration property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->projectionDuration[] = $item;
        return $this;
    }
    /**
     * Get projectionInterval value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getProjectionInterval()
    {
        return $this->projectionInterval;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectionInterval method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectionInterval method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectionIntervalForArrayConstraintsFromSetProjectionInterval(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicProjectionIntervalItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicProjectionIntervalItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicProjectionIntervalItem) ? get_class($itemDemandPlanSearchRowBasicProjectionIntervalItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicProjectionIntervalItem), var_export($itemDemandPlanSearchRowBasicProjectionIntervalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The projectionInterval property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set projectionInterval value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $projectionInterval
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setProjectionInterval(array $projectionInterval = array())
    {
        // validation for constraint: array
        if ('' !== ($projectionIntervalArrayErrorMessage = self::validateProjectionIntervalForArrayConstraintsFromSetProjectionInterval($projectionInterval))) {
            throw new \InvalidArgumentException($projectionIntervalArrayErrorMessage, __LINE__);
        }
        $this->projectionInterval = $projectionInterval;
        return $this;
    }
    /**
     * Add item to projectionInterval value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToProjectionInterval(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The projectionInterval property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->projectionInterval[] = $item;
        return $this;
    }
    /**
     * Get projectionMethod value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getProjectionMethod()
    {
        return $this->projectionMethod;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectionMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectionMethod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectionMethodForArrayConstraintsFromSetProjectionMethod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicProjectionMethodItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicProjectionMethodItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicProjectionMethodItem) ? get_class($itemDemandPlanSearchRowBasicProjectionMethodItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicProjectionMethodItem), var_export($itemDemandPlanSearchRowBasicProjectionMethodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The projectionMethod property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set projectionMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $projectionMethod
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setProjectionMethod(array $projectionMethod = array())
    {
        // validation for constraint: array
        if ('' !== ($projectionMethodArrayErrorMessage = self::validateProjectionMethodForArrayConstraintsFromSetProjectionMethod($projectionMethod))) {
            throw new \InvalidArgumentException($projectionMethodArrayErrorMessage, __LINE__);
        }
        $this->projectionMethod = $projectionMethod;
        return $this;
    }
    /**
     * Add item to projectionMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToProjectionMethod(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The projectionMethod property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->projectionMethod[] = $item;
        return $this;
    }
    /**
     * Get projectionStartDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getProjectionStartDate()
    {
        return $this->projectionStartDate;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectionStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectionStartDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectionStartDateForArrayConstraintsFromSetProjectionStartDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicProjectionStartDateItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicProjectionStartDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicProjectionStartDateItem) ? get_class($itemDemandPlanSearchRowBasicProjectionStartDateItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicProjectionStartDateItem), var_export($itemDemandPlanSearchRowBasicProjectionStartDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The projectionStartDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set projectionStartDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $projectionStartDate
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setProjectionStartDate(array $projectionStartDate = array())
    {
        // validation for constraint: array
        if ('' !== ($projectionStartDateArrayErrorMessage = self::validateProjectionStartDateForArrayConstraintsFromSetProjectionStartDate($projectionStartDate))) {
            throw new \InvalidArgumentException($projectionStartDateArrayErrorMessage, __LINE__);
        }
        $this->projectionStartDate = $projectionStartDate;
        return $this;
    }
    /**
     * Add item to projectionStartDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToProjectionStartDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The projectionStartDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->projectionStartDate[] = $item;
        return $this;
    }
    /**
     * Get quantity value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityForArrayConstraintsFromSetQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicQuantityItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicQuantityItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicQuantityItem) ? get_class($itemDemandPlanSearchRowBasicQuantityItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicQuantityItem), var_export($itemDemandPlanSearchRowBasicQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantity property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantity
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setQuantity(array $quantity = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityArrayErrorMessage = self::validateQuantityForArrayConstraintsFromSetQuantity($quantity))) {
            throw new \InvalidArgumentException($quantityArrayErrorMessage, __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Add item to quantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToQuantity(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantity property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantity[] = $item;
        return $this;
    }
    /**
     * Get quantityUom value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityUom()
    {
        return $this->quantityUom;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityUom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityUom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityUomForArrayConstraintsFromSetQuantityUom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicQuantityUomItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicQuantityUomItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicQuantityUomItem) ? get_class($itemDemandPlanSearchRowBasicQuantityUomItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicQuantityUomItem), var_export($itemDemandPlanSearchRowBasicQuantityUomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityUom property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityUom value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityUom
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setQuantityUom(array $quantityUom = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityUomArrayErrorMessage = self::validateQuantityUomForArrayConstraintsFromSetQuantityUom($quantityUom))) {
            throw new \InvalidArgumentException($quantityUomArrayErrorMessage, __LINE__);
        }
        $this->quantityUom = $quantityUom;
        return $this;
    }
    /**
     * Add item to quantityUom value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToQuantityUom(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityUom property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityUom[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicSubsidiaryItem) ? get_class($itemDemandPlanSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicSubsidiaryItem), var_export($itemDemandPlanSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * This method is responsible for validating the values passed to the setUnits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitsForArrayConstraintsFromSetUnits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDemandPlanSearchRowBasicUnitsItem) {
            // validation for constraint: itemType
            if (!$itemDemandPlanSearchRowBasicUnitsItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemDemandPlanSearchRowBasicUnitsItem) ? get_class($itemDemandPlanSearchRowBasicUnitsItem) : sprintf('%s(%s)', gettype($itemDemandPlanSearchRowBasicUnitsItem), var_export($itemDemandPlanSearchRowBasicUnitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The units property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set units value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $units
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setUnits(array $units = array())
    {
        // validation for constraint: array
        if ('' !== ($unitsArrayErrorMessage = self::validateUnitsForArrayConstraintsFromSetUnits($units))) {
            throw new \InvalidArgumentException($unitsArrayErrorMessage, __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Add item to units value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function addToUnits(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The units property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->units[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\ItemDemandPlanSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
