<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemAvailability StructType
 * @subpackage Structs
 */
class ItemAvailability extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The lastQtyAvailableChange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastQtyAvailableChange;
    /**
     * The locationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $locationId;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The onHandValueMli
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $onHandValueMli;
    /**
     * The reorderPoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $reorderPoint;
    /**
     * The preferredStockLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $preferredStockLevel;
    /**
     * The quantityOnOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnOrder;
    /**
     * The quantityCommitted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityCommitted;
    /**
     * The quantityBackOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityBackOrdered;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * Constructor method for ItemAvailability
     * @uses ItemAvailability::setItem()
     * @uses ItemAvailability::setLastQtyAvailableChange()
     * @uses ItemAvailability::setLocationId()
     * @uses ItemAvailability::setQuantityOnHand()
     * @uses ItemAvailability::setOnHandValueMli()
     * @uses ItemAvailability::setReorderPoint()
     * @uses ItemAvailability::setPreferredStockLevel()
     * @uses ItemAvailability::setQuantityOnOrder()
     * @uses ItemAvailability::setQuantityCommitted()
     * @uses ItemAvailability::setQuantityBackOrdered()
     * @uses ItemAvailability::setQuantityAvailable()
     * @param \StructType\RecordRef $item
     * @param string $lastQtyAvailableChange
     * @param \StructType\RecordRef $locationId
     * @param float $quantityOnHand
     * @param float $onHandValueMli
     * @param float $reorderPoint
     * @param float $preferredStockLevel
     * @param float $quantityOnOrder
     * @param float $quantityCommitted
     * @param float $quantityBackOrdered
     * @param float $quantityAvailable
     */
    public function __construct(\StructType\RecordRef $item = null, $lastQtyAvailableChange = null, \StructType\RecordRef $locationId = null, $quantityOnHand = null, $onHandValueMli = null, $reorderPoint = null, $preferredStockLevel = null, $quantityOnOrder = null, $quantityCommitted = null, $quantityBackOrdered = null, $quantityAvailable = null)
    {
        $this
            ->setItem($item)
            ->setLastQtyAvailableChange($lastQtyAvailableChange)
            ->setLocationId($locationId)
            ->setQuantityOnHand($quantityOnHand)
            ->setOnHandValueMli($onHandValueMli)
            ->setReorderPoint($reorderPoint)
            ->setPreferredStockLevel($preferredStockLevel)
            ->setQuantityOnOrder($quantityOnOrder)
            ->setQuantityCommitted($quantityCommitted)
            ->setQuantityBackOrdered($quantityBackOrdered)
            ->setQuantityAvailable($quantityAvailable);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\ItemAvailability
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get lastQtyAvailableChange value
     * @return string|null
     */
    public function getLastQtyAvailableChange()
    {
        return $this->lastQtyAvailableChange;
    }
    /**
     * Set lastQtyAvailableChange value
     * @param string $lastQtyAvailableChange
     * @return \StructType\ItemAvailability
     */
    public function setLastQtyAvailableChange($lastQtyAvailableChange = null)
    {
        // validation for constraint: string
        if (!is_null($lastQtyAvailableChange) && !is_string($lastQtyAvailableChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastQtyAvailableChange, true), gettype($lastQtyAvailableChange)), __LINE__);
        }
        $this->lastQtyAvailableChange = $lastQtyAvailableChange;
        return $this;
    }
    /**
     * Get locationId value
     * @return \StructType\RecordRef|null
     */
    public function getLocationId()
    {
        return $this->locationId;
    }
    /**
     * Set locationId value
     * @param \StructType\RecordRef $locationId
     * @return \StructType\ItemAvailability
     */
    public function setLocationId(\StructType\RecordRef $locationId = null)
    {
        $this->locationId = $locationId;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\ItemAvailability
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get onHandValueMli value
     * @return float|null
     */
    public function getOnHandValueMli()
    {
        return $this->onHandValueMli;
    }
    /**
     * Set onHandValueMli value
     * @param float $onHandValueMli
     * @return \StructType\ItemAvailability
     */
    public function setOnHandValueMli($onHandValueMli = null)
    {
        // validation for constraint: float
        if (!is_null($onHandValueMli) && !(is_float($onHandValueMli) || is_numeric($onHandValueMli))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onHandValueMli, true), gettype($onHandValueMli)), __LINE__);
        }
        $this->onHandValueMli = $onHandValueMli;
        return $this;
    }
    /**
     * Get reorderPoint value
     * @return float|null
     */
    public function getReorderPoint()
    {
        return $this->reorderPoint;
    }
    /**
     * Set reorderPoint value
     * @param float $reorderPoint
     * @return \StructType\ItemAvailability
     */
    public function setReorderPoint($reorderPoint = null)
    {
        // validation for constraint: float
        if (!is_null($reorderPoint) && !(is_float($reorderPoint) || is_numeric($reorderPoint))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reorderPoint, true), gettype($reorderPoint)), __LINE__);
        }
        $this->reorderPoint = $reorderPoint;
        return $this;
    }
    /**
     * Get preferredStockLevel value
     * @return float|null
     */
    public function getPreferredStockLevel()
    {
        return $this->preferredStockLevel;
    }
    /**
     * Set preferredStockLevel value
     * @param float $preferredStockLevel
     * @return \StructType\ItemAvailability
     */
    public function setPreferredStockLevel($preferredStockLevel = null)
    {
        // validation for constraint: float
        if (!is_null($preferredStockLevel) && !(is_float($preferredStockLevel) || is_numeric($preferredStockLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preferredStockLevel, true), gettype($preferredStockLevel)), __LINE__);
        }
        $this->preferredStockLevel = $preferredStockLevel;
        return $this;
    }
    /**
     * Get quantityOnOrder value
     * @return float|null
     */
    public function getQuantityOnOrder()
    {
        return $this->quantityOnOrder;
    }
    /**
     * Set quantityOnOrder value
     * @param float $quantityOnOrder
     * @return \StructType\ItemAvailability
     */
    public function setQuantityOnOrder($quantityOnOrder = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnOrder) && !(is_float($quantityOnOrder) || is_numeric($quantityOnOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnOrder, true), gettype($quantityOnOrder)), __LINE__);
        }
        $this->quantityOnOrder = $quantityOnOrder;
        return $this;
    }
    /**
     * Get quantityCommitted value
     * @return float|null
     */
    public function getQuantityCommitted()
    {
        return $this->quantityCommitted;
    }
    /**
     * Set quantityCommitted value
     * @param float $quantityCommitted
     * @return \StructType\ItemAvailability
     */
    public function setQuantityCommitted($quantityCommitted = null)
    {
        // validation for constraint: float
        if (!is_null($quantityCommitted) && !(is_float($quantityCommitted) || is_numeric($quantityCommitted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityCommitted, true), gettype($quantityCommitted)), __LINE__);
        }
        $this->quantityCommitted = $quantityCommitted;
        return $this;
    }
    /**
     * Get quantityBackOrdered value
     * @return float|null
     */
    public function getQuantityBackOrdered()
    {
        return $this->quantityBackOrdered;
    }
    /**
     * Set quantityBackOrdered value
     * @param float $quantityBackOrdered
     * @return \StructType\ItemAvailability
     */
    public function setQuantityBackOrdered($quantityBackOrdered = null)
    {
        // validation for constraint: float
        if (!is_null($quantityBackOrdered) && !(is_float($quantityBackOrdered) || is_numeric($quantityBackOrdered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityBackOrdered, true), gettype($quantityBackOrdered)), __LINE__);
        }
        $this->quantityBackOrdered = $quantityBackOrdered;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\ItemAvailability
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
}
