<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemAccountMappingSearch StructType
 * @subpackage Structs
 */
class ItemAccountMappingSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemAccountMappingSearchBasic
     */
    public $basic;
    /**
     * The classJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ClassificationSearchBasic
     */
    public $classJoin;
    /**
     * The departmentJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DepartmentSearchBasic
     */
    public $departmentJoin;
    /**
     * The destinationAccountJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountSearchBasic
     */
    public $destinationAccountJoin;
    /**
     * The locationJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationSearchBasic
     */
    public $locationJoin;
    /**
     * The sourceAccountJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountSearchBasic
     */
    public $sourceAccountJoin;
    /**
     * The subsidiaryJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubsidiarySearchBasic
     */
    public $subsidiaryJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for ItemAccountMappingSearch
     * @uses ItemAccountMappingSearch::setBasic()
     * @uses ItemAccountMappingSearch::setClassJoin()
     * @uses ItemAccountMappingSearch::setDepartmentJoin()
     * @uses ItemAccountMappingSearch::setDestinationAccountJoin()
     * @uses ItemAccountMappingSearch::setLocationJoin()
     * @uses ItemAccountMappingSearch::setSourceAccountJoin()
     * @uses ItemAccountMappingSearch::setSubsidiaryJoin()
     * @uses ItemAccountMappingSearch::setCustomSearchJoin()
     * @param \StructType\ItemAccountMappingSearchBasic $basic
     * @param \StructType\ClassificationSearchBasic $classJoin
     * @param \StructType\DepartmentSearchBasic $departmentJoin
     * @param \StructType\AccountSearchBasic $destinationAccountJoin
     * @param \StructType\LocationSearchBasic $locationJoin
     * @param \StructType\AccountSearchBasic $sourceAccountJoin
     * @param \StructType\SubsidiarySearchBasic $subsidiaryJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\ItemAccountMappingSearchBasic $basic = null, \StructType\ClassificationSearchBasic $classJoin = null, \StructType\DepartmentSearchBasic $departmentJoin = null, \StructType\AccountSearchBasic $destinationAccountJoin = null, \StructType\LocationSearchBasic $locationJoin = null, \StructType\AccountSearchBasic $sourceAccountJoin = null, \StructType\SubsidiarySearchBasic $subsidiaryJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setClassJoin($classJoin)
            ->setDepartmentJoin($departmentJoin)
            ->setDestinationAccountJoin($destinationAccountJoin)
            ->setLocationJoin($locationJoin)
            ->setSourceAccountJoin($sourceAccountJoin)
            ->setSubsidiaryJoin($subsidiaryJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\ItemAccountMappingSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\ItemAccountMappingSearchBasic $basic
     * @return \StructType\ItemAccountMappingSearch
     */
    public function setBasic(\StructType\ItemAccountMappingSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get classJoin value
     * @return \StructType\ClassificationSearchBasic|null
     */
    public function getClassJoin()
    {
        return $this->classJoin;
    }
    /**
     * Set classJoin value
     * @param \StructType\ClassificationSearchBasic $classJoin
     * @return \StructType\ItemAccountMappingSearch
     */
    public function setClassJoin(\StructType\ClassificationSearchBasic $classJoin = null)
    {
        $this->classJoin = $classJoin;
        return $this;
    }
    /**
     * Get departmentJoin value
     * @return \StructType\DepartmentSearchBasic|null
     */
    public function getDepartmentJoin()
    {
        return $this->departmentJoin;
    }
    /**
     * Set departmentJoin value
     * @param \StructType\DepartmentSearchBasic $departmentJoin
     * @return \StructType\ItemAccountMappingSearch
     */
    public function setDepartmentJoin(\StructType\DepartmentSearchBasic $departmentJoin = null)
    {
        $this->departmentJoin = $departmentJoin;
        return $this;
    }
    /**
     * Get destinationAccountJoin value
     * @return \StructType\AccountSearchBasic|null
     */
    public function getDestinationAccountJoin()
    {
        return $this->destinationAccountJoin;
    }
    /**
     * Set destinationAccountJoin value
     * @param \StructType\AccountSearchBasic $destinationAccountJoin
     * @return \StructType\ItemAccountMappingSearch
     */
    public function setDestinationAccountJoin(\StructType\AccountSearchBasic $destinationAccountJoin = null)
    {
        $this->destinationAccountJoin = $destinationAccountJoin;
        return $this;
    }
    /**
     * Get locationJoin value
     * @return \StructType\LocationSearchBasic|null
     */
    public function getLocationJoin()
    {
        return $this->locationJoin;
    }
    /**
     * Set locationJoin value
     * @param \StructType\LocationSearchBasic $locationJoin
     * @return \StructType\ItemAccountMappingSearch
     */
    public function setLocationJoin(\StructType\LocationSearchBasic $locationJoin = null)
    {
        $this->locationJoin = $locationJoin;
        return $this;
    }
    /**
     * Get sourceAccountJoin value
     * @return \StructType\AccountSearchBasic|null
     */
    public function getSourceAccountJoin()
    {
        return $this->sourceAccountJoin;
    }
    /**
     * Set sourceAccountJoin value
     * @param \StructType\AccountSearchBasic $sourceAccountJoin
     * @return \StructType\ItemAccountMappingSearch
     */
    public function setSourceAccountJoin(\StructType\AccountSearchBasic $sourceAccountJoin = null)
    {
        $this->sourceAccountJoin = $sourceAccountJoin;
        return $this;
    }
    /**
     * Get subsidiaryJoin value
     * @return \StructType\SubsidiarySearchBasic|null
     */
    public function getSubsidiaryJoin()
    {
        return $this->subsidiaryJoin;
    }
    /**
     * Set subsidiaryJoin value
     * @param \StructType\SubsidiarySearchBasic $subsidiaryJoin
     * @return \StructType\ItemAccountMappingSearch
     */
    public function setSubsidiaryJoin(\StructType\SubsidiarySearchBasic $subsidiaryJoin = null)
    {
        $this->subsidiaryJoin = $subsidiaryJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemAccountMappingSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$itemAccountMappingSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($itemAccountMappingSearchCustomSearchJoinItem) ? get_class($itemAccountMappingSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($itemAccountMappingSearchCustomSearchJoinItem), var_export($itemAccountMappingSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\ItemAccountMappingSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\ItemAccountMappingSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
