<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssueSearchRow StructType
 * @subpackage Structs
 */
class IssueSearchRow extends SearchRow
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IssueSearchRowBasic
     */
    public $basic;
    /**
     * The caseJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SupportCaseSearchRowBasic
     */
    public $caseJoin;
    /**
     * The employeeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchRowBasic
     */
    public $employeeJoin;
    /**
     * The fileJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FileSearchRowBasic
     */
    public $fileJoin;
    /**
     * The productTeamJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EntityGroupSearchRowBasic
     */
    public $productTeamJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchRowBasic
     */
    public $userJoin;
    /**
     * The userNotesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoteSearchRowBasic
     */
    public $userNotesJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchRowBasic[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for IssueSearchRow
     * @uses IssueSearchRow::setBasic()
     * @uses IssueSearchRow::setCaseJoin()
     * @uses IssueSearchRow::setEmployeeJoin()
     * @uses IssueSearchRow::setFileJoin()
     * @uses IssueSearchRow::setProductTeamJoin()
     * @uses IssueSearchRow::setUserJoin()
     * @uses IssueSearchRow::setUserNotesJoin()
     * @uses IssueSearchRow::setCustomSearchJoin()
     * @param \StructType\IssueSearchRowBasic $basic
     * @param \StructType\SupportCaseSearchRowBasic $caseJoin
     * @param \StructType\EmployeeSearchRowBasic $employeeJoin
     * @param \StructType\FileSearchRowBasic $fileJoin
     * @param \StructType\EntityGroupSearchRowBasic $productTeamJoin
     * @param \StructType\EmployeeSearchRowBasic $userJoin
     * @param \StructType\NoteSearchRowBasic $userNotesJoin
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     */
    public function __construct(\StructType\IssueSearchRowBasic $basic = null, \StructType\SupportCaseSearchRowBasic $caseJoin = null, \StructType\EmployeeSearchRowBasic $employeeJoin = null, \StructType\FileSearchRowBasic $fileJoin = null, \StructType\EntityGroupSearchRowBasic $productTeamJoin = null, \StructType\EmployeeSearchRowBasic $userJoin = null, \StructType\NoteSearchRowBasic $userNotesJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setCaseJoin($caseJoin)
            ->setEmployeeJoin($employeeJoin)
            ->setFileJoin($fileJoin)
            ->setProductTeamJoin($productTeamJoin)
            ->setUserJoin($userJoin)
            ->setUserNotesJoin($userNotesJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\IssueSearchRowBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\IssueSearchRowBasic $basic
     * @return \StructType\IssueSearchRow
     */
    public function setBasic(\StructType\IssueSearchRowBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get caseJoin value
     * @return \StructType\SupportCaseSearchRowBasic|null
     */
    public function getCaseJoin()
    {
        return $this->caseJoin;
    }
    /**
     * Set caseJoin value
     * @param \StructType\SupportCaseSearchRowBasic $caseJoin
     * @return \StructType\IssueSearchRow
     */
    public function setCaseJoin(\StructType\SupportCaseSearchRowBasic $caseJoin = null)
    {
        $this->caseJoin = $caseJoin;
        return $this;
    }
    /**
     * Get employeeJoin value
     * @return \StructType\EmployeeSearchRowBasic|null
     */
    public function getEmployeeJoin()
    {
        return $this->employeeJoin;
    }
    /**
     * Set employeeJoin value
     * @param \StructType\EmployeeSearchRowBasic $employeeJoin
     * @return \StructType\IssueSearchRow
     */
    public function setEmployeeJoin(\StructType\EmployeeSearchRowBasic $employeeJoin = null)
    {
        $this->employeeJoin = $employeeJoin;
        return $this;
    }
    /**
     * Get fileJoin value
     * @return \StructType\FileSearchRowBasic|null
     */
    public function getFileJoin()
    {
        return $this->fileJoin;
    }
    /**
     * Set fileJoin value
     * @param \StructType\FileSearchRowBasic $fileJoin
     * @return \StructType\IssueSearchRow
     */
    public function setFileJoin(\StructType\FileSearchRowBasic $fileJoin = null)
    {
        $this->fileJoin = $fileJoin;
        return $this;
    }
    /**
     * Get productTeamJoin value
     * @return \StructType\EntityGroupSearchRowBasic|null
     */
    public function getProductTeamJoin()
    {
        return $this->productTeamJoin;
    }
    /**
     * Set productTeamJoin value
     * @param \StructType\EntityGroupSearchRowBasic $productTeamJoin
     * @return \StructType\IssueSearchRow
     */
    public function setProductTeamJoin(\StructType\EntityGroupSearchRowBasic $productTeamJoin = null)
    {
        $this->productTeamJoin = $productTeamJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchRowBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchRowBasic $userJoin
     * @return \StructType\IssueSearchRow
     */
    public function setUserJoin(\StructType\EmployeeSearchRowBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get userNotesJoin value
     * @return \StructType\NoteSearchRowBasic|null
     */
    public function getUserNotesJoin()
    {
        return $this->userNotesJoin;
    }
    /**
     * Set userNotesJoin value
     * @param \StructType\NoteSearchRowBasic $userNotesJoin
     * @return \StructType\IssueSearchRow
     */
    public function setUserNotesJoin(\StructType\NoteSearchRowBasic $userNotesJoin = null)
    {
        $this->userNotesJoin = $userNotesJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchRowBasic[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issueSearchRowCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$issueSearchRowCustomSearchJoinItem instanceof \StructType\CustomSearchRowBasic) {
                $invalidValues[] = is_object($issueSearchRowCustomSearchJoinItem) ? get_class($issueSearchRowCustomSearchJoinItem) : sprintf('%s(%s)', gettype($issueSearchRowCustomSearchJoinItem), var_export($issueSearchRowCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     * @return \StructType\IssueSearchRow
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic $item
     * @return \StructType\IssueSearchRow
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchRowBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchRowBasic) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
