<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssueRelatedIssues StructType
 * @subpackage Structs
 */
class IssueRelatedIssues extends AbstractStructBase
{
    /**
     * The relationship
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relationship;
    /**
     * The issueNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueNumber;
    /**
     * The relationshipComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relationshipComment;
    /**
     * Constructor method for IssueRelatedIssues
     * @uses IssueRelatedIssues::setRelationship()
     * @uses IssueRelatedIssues::setIssueNumber()
     * @uses IssueRelatedIssues::setRelationshipComment()
     * @param string $relationship
     * @param \StructType\RecordRef $issueNumber
     * @param string $relationshipComment
     */
    public function __construct($relationship = null, \StructType\RecordRef $issueNumber = null, $relationshipComment = null)
    {
        $this
            ->setRelationship($relationship)
            ->setIssueNumber($issueNumber)
            ->setRelationshipComment($relationshipComment);
    }
    /**
     * Get relationship value
     * @return string|null
     */
    public function getRelationship()
    {
        return $this->relationship;
    }
    /**
     * Set relationship value
     * @uses \EnumType\IssueRelationship::valueIsValid()
     * @uses \EnumType\IssueRelationship::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationship
     * @return \StructType\IssueRelatedIssues
     */
    public function setRelationship($relationship = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueRelationship::valueIsValid($relationship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueRelationship', is_array($relationship) ? implode(', ', $relationship) : var_export($relationship, true), implode(', ', \EnumType\IssueRelationship::getValidValues())), __LINE__);
        }
        $this->relationship = $relationship;
        return $this;
    }
    /**
     * Get issueNumber value
     * @return \StructType\RecordRef|null
     */
    public function getIssueNumber()
    {
        return $this->issueNumber;
    }
    /**
     * Set issueNumber value
     * @param \StructType\RecordRef $issueNumber
     * @return \StructType\IssueRelatedIssues
     */
    public function setIssueNumber(\StructType\RecordRef $issueNumber = null)
    {
        $this->issueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get relationshipComment value
     * @return string|null
     */
    public function getRelationshipComment()
    {
        return $this->relationshipComment;
    }
    /**
     * Set relationshipComment value
     * @param string $relationshipComment
     * @return \StructType\IssueRelatedIssues
     */
    public function setRelationshipComment($relationshipComment = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipComment) && !is_string($relationshipComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipComment, true), gettype($relationshipComment)), __LINE__);
        }
        $this->relationshipComment = $relationshipComment;
        return $this;
    }
}
