<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceItemCost StructType
 * @subpackage Structs
 */
class InvoiceItemCost extends AbstractStructBase
{
    /**
     * The apply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $apply;
    /**
     * The doc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $doc;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The billedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billedDate;
    /**
     * The itemDisp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemDisp;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The jobDisp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $jobDisp;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The unitDisp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitDisp;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The itemCostCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemCostCount;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $quantity;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The revRecStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecStartDate;
    /**
     * The revRecEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecEndDate;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * Constructor method for InvoiceItemCost
     * @uses InvoiceItemCost::setApply()
     * @uses InvoiceItemCost::setDoc()
     * @uses InvoiceItemCost::setLine()
     * @uses InvoiceItemCost::setTaxDetailsReference()
     * @uses InvoiceItemCost::setBilledDate()
     * @uses InvoiceItemCost::setItemDisp()
     * @uses InvoiceItemCost::setMemo()
     * @uses InvoiceItemCost::setJobDisp()
     * @uses InvoiceItemCost::setDepartment()
     * @uses InvoiceItemCost::setClass()
     * @uses InvoiceItemCost::setLocation()
     * @uses InvoiceItemCost::setUnitDisp()
     * @uses InvoiceItemCost::setOptions()
     * @uses InvoiceItemCost::setItemCostCount()
     * @uses InvoiceItemCost::setQuantity()
     * @uses InvoiceItemCost::setSerialNumbers()
     * @uses InvoiceItemCost::setCost()
     * @uses InvoiceItemCost::setAmount()
     * @uses InvoiceItemCost::setTaxAmount()
     * @uses InvoiceItemCost::setRevRecSchedule()
     * @uses InvoiceItemCost::setRevRecStartDate()
     * @uses InvoiceItemCost::setRevRecEndDate()
     * @uses InvoiceItemCost::setGrossAmt()
     * @uses InvoiceItemCost::setTax1Amt()
     * @uses InvoiceItemCost::setTaxCode()
     * @uses InvoiceItemCost::setTaxRate1()
     * @uses InvoiceItemCost::setTaxRate2()
     * @param bool $apply
     * @param int $doc
     * @param int $line
     * @param string $taxDetailsReference
     * @param string $billedDate
     * @param string $itemDisp
     * @param string $memo
     * @param string $jobDisp
     * @param string $department
     * @param string $class
     * @param string $location
     * @param string $unitDisp
     * @param \StructType\CustomFieldList $options
     * @param string $itemCostCount
     * @param string $quantity
     * @param string $serialNumbers
     * @param float $cost
     * @param float $amount
     * @param float $taxAmount
     * @param \StructType\RecordRef $revRecSchedule
     * @param string $revRecStartDate
     * @param string $revRecEndDate
     * @param float $grossAmt
     * @param float $tax1Amt
     * @param \StructType\RecordRef $taxCode
     * @param float $taxRate1
     * @param float $taxRate2
     */
    public function __construct($apply = null, $doc = null, $line = null, $taxDetailsReference = null, $billedDate = null, $itemDisp = null, $memo = null, $jobDisp = null, $department = null, $class = null, $location = null, $unitDisp = null, \StructType\CustomFieldList $options = null, $itemCostCount = null, $quantity = null, $serialNumbers = null, $cost = null, $amount = null, $taxAmount = null, \StructType\RecordRef $revRecSchedule = null, $revRecStartDate = null, $revRecEndDate = null, $grossAmt = null, $tax1Amt = null, \StructType\RecordRef $taxCode = null, $taxRate1 = null, $taxRate2 = null)
    {
        $this
            ->setApply($apply)
            ->setDoc($doc)
            ->setLine($line)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setBilledDate($billedDate)
            ->setItemDisp($itemDisp)
            ->setMemo($memo)
            ->setJobDisp($jobDisp)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setUnitDisp($unitDisp)
            ->setOptions($options)
            ->setItemCostCount($itemCostCount)
            ->setQuantity($quantity)
            ->setSerialNumbers($serialNumbers)
            ->setCost($cost)
            ->setAmount($amount)
            ->setTaxAmount($taxAmount)
            ->setRevRecSchedule($revRecSchedule)
            ->setRevRecStartDate($revRecStartDate)
            ->setRevRecEndDate($revRecEndDate)
            ->setGrossAmt($grossAmt)
            ->setTax1Amt($tax1Amt)
            ->setTaxCode($taxCode)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2);
    }
    /**
     * Get apply value
     * @return bool|null
     */
    public function getApply()
    {
        return $this->apply;
    }
    /**
     * Set apply value
     * @param bool $apply
     * @return \StructType\InvoiceItemCost
     */
    public function setApply($apply = null)
    {
        // validation for constraint: boolean
        if (!is_null($apply) && !is_bool($apply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($apply, true), gettype($apply)), __LINE__);
        }
        $this->apply = $apply;
        return $this;
    }
    /**
     * Get doc value
     * @return int|null
     */
    public function getDoc()
    {
        return $this->doc;
    }
    /**
     * Set doc value
     * @param int $doc
     * @return \StructType\InvoiceItemCost
     */
    public function setDoc($doc = null)
    {
        // validation for constraint: int
        if (!is_null($doc) && !(is_int($doc) || ctype_digit($doc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doc, true), gettype($doc)), __LINE__);
        }
        $this->doc = $doc;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\InvoiceItemCost
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\InvoiceItemCost
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get billedDate value
     * @return string|null
     */
    public function getBilledDate()
    {
        return $this->billedDate;
    }
    /**
     * Set billedDate value
     * @param string $billedDate
     * @return \StructType\InvoiceItemCost
     */
    public function setBilledDate($billedDate = null)
    {
        // validation for constraint: string
        if (!is_null($billedDate) && !is_string($billedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billedDate, true), gettype($billedDate)), __LINE__);
        }
        $this->billedDate = $billedDate;
        return $this;
    }
    /**
     * Get itemDisp value
     * @return string|null
     */
    public function getItemDisp()
    {
        return $this->itemDisp;
    }
    /**
     * Set itemDisp value
     * @param string $itemDisp
     * @return \StructType\InvoiceItemCost
     */
    public function setItemDisp($itemDisp = null)
    {
        // validation for constraint: string
        if (!is_null($itemDisp) && !is_string($itemDisp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDisp, true), gettype($itemDisp)), __LINE__);
        }
        $this->itemDisp = $itemDisp;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\InvoiceItemCost
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get jobDisp value
     * @return string|null
     */
    public function getJobDisp()
    {
        return $this->jobDisp;
    }
    /**
     * Set jobDisp value
     * @param string $jobDisp
     * @return \StructType\InvoiceItemCost
     */
    public function setJobDisp($jobDisp = null)
    {
        // validation for constraint: string
        if (!is_null($jobDisp) && !is_string($jobDisp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobDisp, true), gettype($jobDisp)), __LINE__);
        }
        $this->jobDisp = $jobDisp;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \StructType\InvoiceItemCost
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \StructType\InvoiceItemCost
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class, true), gettype($class)), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\InvoiceItemCost
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get unitDisp value
     * @return string|null
     */
    public function getUnitDisp()
    {
        return $this->unitDisp;
    }
    /**
     * Set unitDisp value
     * @param string $unitDisp
     * @return \StructType\InvoiceItemCost
     */
    public function setUnitDisp($unitDisp = null)
    {
        // validation for constraint: string
        if (!is_null($unitDisp) && !is_string($unitDisp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitDisp, true), gettype($unitDisp)), __LINE__);
        }
        $this->unitDisp = $unitDisp;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\InvoiceItemCost
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get itemCostCount value
     * @return string|null
     */
    public function getItemCostCount()
    {
        return $this->itemCostCount;
    }
    /**
     * Set itemCostCount value
     * @param string $itemCostCount
     * @return \StructType\InvoiceItemCost
     */
    public function setItemCostCount($itemCostCount = null)
    {
        // validation for constraint: string
        if (!is_null($itemCostCount) && !is_string($itemCostCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCostCount, true), gettype($itemCostCount)), __LINE__);
        }
        $this->itemCostCount = $itemCostCount;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\InvoiceItemCost
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\InvoiceItemCost
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\InvoiceItemCost
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\InvoiceItemCost
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\InvoiceItemCost
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\InvoiceItemCost
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get revRecStartDate value
     * @return string|null
     */
    public function getRevRecStartDate()
    {
        return $this->revRecStartDate;
    }
    /**
     * Set revRecStartDate value
     * @param string $revRecStartDate
     * @return \StructType\InvoiceItemCost
     */
    public function setRevRecStartDate($revRecStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecStartDate) && !is_string($revRecStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecStartDate, true), gettype($revRecStartDate)), __LINE__);
        }
        $this->revRecStartDate = $revRecStartDate;
        return $this;
    }
    /**
     * Get revRecEndDate value
     * @return string|null
     */
    public function getRevRecEndDate()
    {
        return $this->revRecEndDate;
    }
    /**
     * Set revRecEndDate value
     * @param string $revRecEndDate
     * @return \StructType\InvoiceItemCost
     */
    public function setRevRecEndDate($revRecEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecEndDate) && !is_string($revRecEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecEndDate, true), gettype($revRecEndDate)), __LINE__);
        }
        $this->revRecEndDate = $revRecEndDate;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\InvoiceItemCost
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\InvoiceItemCost
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\InvoiceItemCost
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\InvoiceItemCost
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\InvoiceItemCost
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
}
