<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryTransferInventory StructType
 * @subpackage Structs
 */
class InventoryTransferInventory extends AbstractStructBase
{
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The adjustQtyBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $adjustQtyBy;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The fromBinNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromBinNumbers;
    /**
     * The toBinNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toBinNumbers;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for InventoryTransferInventory
     * @uses InventoryTransferInventory::setLine()
     * @uses InventoryTransferInventory::setItem()
     * @uses InventoryTransferInventory::setDescription()
     * @uses InventoryTransferInventory::setUnits()
     * @uses InventoryTransferInventory::setQuantityOnHand()
     * @uses InventoryTransferInventory::setAdjustQtyBy()
     * @uses InventoryTransferInventory::setSerialNumbers()
     * @uses InventoryTransferInventory::setFromBinNumbers()
     * @uses InventoryTransferInventory::setToBinNumbers()
     * @uses InventoryTransferInventory::setInventoryDetail()
     * @uses InventoryTransferInventory::setCustomFieldList()
     * @param int $line
     * @param \StructType\RecordRef $item
     * @param string $description
     * @param \StructType\RecordRef $units
     * @param float $quantityOnHand
     * @param float $adjustQtyBy
     * @param string $serialNumbers
     * @param string $fromBinNumbers
     * @param string $toBinNumbers
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($line = null, \StructType\RecordRef $item = null, $description = null, \StructType\RecordRef $units = null, $quantityOnHand = null, $adjustQtyBy = null, $serialNumbers = null, $fromBinNumbers = null, $toBinNumbers = null, \StructType\InventoryDetail $inventoryDetail = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setLine($line)
            ->setItem($item)
            ->setDescription($description)
            ->setUnits($units)
            ->setQuantityOnHand($quantityOnHand)
            ->setAdjustQtyBy($adjustQtyBy)
            ->setSerialNumbers($serialNumbers)
            ->setFromBinNumbers($fromBinNumbers)
            ->setToBinNumbers($toBinNumbers)
            ->setInventoryDetail($inventoryDetail)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\InventoryTransferInventory
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\InventoryTransferInventory
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\InventoryTransferInventory
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\InventoryTransferInventory
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\InventoryTransferInventory
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get adjustQtyBy value
     * @return float|null
     */
    public function getAdjustQtyBy()
    {
        return $this->adjustQtyBy;
    }
    /**
     * Set adjustQtyBy value
     * @param float $adjustQtyBy
     * @return \StructType\InventoryTransferInventory
     */
    public function setAdjustQtyBy($adjustQtyBy = null)
    {
        // validation for constraint: float
        if (!is_null($adjustQtyBy) && !(is_float($adjustQtyBy) || is_numeric($adjustQtyBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adjustQtyBy, true), gettype($adjustQtyBy)), __LINE__);
        }
        $this->adjustQtyBy = $adjustQtyBy;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\InventoryTransferInventory
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get fromBinNumbers value
     * @return string|null
     */
    public function getFromBinNumbers()
    {
        return $this->fromBinNumbers;
    }
    /**
     * Set fromBinNumbers value
     * @param string $fromBinNumbers
     * @return \StructType\InventoryTransferInventory
     */
    public function setFromBinNumbers($fromBinNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($fromBinNumbers) && !is_string($fromBinNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromBinNumbers, true), gettype($fromBinNumbers)), __LINE__);
        }
        $this->fromBinNumbers = $fromBinNumbers;
        return $this;
    }
    /**
     * Get toBinNumbers value
     * @return string|null
     */
    public function getToBinNumbers()
    {
        return $this->toBinNumbers;
    }
    /**
     * Set toBinNumbers value
     * @param string $toBinNumbers
     * @return \StructType\InventoryTransferInventory
     */
    public function setToBinNumbers($toBinNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($toBinNumbers) && !is_string($toBinNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toBinNumbers, true), gettype($toBinNumbers)), __LINE__);
        }
        $this->toBinNumbers = $toBinNumbers;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\InventoryTransferInventory
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\InventoryTransferInventory
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
