<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryNumberBinSearchRowBasic StructType
 * @subpackage Structs
 */
class InventoryNumberBinSearchRowBasic extends SearchRowBasic
{
    /**
     * The binNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $binNumber;
    /**
     * The inventoryNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $inventoryNumber;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $location;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityAvailable;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityOnHand;
    /**
     * Constructor method for InventoryNumberBinSearchRowBasic
     * @uses InventoryNumberBinSearchRowBasic::setBinNumber()
     * @uses InventoryNumberBinSearchRowBasic::setInventoryNumber()
     * @uses InventoryNumberBinSearchRowBasic::setLocation()
     * @uses InventoryNumberBinSearchRowBasic::setQuantityAvailable()
     * @uses InventoryNumberBinSearchRowBasic::setQuantityOnHand()
     * @param \StructType\SearchColumnSelectField[] $binNumber
     * @param \StructType\SearchColumnSelectField[] $inventoryNumber
     * @param \StructType\SearchColumnSelectField[] $location
     * @param \StructType\SearchColumnDoubleField[] $quantityAvailable
     * @param \StructType\SearchColumnDoubleField[] $quantityOnHand
     */
    public function __construct(array $binNumber = array(), array $inventoryNumber = array(), array $location = array(), array $quantityAvailable = array(), array $quantityOnHand = array())
    {
        $this
            ->setBinNumber($binNumber)
            ->setInventoryNumber($inventoryNumber)
            ->setLocation($location)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityOnHand($quantityOnHand);
    }
    /**
     * Get binNumber value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getBinNumber()
    {
        return $this->binNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setBinNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBinNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBinNumberForArrayConstraintsFromSetBinNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryNumberBinSearchRowBasicBinNumberItem) {
            // validation for constraint: itemType
            if (!$inventoryNumberBinSearchRowBasicBinNumberItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inventoryNumberBinSearchRowBasicBinNumberItem) ? get_class($inventoryNumberBinSearchRowBasicBinNumberItem) : sprintf('%s(%s)', gettype($inventoryNumberBinSearchRowBasicBinNumberItem), var_export($inventoryNumberBinSearchRowBasicBinNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The binNumber property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set binNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $binNumber
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function setBinNumber(array $binNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($binNumberArrayErrorMessage = self::validateBinNumberForArrayConstraintsFromSetBinNumber($binNumber))) {
            throw new \InvalidArgumentException($binNumberArrayErrorMessage, __LINE__);
        }
        $this->binNumber = $binNumber;
        return $this;
    }
    /**
     * Add item to binNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function addToBinNumber(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The binNumber property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->binNumber[] = $item;
        return $this;
    }
    /**
     * Get inventoryNumber value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInventoryNumber()
    {
        return $this->inventoryNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setInventoryNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryNumberForArrayConstraintsFromSetInventoryNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryNumberBinSearchRowBasicInventoryNumberItem) {
            // validation for constraint: itemType
            if (!$inventoryNumberBinSearchRowBasicInventoryNumberItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inventoryNumberBinSearchRowBasicInventoryNumberItem) ? get_class($inventoryNumberBinSearchRowBasicInventoryNumberItem) : sprintf('%s(%s)', gettype($inventoryNumberBinSearchRowBasicInventoryNumberItem), var_export($inventoryNumberBinSearchRowBasicInventoryNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inventoryNumber property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inventoryNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $inventoryNumber
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function setInventoryNumber(array $inventoryNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryNumberArrayErrorMessage = self::validateInventoryNumberForArrayConstraintsFromSetInventoryNumber($inventoryNumber))) {
            throw new \InvalidArgumentException($inventoryNumberArrayErrorMessage, __LINE__);
        }
        $this->inventoryNumber = $inventoryNumber;
        return $this;
    }
    /**
     * Add item to inventoryNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function addToInventoryNumber(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The inventoryNumber property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inventoryNumber[] = $item;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryNumberBinSearchRowBasicLocationItem) {
            // validation for constraint: itemType
            if (!$inventoryNumberBinSearchRowBasicLocationItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inventoryNumberBinSearchRowBasicLocationItem) ? get_class($inventoryNumberBinSearchRowBasicLocationItem) : sprintf('%s(%s)', gettype($inventoryNumberBinSearchRowBasicLocationItem), var_export($inventoryNumberBinSearchRowBasicLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $location
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Add item to location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function addToLocation(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->location[] = $item;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityAvailable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityAvailable method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityAvailableForArrayConstraintsFromSetQuantityAvailable(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryNumberBinSearchRowBasicQuantityAvailableItem) {
            // validation for constraint: itemType
            if (!$inventoryNumberBinSearchRowBasicQuantityAvailableItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inventoryNumberBinSearchRowBasicQuantityAvailableItem) ? get_class($inventoryNumberBinSearchRowBasicQuantityAvailableItem) : sprintf('%s(%s)', gettype($inventoryNumberBinSearchRowBasicQuantityAvailableItem), var_export($inventoryNumberBinSearchRowBasicQuantityAvailableItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityAvailable property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityAvailable value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityAvailable
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function setQuantityAvailable(array $quantityAvailable = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityAvailableArrayErrorMessage = self::validateQuantityAvailableForArrayConstraintsFromSetQuantityAvailable($quantityAvailable))) {
            throw new \InvalidArgumentException($quantityAvailableArrayErrorMessage, __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Add item to quantityAvailable value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function addToQuantityAvailable(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityAvailable property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityAvailable[] = $item;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityOnHand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityOnHand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityOnHandForArrayConstraintsFromSetQuantityOnHand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryNumberBinSearchRowBasicQuantityOnHandItem) {
            // validation for constraint: itemType
            if (!$inventoryNumberBinSearchRowBasicQuantityOnHandItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inventoryNumberBinSearchRowBasicQuantityOnHandItem) ? get_class($inventoryNumberBinSearchRowBasicQuantityOnHandItem) : sprintf('%s(%s)', gettype($inventoryNumberBinSearchRowBasicQuantityOnHandItem), var_export($inventoryNumberBinSearchRowBasicQuantityOnHandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityOnHand property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityOnHand value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityOnHand
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function setQuantityOnHand(array $quantityOnHand = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityOnHandArrayErrorMessage = self::validateQuantityOnHandForArrayConstraintsFromSetQuantityOnHand($quantityOnHand))) {
            throw new \InvalidArgumentException($quantityOnHandArrayErrorMessage, __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Add item to quantityOnHand value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InventoryNumberBinSearchRowBasic
     */
    public function addToQuantityOnHand(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityOnHand property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityOnHand[] = $item;
        return $this;
    }
}
