<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryItemLocationsList StructType
 * @subpackage Structs
 */
class InventoryItemLocationsList extends AbstractStructBase
{
    /**
     * The locations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InventoryItemLocations[]
     */
    public $locations;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for InventoryItemLocationsList
     * @uses InventoryItemLocationsList::setLocations()
     * @uses InventoryItemLocationsList::setReplaceAll()
     * @param \StructType\InventoryItemLocations[] $locations
     * @param bool $replaceAll
     */
    public function __construct(array $locations = array(), $replaceAll = true)
    {
        $this
            ->setLocations($locations)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get locations value
     * @return \StructType\InventoryItemLocations[]|null
     */
    public function getLocations()
    {
        return $this->locations;
    }
    /**
     * This method is responsible for validating the values passed to the setLocations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationsForArrayConstraintsFromSetLocations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryItemLocationsListLocationsItem) {
            // validation for constraint: itemType
            if (!$inventoryItemLocationsListLocationsItem instanceof \StructType\InventoryItemLocations) {
                $invalidValues[] = is_object($inventoryItemLocationsListLocationsItem) ? get_class($inventoryItemLocationsListLocationsItem) : sprintf('%s(%s)', gettype($inventoryItemLocationsListLocationsItem), var_export($inventoryItemLocationsListLocationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The locations property can only contain items of type \StructType\InventoryItemLocations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set locations value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemLocations[] $locations
     * @return \StructType\InventoryItemLocationsList
     */
    public function setLocations(array $locations = array())
    {
        // validation for constraint: array
        if ('' !== ($locationsArrayErrorMessage = self::validateLocationsForArrayConstraintsFromSetLocations($locations))) {
            throw new \InvalidArgumentException($locationsArrayErrorMessage, __LINE__);
        }
        $this->locations = $locations;
        return $this;
    }
    /**
     * Add item to locations value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemLocations $item
     * @return \StructType\InventoryItemLocationsList
     */
    public function addToLocations(\StructType\InventoryItemLocations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventoryItemLocations) {
            throw new \InvalidArgumentException(sprintf('The locations property can only contain items of type \StructType\InventoryItemLocations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->locations[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\InventoryItemLocationsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
