<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryItemHierarchyVersionsList StructType
 * @subpackage Structs
 */
class InventoryItemHierarchyVersionsList extends AbstractStructBase
{
    /**
     * The inventoryItemHierarchyVersions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InventoryItemHierarchyVersions[]
     */
    public $inventoryItemHierarchyVersions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for InventoryItemHierarchyVersionsList
     * @uses InventoryItemHierarchyVersionsList::setInventoryItemHierarchyVersions()
     * @uses InventoryItemHierarchyVersionsList::setReplaceAll()
     * @param \StructType\InventoryItemHierarchyVersions[] $inventoryItemHierarchyVersions
     * @param bool $replaceAll
     */
    public function __construct(array $inventoryItemHierarchyVersions = array(), $replaceAll = true)
    {
        $this
            ->setInventoryItemHierarchyVersions($inventoryItemHierarchyVersions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get inventoryItemHierarchyVersions value
     * @return \StructType\InventoryItemHierarchyVersions[]|null
     */
    public function getInventoryItemHierarchyVersions()
    {
        return $this->inventoryItemHierarchyVersions;
    }
    /**
     * This method is responsible for validating the values passed to the setInventoryItemHierarchyVersions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryItemHierarchyVersions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryItemHierarchyVersionsForArrayConstraintsFromSetInventoryItemHierarchyVersions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryItemHierarchyVersionsListInventoryItemHierarchyVersionsItem) {
            // validation for constraint: itemType
            if (!$inventoryItemHierarchyVersionsListInventoryItemHierarchyVersionsItem instanceof \StructType\InventoryItemHierarchyVersions) {
                $invalidValues[] = is_object($inventoryItemHierarchyVersionsListInventoryItemHierarchyVersionsItem) ? get_class($inventoryItemHierarchyVersionsListInventoryItemHierarchyVersionsItem) : sprintf('%s(%s)', gettype($inventoryItemHierarchyVersionsListInventoryItemHierarchyVersionsItem), var_export($inventoryItemHierarchyVersionsListInventoryItemHierarchyVersionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inventoryItemHierarchyVersions property can only contain items of type \StructType\InventoryItemHierarchyVersions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inventoryItemHierarchyVersions value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemHierarchyVersions[] $inventoryItemHierarchyVersions
     * @return \StructType\InventoryItemHierarchyVersionsList
     */
    public function setInventoryItemHierarchyVersions(array $inventoryItemHierarchyVersions = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryItemHierarchyVersionsArrayErrorMessage = self::validateInventoryItemHierarchyVersionsForArrayConstraintsFromSetInventoryItemHierarchyVersions($inventoryItemHierarchyVersions))) {
            throw new \InvalidArgumentException($inventoryItemHierarchyVersionsArrayErrorMessage, __LINE__);
        }
        $this->inventoryItemHierarchyVersions = $inventoryItemHierarchyVersions;
        return $this;
    }
    /**
     * Add item to inventoryItemHierarchyVersions value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemHierarchyVersions $item
     * @return \StructType\InventoryItemHierarchyVersionsList
     */
    public function addToInventoryItemHierarchyVersions(\StructType\InventoryItemHierarchyVersions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventoryItemHierarchyVersions) {
            throw new \InvalidArgumentException(sprintf('The inventoryItemHierarchyVersions property can only contain items of type \StructType\InventoryItemHierarchyVersions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inventoryItemHierarchyVersions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\InventoryItemHierarchyVersionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
