<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryAssignmentList StructType
 * @subpackage Structs
 */
class InventoryAssignmentList extends AbstractStructBase
{
    /**
     * The inventoryAssignment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InventoryAssignment[]
     */
    public $inventoryAssignment;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for InventoryAssignmentList
     * @uses InventoryAssignmentList::setInventoryAssignment()
     * @uses InventoryAssignmentList::setReplaceAll()
     * @param \StructType\InventoryAssignment[] $inventoryAssignment
     * @param bool $replaceAll
     */
    public function __construct(array $inventoryAssignment = array(), $replaceAll = false)
    {
        $this
            ->setInventoryAssignment($inventoryAssignment)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get inventoryAssignment value
     * @return \StructType\InventoryAssignment[]|null
     */
    public function getInventoryAssignment()
    {
        return $this->inventoryAssignment;
    }
    /**
     * This method is responsible for validating the values passed to the setInventoryAssignment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryAssignment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryAssignmentForArrayConstraintsFromSetInventoryAssignment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryAssignmentListInventoryAssignmentItem) {
            // validation for constraint: itemType
            if (!$inventoryAssignmentListInventoryAssignmentItem instanceof \StructType\InventoryAssignment) {
                $invalidValues[] = is_object($inventoryAssignmentListInventoryAssignmentItem) ? get_class($inventoryAssignmentListInventoryAssignmentItem) : sprintf('%s(%s)', gettype($inventoryAssignmentListInventoryAssignmentItem), var_export($inventoryAssignmentListInventoryAssignmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inventoryAssignment property can only contain items of type \StructType\InventoryAssignment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inventoryAssignment value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryAssignment[] $inventoryAssignment
     * @return \StructType\InventoryAssignmentList
     */
    public function setInventoryAssignment(array $inventoryAssignment = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryAssignmentArrayErrorMessage = self::validateInventoryAssignmentForArrayConstraintsFromSetInventoryAssignment($inventoryAssignment))) {
            throw new \InvalidArgumentException($inventoryAssignmentArrayErrorMessage, __LINE__);
        }
        $this->inventoryAssignment = $inventoryAssignment;
        return $this;
    }
    /**
     * Add item to inventoryAssignment value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryAssignment $item
     * @return \StructType\InventoryAssignmentList
     */
    public function addToInventoryAssignment(\StructType\InventoryAssignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventoryAssignment) {
            throw new \InvalidArgumentException(sprintf('The inventoryAssignment property can only contain items of type \StructType\InventoryAssignment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inventoryAssignment[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\InventoryAssignmentList
     */
    public function setReplaceAll($replaceAll = false)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
