<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterCompanyJournalEntryLine StructType
 * @subpackage Structs
 */
class InterCompanyJournalEntryLine extends AbstractStructBase
{
    /**
     * The lineSubsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $lineSubsidiary;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The debit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $debit;
    /**
     * The credit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $credit;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The schedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $schedule;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The revenueRecognitionRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueRecognitionRule;
    /**
     * The eliminate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $eliminate;
    /**
     * The residual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $residual;
    /**
     * The amortizationSched
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $amortizationSched;
    /**
     * The scheduleNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $scheduleNum;
    /**
     * The amortizStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizStartDate;
    /**
     * The amortizationEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationEndDate;
    /**
     * The amortizationResidual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationResidual;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The tax1Acct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $tax1Acct;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for InterCompanyJournalEntryLine
     * @uses InterCompanyJournalEntryLine::setLineSubsidiary()
     * @uses InterCompanyJournalEntryLine::setAccount()
     * @uses InterCompanyJournalEntryLine::setLine()
     * @uses InterCompanyJournalEntryLine::setDebit()
     * @uses InterCompanyJournalEntryLine::setCredit()
     * @uses InterCompanyJournalEntryLine::setTaxCode()
     * @uses InterCompanyJournalEntryLine::setMemo()
     * @uses InterCompanyJournalEntryLine::setTaxRate1()
     * @uses InterCompanyJournalEntryLine::setEntity()
     * @uses InterCompanyJournalEntryLine::setGrossAmt()
     * @uses InterCompanyJournalEntryLine::setSchedule()
     * @uses InterCompanyJournalEntryLine::setDepartment()
     * @uses InterCompanyJournalEntryLine::setStartDate()
     * @uses InterCompanyJournalEntryLine::setClass()
     * @uses InterCompanyJournalEntryLine::setEndDate()
     * @uses InterCompanyJournalEntryLine::setLocation()
     * @uses InterCompanyJournalEntryLine::setRevenueRecognitionRule()
     * @uses InterCompanyJournalEntryLine::setEliminate()
     * @uses InterCompanyJournalEntryLine::setResidual()
     * @uses InterCompanyJournalEntryLine::setAmortizationSched()
     * @uses InterCompanyJournalEntryLine::setScheduleNum()
     * @uses InterCompanyJournalEntryLine::setAmortizStartDate()
     * @uses InterCompanyJournalEntryLine::setAmortizationEndDate()
     * @uses InterCompanyJournalEntryLine::setAmortizationResidual()
     * @uses InterCompanyJournalEntryLine::setTax1Amt()
     * @uses InterCompanyJournalEntryLine::setTax1Acct()
     * @uses InterCompanyJournalEntryLine::setCustomFieldList()
     * @param \StructType\RecordRef $lineSubsidiary
     * @param \StructType\RecordRef $account
     * @param int $line
     * @param float $debit
     * @param float $credit
     * @param \StructType\RecordRef $taxCode
     * @param string $memo
     * @param float $taxRate1
     * @param \StructType\RecordRef $entity
     * @param float $grossAmt
     * @param \StructType\RecordRef $schedule
     * @param \StructType\RecordRef $department
     * @param string $startDate
     * @param \StructType\RecordRef $class
     * @param string $endDate
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @param bool $eliminate
     * @param string $residual
     * @param \StructType\RecordRef $amortizationSched
     * @param \StructType\RecordRef $scheduleNum
     * @param string $amortizStartDate
     * @param string $amortizationEndDate
     * @param string $amortizationResidual
     * @param float $tax1Amt
     * @param \StructType\RecordRef $tax1Acct
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $lineSubsidiary = null, \StructType\RecordRef $account = null, $line = null, $debit = null, $credit = null, \StructType\RecordRef $taxCode = null, $memo = null, $taxRate1 = null, \StructType\RecordRef $entity = null, $grossAmt = null, \StructType\RecordRef $schedule = null, \StructType\RecordRef $department = null, $startDate = null, \StructType\RecordRef $class = null, $endDate = null, \StructType\RecordRef $location = null, \StructType\RecordRef $revenueRecognitionRule = null, $eliminate = null, $residual = null, \StructType\RecordRef $amortizationSched = null, \StructType\RecordRef $scheduleNum = null, $amortizStartDate = null, $amortizationEndDate = null, $amortizationResidual = null, $tax1Amt = null, \StructType\RecordRef $tax1Acct = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setLineSubsidiary($lineSubsidiary)
            ->setAccount($account)
            ->setLine($line)
            ->setDebit($debit)
            ->setCredit($credit)
            ->setTaxCode($taxCode)
            ->setMemo($memo)
            ->setTaxRate1($taxRate1)
            ->setEntity($entity)
            ->setGrossAmt($grossAmt)
            ->setSchedule($schedule)
            ->setDepartment($department)
            ->setStartDate($startDate)
            ->setClass($class)
            ->setEndDate($endDate)
            ->setLocation($location)
            ->setRevenueRecognitionRule($revenueRecognitionRule)
            ->setEliminate($eliminate)
            ->setResidual($residual)
            ->setAmortizationSched($amortizationSched)
            ->setScheduleNum($scheduleNum)
            ->setAmortizStartDate($amortizStartDate)
            ->setAmortizationEndDate($amortizationEndDate)
            ->setAmortizationResidual($amortizationResidual)
            ->setTax1Amt($tax1Amt)
            ->setTax1Acct($tax1Acct)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get lineSubsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getLineSubsidiary()
    {
        return $this->lineSubsidiary;
    }
    /**
     * Set lineSubsidiary value
     * @param \StructType\RecordRef $lineSubsidiary
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setLineSubsidiary(\StructType\RecordRef $lineSubsidiary = null)
    {
        $this->lineSubsidiary = $lineSubsidiary;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get debit value
     * @return float|null
     */
    public function getDebit()
    {
        return $this->debit;
    }
    /**
     * Set debit value
     * @param float $debit
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setDebit($debit = null)
    {
        // validation for constraint: float
        if (!is_null($debit) && !(is_float($debit) || is_numeric($debit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debit, true), gettype($debit)), __LINE__);
        }
        $this->debit = $debit;
        return $this;
    }
    /**
     * Get credit value
     * @return float|null
     */
    public function getCredit()
    {
        return $this->credit;
    }
    /**
     * Set credit value
     * @param float $credit
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setCredit($credit = null)
    {
        // validation for constraint: float
        if (!is_null($credit) && !(is_float($credit) || is_numeric($credit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credit, true), gettype($credit)), __LINE__);
        }
        $this->credit = $credit;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get schedule value
     * @return \StructType\RecordRef|null
     */
    public function getSchedule()
    {
        return $this->schedule;
    }
    /**
     * Set schedule value
     * @param \StructType\RecordRef $schedule
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setSchedule(\StructType\RecordRef $schedule = null)
    {
        $this->schedule = $schedule;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get revenueRecognitionRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueRecognitionRule()
    {
        return $this->revenueRecognitionRule;
    }
    /**
     * Set revenueRecognitionRule value
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setRevenueRecognitionRule(\StructType\RecordRef $revenueRecognitionRule = null)
    {
        $this->revenueRecognitionRule = $revenueRecognitionRule;
        return $this;
    }
    /**
     * Get eliminate value
     * @return bool|null
     */
    public function getEliminate()
    {
        return $this->eliminate;
    }
    /**
     * Set eliminate value
     * @param bool $eliminate
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setEliminate($eliminate = null)
    {
        // validation for constraint: boolean
        if (!is_null($eliminate) && !is_bool($eliminate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eliminate, true), gettype($eliminate)), __LINE__);
        }
        $this->eliminate = $eliminate;
        return $this;
    }
    /**
     * Get residual value
     * @return string|null
     */
    public function getResidual()
    {
        return $this->residual;
    }
    /**
     * Set residual value
     * @param string $residual
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setResidual($residual = null)
    {
        // validation for constraint: string
        if (!is_null($residual) && !is_string($residual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residual, true), gettype($residual)), __LINE__);
        }
        $this->residual = $residual;
        return $this;
    }
    /**
     * Get amortizationSched value
     * @return \StructType\RecordRef|null
     */
    public function getAmortizationSched()
    {
        return $this->amortizationSched;
    }
    /**
     * Set amortizationSched value
     * @param \StructType\RecordRef $amortizationSched
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setAmortizationSched(\StructType\RecordRef $amortizationSched = null)
    {
        $this->amortizationSched = $amortizationSched;
        return $this;
    }
    /**
     * Get scheduleNum value
     * @return \StructType\RecordRef|null
     */
    public function getScheduleNum()
    {
        return $this->scheduleNum;
    }
    /**
     * Set scheduleNum value
     * @param \StructType\RecordRef $scheduleNum
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setScheduleNum(\StructType\RecordRef $scheduleNum = null)
    {
        $this->scheduleNum = $scheduleNum;
        return $this;
    }
    /**
     * Get amortizStartDate value
     * @return string|null
     */
    public function getAmortizStartDate()
    {
        return $this->amortizStartDate;
    }
    /**
     * Set amortizStartDate value
     * @param string $amortizStartDate
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setAmortizStartDate($amortizStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizStartDate) && !is_string($amortizStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizStartDate, true), gettype($amortizStartDate)), __LINE__);
        }
        $this->amortizStartDate = $amortizStartDate;
        return $this;
    }
    /**
     * Get amortizationEndDate value
     * @return string|null
     */
    public function getAmortizationEndDate()
    {
        return $this->amortizationEndDate;
    }
    /**
     * Set amortizationEndDate value
     * @param string $amortizationEndDate
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setAmortizationEndDate($amortizationEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationEndDate) && !is_string($amortizationEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationEndDate, true), gettype($amortizationEndDate)), __LINE__);
        }
        $this->amortizationEndDate = $amortizationEndDate;
        return $this;
    }
    /**
     * Get amortizationResidual value
     * @return string|null
     */
    public function getAmortizationResidual()
    {
        return $this->amortizationResidual;
    }
    /**
     * Set amortizationResidual value
     * @param string $amortizationResidual
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setAmortizationResidual($amortizationResidual = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationResidual) && !is_string($amortizationResidual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationResidual, true), gettype($amortizationResidual)), __LINE__);
        }
        $this->amortizationResidual = $amortizationResidual;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get tax1Acct value
     * @return \StructType\RecordRef|null
     */
    public function getTax1Acct()
    {
        return $this->tax1Acct;
    }
    /**
     * Set tax1Acct value
     * @param \StructType\RecordRef $tax1Acct
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setTax1Acct(\StructType\RecordRef $tax1Acct = null)
    {
        $this->tax1Acct = $tax1Acct;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\InterCompanyJournalEntryLine
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
