<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstallmentSearchRowBasic StructType
 * @subpackage Structs
 */
class InstallmentSearchRowBasic extends SearchRowBasic
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $amount;
    /**
     * The amountPaid
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $amountPaid;
    /**
     * The amountRemaining
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $amountRemaining;
    /**
     * The daysOverdue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $daysOverdue;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $dueDate;
    /**
     * The fxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $fxAmount;
    /**
     * The fxAmountPaid
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $fxAmountPaid;
    /**
     * The fxAmountRemaining
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $fxAmountRemaining;
    /**
     * The installmentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $installmentNumber;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $status;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for InstallmentSearchRowBasic
     * @uses InstallmentSearchRowBasic::setAmount()
     * @uses InstallmentSearchRowBasic::setAmountPaid()
     * @uses InstallmentSearchRowBasic::setAmountRemaining()
     * @uses InstallmentSearchRowBasic::setDaysOverdue()
     * @uses InstallmentSearchRowBasic::setDueDate()
     * @uses InstallmentSearchRowBasic::setFxAmount()
     * @uses InstallmentSearchRowBasic::setFxAmountPaid()
     * @uses InstallmentSearchRowBasic::setFxAmountRemaining()
     * @uses InstallmentSearchRowBasic::setInstallmentNumber()
     * @uses InstallmentSearchRowBasic::setStatus()
     * @uses InstallmentSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @param \StructType\SearchColumnDoubleField[] $amountPaid
     * @param \StructType\SearchColumnDoubleField[] $amountRemaining
     * @param \StructType\SearchColumnLongField[] $daysOverdue
     * @param \StructType\SearchColumnDateField[] $dueDate
     * @param \StructType\SearchColumnDoubleField[] $fxAmount
     * @param \StructType\SearchColumnDoubleField[] $fxAmountPaid
     * @param \StructType\SearchColumnDoubleField[] $fxAmountRemaining
     * @param \StructType\SearchColumnLongField[] $installmentNumber
     * @param \StructType\SearchColumnStringField[] $status
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $amount = array(), array $amountPaid = array(), array $amountRemaining = array(), array $daysOverdue = array(), array $dueDate = array(), array $fxAmount = array(), array $fxAmountPaid = array(), array $fxAmountRemaining = array(), array $installmentNumber = array(), array $status = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAmount($amount)
            ->setAmountPaid($amountPaid)
            ->setAmountRemaining($amountRemaining)
            ->setDaysOverdue($daysOverdue)
            ->setDueDate($dueDate)
            ->setFxAmount($fxAmount)
            ->setFxAmountPaid($fxAmountPaid)
            ->setFxAmountRemaining($fxAmountRemaining)
            ->setInstallmentNumber($installmentNumber)
            ->setStatus($status)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get amount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * This method is responsible for validating the values passed to the setAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmountForArrayConstraintsFromSetAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicAmountItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($installmentSearchRowBasicAmountItem) ? get_class($installmentSearchRowBasicAmountItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicAmountItem), var_export($installmentSearchRowBasicAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setAmount(array $amount = array())
    {
        // validation for constraint: array
        if ('' !== ($amountArrayErrorMessage = self::validateAmountForArrayConstraintsFromSetAmount($amount))) {
            throw new \InvalidArgumentException($amountArrayErrorMessage, __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Add item to amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amount[] = $item;
        return $this;
    }
    /**
     * Get amountPaid value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAmountPaid()
    {
        return $this->amountPaid;
    }
    /**
     * This method is responsible for validating the values passed to the setAmountPaid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmountPaid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmountPaidForArrayConstraintsFromSetAmountPaid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicAmountPaidItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicAmountPaidItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($installmentSearchRowBasicAmountPaidItem) ? get_class($installmentSearchRowBasicAmountPaidItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicAmountPaidItem), var_export($installmentSearchRowBasicAmountPaidItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amountPaid property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amountPaid value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $amountPaid
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setAmountPaid(array $amountPaid = array())
    {
        // validation for constraint: array
        if ('' !== ($amountPaidArrayErrorMessage = self::validateAmountPaidForArrayConstraintsFromSetAmountPaid($amountPaid))) {
            throw new \InvalidArgumentException($amountPaidArrayErrorMessage, __LINE__);
        }
        $this->amountPaid = $amountPaid;
        return $this;
    }
    /**
     * Add item to amountPaid value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToAmountPaid(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The amountPaid property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amountPaid[] = $item;
        return $this;
    }
    /**
     * Get amountRemaining value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAmountRemaining()
    {
        return $this->amountRemaining;
    }
    /**
     * This method is responsible for validating the values passed to the setAmountRemaining method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmountRemaining method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmountRemainingForArrayConstraintsFromSetAmountRemaining(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicAmountRemainingItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicAmountRemainingItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($installmentSearchRowBasicAmountRemainingItem) ? get_class($installmentSearchRowBasicAmountRemainingItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicAmountRemainingItem), var_export($installmentSearchRowBasicAmountRemainingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amountRemaining property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amountRemaining value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $amountRemaining
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setAmountRemaining(array $amountRemaining = array())
    {
        // validation for constraint: array
        if ('' !== ($amountRemainingArrayErrorMessage = self::validateAmountRemainingForArrayConstraintsFromSetAmountRemaining($amountRemaining))) {
            throw new \InvalidArgumentException($amountRemainingArrayErrorMessage, __LINE__);
        }
        $this->amountRemaining = $amountRemaining;
        return $this;
    }
    /**
     * Add item to amountRemaining value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToAmountRemaining(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The amountRemaining property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amountRemaining[] = $item;
        return $this;
    }
    /**
     * Get daysOverdue value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getDaysOverdue()
    {
        return $this->daysOverdue;
    }
    /**
     * This method is responsible for validating the values passed to the setDaysOverdue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDaysOverdue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDaysOverdueForArrayConstraintsFromSetDaysOverdue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicDaysOverdueItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicDaysOverdueItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($installmentSearchRowBasicDaysOverdueItem) ? get_class($installmentSearchRowBasicDaysOverdueItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicDaysOverdueItem), var_export($installmentSearchRowBasicDaysOverdueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The daysOverdue property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set daysOverdue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $daysOverdue
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setDaysOverdue(array $daysOverdue = array())
    {
        // validation for constraint: array
        if ('' !== ($daysOverdueArrayErrorMessage = self::validateDaysOverdueForArrayConstraintsFromSetDaysOverdue($daysOverdue))) {
            throw new \InvalidArgumentException($daysOverdueArrayErrorMessage, __LINE__);
        }
        $this->daysOverdue = $daysOverdue;
        return $this;
    }
    /**
     * Add item to daysOverdue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToDaysOverdue(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The daysOverdue property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->daysOverdue[] = $item;
        return $this;
    }
    /**
     * Get dueDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * This method is responsible for validating the values passed to the setDueDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDueDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDueDateForArrayConstraintsFromSetDueDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicDueDateItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicDueDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($installmentSearchRowBasicDueDateItem) ? get_class($installmentSearchRowBasicDueDateItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicDueDateItem), var_export($installmentSearchRowBasicDueDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dueDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dueDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $dueDate
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setDueDate(array $dueDate = array())
    {
        // validation for constraint: array
        if ('' !== ($dueDateArrayErrorMessage = self::validateDueDateForArrayConstraintsFromSetDueDate($dueDate))) {
            throw new \InvalidArgumentException($dueDateArrayErrorMessage, __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Add item to dueDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToDueDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The dueDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dueDate[] = $item;
        return $this;
    }
    /**
     * Get fxAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getFxAmount()
    {
        return $this->fxAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setFxAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFxAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFxAmountForArrayConstraintsFromSetFxAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicFxAmountItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicFxAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($installmentSearchRowBasicFxAmountItem) ? get_class($installmentSearchRowBasicFxAmountItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicFxAmountItem), var_export($installmentSearchRowBasicFxAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fxAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $fxAmount
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setFxAmount(array $fxAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($fxAmountArrayErrorMessage = self::validateFxAmountForArrayConstraintsFromSetFxAmount($fxAmount))) {
            throw new \InvalidArgumentException($fxAmountArrayErrorMessage, __LINE__);
        }
        $this->fxAmount = $fxAmount;
        return $this;
    }
    /**
     * Add item to fxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToFxAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The fxAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fxAmount[] = $item;
        return $this;
    }
    /**
     * Get fxAmountPaid value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getFxAmountPaid()
    {
        return $this->fxAmountPaid;
    }
    /**
     * This method is responsible for validating the values passed to the setFxAmountPaid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFxAmountPaid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFxAmountPaidForArrayConstraintsFromSetFxAmountPaid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicFxAmountPaidItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicFxAmountPaidItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($installmentSearchRowBasicFxAmountPaidItem) ? get_class($installmentSearchRowBasicFxAmountPaidItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicFxAmountPaidItem), var_export($installmentSearchRowBasicFxAmountPaidItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fxAmountPaid property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fxAmountPaid value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $fxAmountPaid
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setFxAmountPaid(array $fxAmountPaid = array())
    {
        // validation for constraint: array
        if ('' !== ($fxAmountPaidArrayErrorMessage = self::validateFxAmountPaidForArrayConstraintsFromSetFxAmountPaid($fxAmountPaid))) {
            throw new \InvalidArgumentException($fxAmountPaidArrayErrorMessage, __LINE__);
        }
        $this->fxAmountPaid = $fxAmountPaid;
        return $this;
    }
    /**
     * Add item to fxAmountPaid value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToFxAmountPaid(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The fxAmountPaid property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fxAmountPaid[] = $item;
        return $this;
    }
    /**
     * Get fxAmountRemaining value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getFxAmountRemaining()
    {
        return $this->fxAmountRemaining;
    }
    /**
     * This method is responsible for validating the values passed to the setFxAmountRemaining method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFxAmountRemaining method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFxAmountRemainingForArrayConstraintsFromSetFxAmountRemaining(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicFxAmountRemainingItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicFxAmountRemainingItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($installmentSearchRowBasicFxAmountRemainingItem) ? get_class($installmentSearchRowBasicFxAmountRemainingItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicFxAmountRemainingItem), var_export($installmentSearchRowBasicFxAmountRemainingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fxAmountRemaining property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fxAmountRemaining value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $fxAmountRemaining
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setFxAmountRemaining(array $fxAmountRemaining = array())
    {
        // validation for constraint: array
        if ('' !== ($fxAmountRemainingArrayErrorMessage = self::validateFxAmountRemainingForArrayConstraintsFromSetFxAmountRemaining($fxAmountRemaining))) {
            throw new \InvalidArgumentException($fxAmountRemainingArrayErrorMessage, __LINE__);
        }
        $this->fxAmountRemaining = $fxAmountRemaining;
        return $this;
    }
    /**
     * Add item to fxAmountRemaining value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToFxAmountRemaining(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The fxAmountRemaining property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fxAmountRemaining[] = $item;
        return $this;
    }
    /**
     * Get installmentNumber value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getInstallmentNumber()
    {
        return $this->installmentNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setInstallmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstallmentNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstallmentNumberForArrayConstraintsFromSetInstallmentNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicInstallmentNumberItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicInstallmentNumberItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($installmentSearchRowBasicInstallmentNumberItem) ? get_class($installmentSearchRowBasicInstallmentNumberItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicInstallmentNumberItem), var_export($installmentSearchRowBasicInstallmentNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The installmentNumber property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set installmentNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $installmentNumber
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setInstallmentNumber(array $installmentNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($installmentNumberArrayErrorMessage = self::validateInstallmentNumberForArrayConstraintsFromSetInstallmentNumber($installmentNumber))) {
            throw new \InvalidArgumentException($installmentNumberArrayErrorMessage, __LINE__);
        }
        $this->installmentNumber = $installmentNumber;
        return $this;
    }
    /**
     * Add item to installmentNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToInstallmentNumber(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The installmentNumber property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->installmentNumber[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusForArrayConstraintsFromSetStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentSearchRowBasicStatusItem) {
            // validation for constraint: itemType
            if (!$installmentSearchRowBasicStatusItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($installmentSearchRowBasicStatusItem) ? get_class($installmentSearchRowBasicStatusItem) : sprintf('%s(%s)', gettype($installmentSearchRowBasicStatusItem), var_export($installmentSearchRowBasicStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The status property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set status value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $status
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setStatus(array $status = array())
    {
        // validation for constraint: array
        if ('' !== ($statusArrayErrorMessage = self::validateStatusForArrayConstraintsFromSetStatus($status))) {
            throw new \InvalidArgumentException($statusArrayErrorMessage, __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Add item to status value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function addToStatus(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The status property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->status[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\InstallmentSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
