<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstallmentList StructType
 * @subpackage Structs
 */
class InstallmentList extends AbstractStructBase
{
    /**
     * The installment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Installment[]
     */
    public $installment;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for InstallmentList
     * @uses InstallmentList::setInstallment()
     * @uses InstallmentList::setReplaceAll()
     * @param \StructType\Installment[] $installment
     * @param bool $replaceAll
     */
    public function __construct(array $installment = array(), $replaceAll = true)
    {
        $this
            ->setInstallment($installment)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get installment value
     * @return \StructType\Installment[]|null
     */
    public function getInstallment()
    {
        return $this->installment;
    }
    /**
     * This method is responsible for validating the values passed to the setInstallment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstallment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstallmentForArrayConstraintsFromSetInstallment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $installmentListInstallmentItem) {
            // validation for constraint: itemType
            if (!$installmentListInstallmentItem instanceof \StructType\Installment) {
                $invalidValues[] = is_object($installmentListInstallmentItem) ? get_class($installmentListInstallmentItem) : sprintf('%s(%s)', gettype($installmentListInstallmentItem), var_export($installmentListInstallmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The installment property can only contain items of type \StructType\Installment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set installment value
     * @throws \InvalidArgumentException
     * @param \StructType\Installment[] $installment
     * @return \StructType\InstallmentList
     */
    public function setInstallment(array $installment = array())
    {
        // validation for constraint: array
        if ('' !== ($installmentArrayErrorMessage = self::validateInstallmentForArrayConstraintsFromSetInstallment($installment))) {
            throw new \InvalidArgumentException($installmentArrayErrorMessage, __LINE__);
        }
        $this->installment = $installment;
        return $this;
    }
    /**
     * Add item to installment value
     * @throws \InvalidArgumentException
     * @param \StructType\Installment $item
     * @return \StructType\InstallmentList
     */
    public function addToInstallment(\StructType\Installment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Installment) {
            throw new \InvalidArgumentException(sprintf('The installment property can only contain items of type \StructType\Installment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->installment[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\InstallmentList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
