<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitializeRef StructType
 * @subpackage Structs
 */
class InitializeRef extends BaseRef
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for InitializeRef
     * @uses InitializeRef::setType()
     * @uses InitializeRef::setInternalId()
     * @uses InitializeRef::setExternalId()
     * @param string $type
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($type = null, $internalId = null, $externalId = null)
    {
        $this
            ->setType($type)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\InitializeRefType::valueIsValid()
     * @uses \EnumType\InitializeRefType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\InitializeRef
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitializeRefType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InitializeRefType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\InitializeRefType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\InitializeRef
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\InitializeRef
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
