<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitializeRecord StructType
 * @subpackage Structs
 */
class InitializeRecord extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InitializeRef
     */
    public $reference;
    /**
     * The auxReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InitializeAuxRef
     */
    public $auxReference;
    /**
     * The referenceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InitializeRefList
     */
    public $referenceList;
    /**
     * Constructor method for InitializeRecord
     * @uses InitializeRecord::setType()
     * @uses InitializeRecord::setReference()
     * @uses InitializeRecord::setAuxReference()
     * @uses InitializeRecord::setReferenceList()
     * @param string $type
     * @param \StructType\InitializeRef $reference
     * @param \StructType\InitializeAuxRef $auxReference
     * @param \StructType\InitializeRefList $referenceList
     */
    public function __construct($type = null, \StructType\InitializeRef $reference = null, \StructType\InitializeAuxRef $auxReference = null, \StructType\InitializeRefList $referenceList = null)
    {
        $this
            ->setType($type)
            ->setReference($reference)
            ->setAuxReference($auxReference)
            ->setReferenceList($referenceList);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\InitializeType::valueIsValid()
     * @uses \EnumType\InitializeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\InitializeRecord
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitializeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InitializeType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\InitializeType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get reference value
     * @return \StructType\InitializeRef|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param \StructType\InitializeRef $reference
     * @return \StructType\InitializeRecord
     */
    public function setReference(\StructType\InitializeRef $reference = null)
    {
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get auxReference value
     * @return \StructType\InitializeAuxRef|null
     */
    public function getAuxReference()
    {
        return $this->auxReference;
    }
    /**
     * Set auxReference value
     * @param \StructType\InitializeAuxRef $auxReference
     * @return \StructType\InitializeRecord
     */
    public function setAuxReference(\StructType\InitializeAuxRef $auxReference = null)
    {
        $this->auxReference = $auxReference;
        return $this;
    }
    /**
     * Get referenceList value
     * @return \StructType\InitializeRefList|null
     */
    public function getReferenceList()
    {
        return $this->referenceList;
    }
    /**
     * Set referenceList value
     * @param \StructType\InitializeRefList $referenceList
     * @return \StructType\InitializeRecord
     */
    public function setReferenceList(\StructType\InitializeRefList $referenceList = null)
    {
        $this->referenceList = $referenceList;
        return $this;
    }
}
