<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitializeAuxRef StructType
 * @subpackage Structs
 */
class InitializeAuxRef extends BaseRef
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * The scriptId
     * @var string
     */
    public $scriptId;
    /**
     * Constructor method for InitializeAuxRef
     * @uses InitializeAuxRef::setType()
     * @uses InitializeAuxRef::setInternalId()
     * @uses InitializeAuxRef::setExternalId()
     * @uses InitializeAuxRef::setScriptId()
     * @param string $type
     * @param string $internalId
     * @param string $externalId
     * @param string $scriptId
     */
    public function __construct($type = null, $internalId = null, $externalId = null, $scriptId = null)
    {
        $this
            ->setType($type)
            ->setInternalId($internalId)
            ->setExternalId($externalId)
            ->setScriptId($scriptId);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\InitializeAuxRefType::valueIsValid()
     * @uses \EnumType\InitializeAuxRefType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\InitializeAuxRef
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitializeAuxRefType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InitializeAuxRefType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\InitializeAuxRefType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\InitializeAuxRef
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\InitializeAuxRef
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get scriptId value
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->scriptId;
    }
    /**
     * Set scriptId value
     * @param string $scriptId
     * @return \StructType\InitializeAuxRef
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        $this->scriptId = $scriptId;
        return $this;
    }
}
