<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundShipmentLandedCost StructType
 * @subpackage Structs
 */
class InboundShipmentLandedCost extends AbstractStructBase
{
    /**
     * The landedCostCostCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $landedCostCostCategory;
    /**
     * The landedCostAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $landedCostAmount;
    /**
     * The landedCostCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $landedCostCurrency;
    /**
     * The landedCostExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $landedCostExchangeRate;
    /**
     * The landedCostEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $landedCostEffectiveDate;
    /**
     * The landedCostAllocationMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $landedCostAllocationMethod;
    /**
     * The landedCostShipmentItemsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $landedCostShipmentItemsList;
    /**
     * Constructor method for InboundShipmentLandedCost
     * @uses InboundShipmentLandedCost::setLandedCostCostCategory()
     * @uses InboundShipmentLandedCost::setLandedCostAmount()
     * @uses InboundShipmentLandedCost::setLandedCostCurrency()
     * @uses InboundShipmentLandedCost::setLandedCostExchangeRate()
     * @uses InboundShipmentLandedCost::setLandedCostEffectiveDate()
     * @uses InboundShipmentLandedCost::setLandedCostAllocationMethod()
     * @uses InboundShipmentLandedCost::setLandedCostShipmentItemsList()
     * @param \StructType\RecordRef $landedCostCostCategory
     * @param float $landedCostAmount
     * @param \StructType\RecordRef $landedCostCurrency
     * @param float $landedCostExchangeRate
     * @param string $landedCostEffectiveDate
     * @param string $landedCostAllocationMethod
     * @param \StructType\RecordRefList $landedCostShipmentItemsList
     */
    public function __construct(\StructType\RecordRef $landedCostCostCategory = null, $landedCostAmount = null, \StructType\RecordRef $landedCostCurrency = null, $landedCostExchangeRate = null, $landedCostEffectiveDate = null, $landedCostAllocationMethod = null, \StructType\RecordRefList $landedCostShipmentItemsList = null)
    {
        $this
            ->setLandedCostCostCategory($landedCostCostCategory)
            ->setLandedCostAmount($landedCostAmount)
            ->setLandedCostCurrency($landedCostCurrency)
            ->setLandedCostExchangeRate($landedCostExchangeRate)
            ->setLandedCostEffectiveDate($landedCostEffectiveDate)
            ->setLandedCostAllocationMethod($landedCostAllocationMethod)
            ->setLandedCostShipmentItemsList($landedCostShipmentItemsList);
    }
    /**
     * Get landedCostCostCategory value
     * @return \StructType\RecordRef|null
     */
    public function getLandedCostCostCategory()
    {
        return $this->landedCostCostCategory;
    }
    /**
     * Set landedCostCostCategory value
     * @param \StructType\RecordRef $landedCostCostCategory
     * @return \StructType\InboundShipmentLandedCost
     */
    public function setLandedCostCostCategory(\StructType\RecordRef $landedCostCostCategory = null)
    {
        $this->landedCostCostCategory = $landedCostCostCategory;
        return $this;
    }
    /**
     * Get landedCostAmount value
     * @return float|null
     */
    public function getLandedCostAmount()
    {
        return $this->landedCostAmount;
    }
    /**
     * Set landedCostAmount value
     * @param float $landedCostAmount
     * @return \StructType\InboundShipmentLandedCost
     */
    public function setLandedCostAmount($landedCostAmount = null)
    {
        // validation for constraint: float
        if (!is_null($landedCostAmount) && !(is_float($landedCostAmount) || is_numeric($landedCostAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($landedCostAmount, true), gettype($landedCostAmount)), __LINE__);
        }
        $this->landedCostAmount = $landedCostAmount;
        return $this;
    }
    /**
     * Get landedCostCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getLandedCostCurrency()
    {
        return $this->landedCostCurrency;
    }
    /**
     * Set landedCostCurrency value
     * @param \StructType\RecordRef $landedCostCurrency
     * @return \StructType\InboundShipmentLandedCost
     */
    public function setLandedCostCurrency(\StructType\RecordRef $landedCostCurrency = null)
    {
        $this->landedCostCurrency = $landedCostCurrency;
        return $this;
    }
    /**
     * Get landedCostExchangeRate value
     * @return float|null
     */
    public function getLandedCostExchangeRate()
    {
        return $this->landedCostExchangeRate;
    }
    /**
     * Set landedCostExchangeRate value
     * @param float $landedCostExchangeRate
     * @return \StructType\InboundShipmentLandedCost
     */
    public function setLandedCostExchangeRate($landedCostExchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($landedCostExchangeRate) && !(is_float($landedCostExchangeRate) || is_numeric($landedCostExchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($landedCostExchangeRate, true), gettype($landedCostExchangeRate)), __LINE__);
        }
        $this->landedCostExchangeRate = $landedCostExchangeRate;
        return $this;
    }
    /**
     * Get landedCostEffectiveDate value
     * @return string|null
     */
    public function getLandedCostEffectiveDate()
    {
        return $this->landedCostEffectiveDate;
    }
    /**
     * Set landedCostEffectiveDate value
     * @param string $landedCostEffectiveDate
     * @return \StructType\InboundShipmentLandedCost
     */
    public function setLandedCostEffectiveDate($landedCostEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($landedCostEffectiveDate) && !is_string($landedCostEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landedCostEffectiveDate, true), gettype($landedCostEffectiveDate)), __LINE__);
        }
        $this->landedCostEffectiveDate = $landedCostEffectiveDate;
        return $this;
    }
    /**
     * Get landedCostAllocationMethod value
     * @return string|null
     */
    public function getLandedCostAllocationMethod()
    {
        return $this->landedCostAllocationMethod;
    }
    /**
     * Set landedCostAllocationMethod value
     * @uses \EnumType\InboundShipmentLandedCostAllocationMethod::valueIsValid()
     * @uses \EnumType\InboundShipmentLandedCostAllocationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $landedCostAllocationMethod
     * @return \StructType\InboundShipmentLandedCost
     */
    public function setLandedCostAllocationMethod($landedCostAllocationMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InboundShipmentLandedCostAllocationMethod::valueIsValid($landedCostAllocationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InboundShipmentLandedCostAllocationMethod', is_array($landedCostAllocationMethod) ? implode(', ', $landedCostAllocationMethod) : var_export($landedCostAllocationMethod, true), implode(', ', \EnumType\InboundShipmentLandedCostAllocationMethod::getValidValues())), __LINE__);
        }
        $this->landedCostAllocationMethod = $landedCostAllocationMethod;
        return $this;
    }
    /**
     * Get landedCostShipmentItemsList value
     * @return \StructType\RecordRefList|null
     */
    public function getLandedCostShipmentItemsList()
    {
        return $this->landedCostShipmentItemsList;
    }
    /**
     * Set landedCostShipmentItemsList value
     * @param \StructType\RecordRefList $landedCostShipmentItemsList
     * @return \StructType\InboundShipmentLandedCost
     */
    public function setLandedCostShipmentItemsList(\StructType\RecordRefList $landedCostShipmentItemsList = null)
    {
        $this->landedCostShipmentItemsList = $landedCostShipmentItemsList;
        return $this;
    }
}
