<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundShipmentItems StructType
 * @subpackage Structs
 */
class InboundShipmentItems extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The purchaseOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseOrder;
    /**
     * The shipmentItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipmentItem;
    /**
     * The shipmentItemDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentItemDescription;
    /**
     * The poVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $poVendor;
    /**
     * The receivingLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $receivingLocation;
    /**
     * The quantityReceived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityReceived;
    /**
     * The quantityExpected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityExpected;
    /**
     * The quantityRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityRemaining;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $unit;
    /**
     * The poRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $poRate;
    /**
     * The expectedRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $expectedRate;
    /**
     * The shipmentItemExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shipmentItemExchangeRate;
    /**
     * The shipmentItemEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentItemEffectiveDate;
    /**
     * The unitLandedCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unitLandedCost;
    /**
     * The totalUnitCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalUnitCost;
    /**
     * The shipmentItemAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shipmentItemAmount;
    /**
     * The poCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $poCurrency;
    /**
     * The incoterm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incoterm;
    /**
     * Constructor method for InboundShipmentItems
     * @uses InboundShipmentItems::setId()
     * @uses InboundShipmentItems::setPurchaseOrder()
     * @uses InboundShipmentItems::setShipmentItem()
     * @uses InboundShipmentItems::setShipmentItemDescription()
     * @uses InboundShipmentItems::setPoVendor()
     * @uses InboundShipmentItems::setReceivingLocation()
     * @uses InboundShipmentItems::setQuantityReceived()
     * @uses InboundShipmentItems::setQuantityExpected()
     * @uses InboundShipmentItems::setQuantityRemaining()
     * @uses InboundShipmentItems::setUnit()
     * @uses InboundShipmentItems::setPoRate()
     * @uses InboundShipmentItems::setExpectedRate()
     * @uses InboundShipmentItems::setShipmentItemExchangeRate()
     * @uses InboundShipmentItems::setShipmentItemEffectiveDate()
     * @uses InboundShipmentItems::setUnitLandedCost()
     * @uses InboundShipmentItems::setTotalUnitCost()
     * @uses InboundShipmentItems::setShipmentItemAmount()
     * @uses InboundShipmentItems::setPoCurrency()
     * @uses InboundShipmentItems::setIncoterm()
     * @param int $id
     * @param \StructType\RecordRef $purchaseOrder
     * @param \StructType\RecordRef $shipmentItem
     * @param string $shipmentItemDescription
     * @param string $poVendor
     * @param \StructType\RecordRef $receivingLocation
     * @param float $quantityReceived
     * @param float $quantityExpected
     * @param float $quantityRemaining
     * @param \StructType\RecordRef $unit
     * @param float $poRate
     * @param float $expectedRate
     * @param float $shipmentItemExchangeRate
     * @param string $shipmentItemEffectiveDate
     * @param float $unitLandedCost
     * @param float $totalUnitCost
     * @param float $shipmentItemAmount
     * @param \StructType\RecordRef $poCurrency
     * @param \StructType\RecordRef $incoterm
     */
    public function __construct($id = null, \StructType\RecordRef $purchaseOrder = null, \StructType\RecordRef $shipmentItem = null, $shipmentItemDescription = null, $poVendor = null, \StructType\RecordRef $receivingLocation = null, $quantityReceived = null, $quantityExpected = null, $quantityRemaining = null, \StructType\RecordRef $unit = null, $poRate = null, $expectedRate = null, $shipmentItemExchangeRate = null, $shipmentItemEffectiveDate = null, $unitLandedCost = null, $totalUnitCost = null, $shipmentItemAmount = null, \StructType\RecordRef $poCurrency = null, \StructType\RecordRef $incoterm = null)
    {
        $this
            ->setId($id)
            ->setPurchaseOrder($purchaseOrder)
            ->setShipmentItem($shipmentItem)
            ->setShipmentItemDescription($shipmentItemDescription)
            ->setPoVendor($poVendor)
            ->setReceivingLocation($receivingLocation)
            ->setQuantityReceived($quantityReceived)
            ->setQuantityExpected($quantityExpected)
            ->setQuantityRemaining($quantityRemaining)
            ->setUnit($unit)
            ->setPoRate($poRate)
            ->setExpectedRate($expectedRate)
            ->setShipmentItemExchangeRate($shipmentItemExchangeRate)
            ->setShipmentItemEffectiveDate($shipmentItemEffectiveDate)
            ->setUnitLandedCost($unitLandedCost)
            ->setTotalUnitCost($totalUnitCost)
            ->setShipmentItemAmount($shipmentItemAmount)
            ->setPoCurrency($poCurrency)
            ->setIncoterm($incoterm);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\InboundShipmentItems
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get purchaseOrder value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseOrder()
    {
        return $this->purchaseOrder;
    }
    /**
     * Set purchaseOrder value
     * @param \StructType\RecordRef $purchaseOrder
     * @return \StructType\InboundShipmentItems
     */
    public function setPurchaseOrder(\StructType\RecordRef $purchaseOrder = null)
    {
        $this->purchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Get shipmentItem value
     * @return \StructType\RecordRef|null
     */
    public function getShipmentItem()
    {
        return $this->shipmentItem;
    }
    /**
     * Set shipmentItem value
     * @param \StructType\RecordRef $shipmentItem
     * @return \StructType\InboundShipmentItems
     */
    public function setShipmentItem(\StructType\RecordRef $shipmentItem = null)
    {
        $this->shipmentItem = $shipmentItem;
        return $this;
    }
    /**
     * Get shipmentItemDescription value
     * @return string|null
     */
    public function getShipmentItemDescription()
    {
        return $this->shipmentItemDescription;
    }
    /**
     * Set shipmentItemDescription value
     * @param string $shipmentItemDescription
     * @return \StructType\InboundShipmentItems
     */
    public function setShipmentItemDescription($shipmentItemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentItemDescription) && !is_string($shipmentItemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentItemDescription, true), gettype($shipmentItemDescription)), __LINE__);
        }
        $this->shipmentItemDescription = $shipmentItemDescription;
        return $this;
    }
    /**
     * Get poVendor value
     * @return string|null
     */
    public function getPoVendor()
    {
        return $this->poVendor;
    }
    /**
     * Set poVendor value
     * @param string $poVendor
     * @return \StructType\InboundShipmentItems
     */
    public function setPoVendor($poVendor = null)
    {
        // validation for constraint: string
        if (!is_null($poVendor) && !is_string($poVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poVendor, true), gettype($poVendor)), __LINE__);
        }
        $this->poVendor = $poVendor;
        return $this;
    }
    /**
     * Get receivingLocation value
     * @return \StructType\RecordRef|null
     */
    public function getReceivingLocation()
    {
        return $this->receivingLocation;
    }
    /**
     * Set receivingLocation value
     * @param \StructType\RecordRef $receivingLocation
     * @return \StructType\InboundShipmentItems
     */
    public function setReceivingLocation(\StructType\RecordRef $receivingLocation = null)
    {
        $this->receivingLocation = $receivingLocation;
        return $this;
    }
    /**
     * Get quantityReceived value
     * @return float|null
     */
    public function getQuantityReceived()
    {
        return $this->quantityReceived;
    }
    /**
     * Set quantityReceived value
     * @param float $quantityReceived
     * @return \StructType\InboundShipmentItems
     */
    public function setQuantityReceived($quantityReceived = null)
    {
        // validation for constraint: float
        if (!is_null($quantityReceived) && !(is_float($quantityReceived) || is_numeric($quantityReceived))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityReceived, true), gettype($quantityReceived)), __LINE__);
        }
        $this->quantityReceived = $quantityReceived;
        return $this;
    }
    /**
     * Get quantityExpected value
     * @return float|null
     */
    public function getQuantityExpected()
    {
        return $this->quantityExpected;
    }
    /**
     * Set quantityExpected value
     * @param float $quantityExpected
     * @return \StructType\InboundShipmentItems
     */
    public function setQuantityExpected($quantityExpected = null)
    {
        // validation for constraint: float
        if (!is_null($quantityExpected) && !(is_float($quantityExpected) || is_numeric($quantityExpected))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityExpected, true), gettype($quantityExpected)), __LINE__);
        }
        $this->quantityExpected = $quantityExpected;
        return $this;
    }
    /**
     * Get quantityRemaining value
     * @return float|null
     */
    public function getQuantityRemaining()
    {
        return $this->quantityRemaining;
    }
    /**
     * Set quantityRemaining value
     * @param float $quantityRemaining
     * @return \StructType\InboundShipmentItems
     */
    public function setQuantityRemaining($quantityRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($quantityRemaining) && !(is_float($quantityRemaining) || is_numeric($quantityRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityRemaining, true), gettype($quantityRemaining)), __LINE__);
        }
        $this->quantityRemaining = $quantityRemaining;
        return $this;
    }
    /**
     * Get unit value
     * @return \StructType\RecordRef|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param \StructType\RecordRef $unit
     * @return \StructType\InboundShipmentItems
     */
    public function setUnit(\StructType\RecordRef $unit = null)
    {
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get poRate value
     * @return float|null
     */
    public function getPoRate()
    {
        return $this->poRate;
    }
    /**
     * Set poRate value
     * @param float $poRate
     * @return \StructType\InboundShipmentItems
     */
    public function setPoRate($poRate = null)
    {
        // validation for constraint: float
        if (!is_null($poRate) && !(is_float($poRate) || is_numeric($poRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($poRate, true), gettype($poRate)), __LINE__);
        }
        $this->poRate = $poRate;
        return $this;
    }
    /**
     * Get expectedRate value
     * @return float|null
     */
    public function getExpectedRate()
    {
        return $this->expectedRate;
    }
    /**
     * Set expectedRate value
     * @param float $expectedRate
     * @return \StructType\InboundShipmentItems
     */
    public function setExpectedRate($expectedRate = null)
    {
        // validation for constraint: float
        if (!is_null($expectedRate) && !(is_float($expectedRate) || is_numeric($expectedRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedRate, true), gettype($expectedRate)), __LINE__);
        }
        $this->expectedRate = $expectedRate;
        return $this;
    }
    /**
     * Get shipmentItemExchangeRate value
     * @return float|null
     */
    public function getShipmentItemExchangeRate()
    {
        return $this->shipmentItemExchangeRate;
    }
    /**
     * Set shipmentItemExchangeRate value
     * @param float $shipmentItemExchangeRate
     * @return \StructType\InboundShipmentItems
     */
    public function setShipmentItemExchangeRate($shipmentItemExchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentItemExchangeRate) && !(is_float($shipmentItemExchangeRate) || is_numeric($shipmentItemExchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentItemExchangeRate, true), gettype($shipmentItemExchangeRate)), __LINE__);
        }
        $this->shipmentItemExchangeRate = $shipmentItemExchangeRate;
        return $this;
    }
    /**
     * Get shipmentItemEffectiveDate value
     * @return string|null
     */
    public function getShipmentItemEffectiveDate()
    {
        return $this->shipmentItemEffectiveDate;
    }
    /**
     * Set shipmentItemEffectiveDate value
     * @param string $shipmentItemEffectiveDate
     * @return \StructType\InboundShipmentItems
     */
    public function setShipmentItemEffectiveDate($shipmentItemEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentItemEffectiveDate) && !is_string($shipmentItemEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentItemEffectiveDate, true), gettype($shipmentItemEffectiveDate)), __LINE__);
        }
        $this->shipmentItemEffectiveDate = $shipmentItemEffectiveDate;
        return $this;
    }
    /**
     * Get unitLandedCost value
     * @return float|null
     */
    public function getUnitLandedCost()
    {
        return $this->unitLandedCost;
    }
    /**
     * Set unitLandedCost value
     * @param float $unitLandedCost
     * @return \StructType\InboundShipmentItems
     */
    public function setUnitLandedCost($unitLandedCost = null)
    {
        // validation for constraint: float
        if (!is_null($unitLandedCost) && !(is_float($unitLandedCost) || is_numeric($unitLandedCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitLandedCost, true), gettype($unitLandedCost)), __LINE__);
        }
        $this->unitLandedCost = $unitLandedCost;
        return $this;
    }
    /**
     * Get totalUnitCost value
     * @return float|null
     */
    public function getTotalUnitCost()
    {
        return $this->totalUnitCost;
    }
    /**
     * Set totalUnitCost value
     * @param float $totalUnitCost
     * @return \StructType\InboundShipmentItems
     */
    public function setTotalUnitCost($totalUnitCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalUnitCost) && !(is_float($totalUnitCost) || is_numeric($totalUnitCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalUnitCost, true), gettype($totalUnitCost)), __LINE__);
        }
        $this->totalUnitCost = $totalUnitCost;
        return $this;
    }
    /**
     * Get shipmentItemAmount value
     * @return float|null
     */
    public function getShipmentItemAmount()
    {
        return $this->shipmentItemAmount;
    }
    /**
     * Set shipmentItemAmount value
     * @param float $shipmentItemAmount
     * @return \StructType\InboundShipmentItems
     */
    public function setShipmentItemAmount($shipmentItemAmount = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentItemAmount) && !(is_float($shipmentItemAmount) || is_numeric($shipmentItemAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentItemAmount, true), gettype($shipmentItemAmount)), __LINE__);
        }
        $this->shipmentItemAmount = $shipmentItemAmount;
        return $this;
    }
    /**
     * Get poCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getPoCurrency()
    {
        return $this->poCurrency;
    }
    /**
     * Set poCurrency value
     * @param \StructType\RecordRef $poCurrency
     * @return \StructType\InboundShipmentItems
     */
    public function setPoCurrency(\StructType\RecordRef $poCurrency = null)
    {
        $this->poCurrency = $poCurrency;
        return $this;
    }
    /**
     * Get incoterm value
     * @return \StructType\RecordRef|null
     */
    public function getIncoterm()
    {
        return $this->incoterm;
    }
    /**
     * Set incoterm value
     * @param \StructType\RecordRef $incoterm
     * @return \StructType\InboundShipmentItems
     */
    public function setIncoterm(\StructType\RecordRef $incoterm = null)
    {
        $this->incoterm = $incoterm;
        return $this;
    }
}
