<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftCertificateItemAuthCodesList StructType
 * @subpackage Structs
 */
class GiftCertificateItemAuthCodesList extends AbstractStructBase
{
    /**
     * The authCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GiftCertificateItemAuthCodes[]
     */
    public $authCodes;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for GiftCertificateItemAuthCodesList
     * @uses GiftCertificateItemAuthCodesList::setAuthCodes()
     * @uses GiftCertificateItemAuthCodesList::setReplaceAll()
     * @param \StructType\GiftCertificateItemAuthCodes[] $authCodes
     * @param bool $replaceAll
     */
    public function __construct(array $authCodes = array(), $replaceAll = true)
    {
        $this
            ->setAuthCodes($authCodes)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get authCodes value
     * @return \StructType\GiftCertificateItemAuthCodes[]|null
     */
    public function getAuthCodes()
    {
        return $this->authCodes;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthCodesForArrayConstraintsFromSetAuthCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateItemAuthCodesListAuthCodesItem) {
            // validation for constraint: itemType
            if (!$giftCertificateItemAuthCodesListAuthCodesItem instanceof \StructType\GiftCertificateItemAuthCodes) {
                $invalidValues[] = is_object($giftCertificateItemAuthCodesListAuthCodesItem) ? get_class($giftCertificateItemAuthCodesListAuthCodesItem) : sprintf('%s(%s)', gettype($giftCertificateItemAuthCodesListAuthCodesItem), var_export($giftCertificateItemAuthCodesListAuthCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The authCodes property can only contain items of type \StructType\GiftCertificateItemAuthCodes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set authCodes value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftCertificateItemAuthCodes[] $authCodes
     * @return \StructType\GiftCertificateItemAuthCodesList
     */
    public function setAuthCodes(array $authCodes = array())
    {
        // validation for constraint: array
        if ('' !== ($authCodesArrayErrorMessage = self::validateAuthCodesForArrayConstraintsFromSetAuthCodes($authCodes))) {
            throw new \InvalidArgumentException($authCodesArrayErrorMessage, __LINE__);
        }
        $this->authCodes = $authCodes;
        return $this;
    }
    /**
     * Add item to authCodes value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftCertificateItemAuthCodes $item
     * @return \StructType\GiftCertificateItemAuthCodesList
     */
    public function addToAuthCodes(\StructType\GiftCertificateItemAuthCodes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GiftCertificateItemAuthCodes) {
            throw new \InvalidArgumentException(sprintf('The authCodes property can only contain items of type \StructType\GiftCertificateItemAuthCodes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->authCodes[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\GiftCertificateItemAuthCodesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
