<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSavedSearchResult StructType
 * @subpackage Structs
 */
class GetSavedSearchResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The totalRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalRecords;
    /**
     * The recordRefList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:recordRefList
     * @var \StructType\RecordRefList
     */
    public $recordRefList;
    /**
     * Constructor method for GetSavedSearchResult
     * @uses GetSavedSearchResult::setStatus()
     * @uses GetSavedSearchResult::setTotalRecords()
     * @uses GetSavedSearchResult::setRecordRefList()
     * @param \StructType\Status $status
     * @param int $totalRecords
     * @param \StructType\RecordRefList $recordRefList
     */
    public function __construct(\StructType\Status $status = null, $totalRecords = null, \StructType\RecordRefList $recordRefList = null)
    {
        $this
            ->setStatus($status)
            ->setTotalRecords($totalRecords)
            ->setRecordRefList($recordRefList);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetSavedSearchResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get totalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->totalRecords;
    }
    /**
     * Set totalRecords value
     * @param int $totalRecords
     * @return \StructType\GetSavedSearchResult
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->totalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get recordRefList value
     * @return \StructType\RecordRefList|null
     */
    public function getRecordRefList()
    {
        return $this->recordRefList;
    }
    /**
     * Set recordRefList value
     * @param \StructType\RecordRefList $recordRefList
     * @return \StructType\GetSavedSearchResult
     */
    public function setRecordRefList(\StructType\RecordRefList $recordRefList = null)
    {
        $this->recordRefList = $recordRefList;
        return $this;
    }
}
