<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSavedSearchRecord StructType
 * @subpackage Structs
 */
class GetSavedSearchRecord extends AbstractStructBase
{
    /**
     * The searchType
     * @var string
     */
    public $searchType;
    /**
     * Constructor method for GetSavedSearchRecord
     * @uses GetSavedSearchRecord::setSearchType()
     * @param string $searchType
     */
    public function __construct($searchType = null)
    {
        $this
            ->setSearchType($searchType);
    }
    /**
     * Get searchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->searchType;
    }
    /**
     * Set searchType value
     * @uses \EnumType\SearchRecordType::valueIsValid()
     * @uses \EnumType\SearchRecordType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\GetSavedSearchRecord
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchRecordType::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchRecordType', is_array($searchType) ? implode(', ', $searchType) : var_export($searchType, true), implode(', ', \EnumType\SearchRecordType::getValidValues())), __LINE__);
        }
        $this->searchType = $searchType;
        return $this;
    }
}
