<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPostingTransactionSummaryResult StructType
 * @subpackage Structs
 */
class GetPostingTransactionSummaryResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The totalRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalRecords;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pageSize;
    /**
     * The totalPages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalPages;
    /**
     * The pageIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pageIndex;
    /**
     * The operationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationId;
    /**
     * The postingTransactionSummaryList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PostingTransactionSummaryList
     */
    public $postingTransactionSummaryList;
    /**
     * Constructor method for GetPostingTransactionSummaryResult
     * @uses GetPostingTransactionSummaryResult::setStatus()
     * @uses GetPostingTransactionSummaryResult::setTotalRecords()
     * @uses GetPostingTransactionSummaryResult::setPageSize()
     * @uses GetPostingTransactionSummaryResult::setTotalPages()
     * @uses GetPostingTransactionSummaryResult::setPageIndex()
     * @uses GetPostingTransactionSummaryResult::setOperationId()
     * @uses GetPostingTransactionSummaryResult::setPostingTransactionSummaryList()
     * @param \StructType\Status $status
     * @param int $totalRecords
     * @param int $pageSize
     * @param int $totalPages
     * @param int $pageIndex
     * @param string $operationId
     * @param \StructType\PostingTransactionSummaryList $postingTransactionSummaryList
     */
    public function __construct(\StructType\Status $status = null, $totalRecords = null, $pageSize = null, $totalPages = null, $pageIndex = null, $operationId = null, \StructType\PostingTransactionSummaryList $postingTransactionSummaryList = null)
    {
        $this
            ->setStatus($status)
            ->setTotalRecords($totalRecords)
            ->setPageSize($pageSize)
            ->setTotalPages($totalPages)
            ->setPageIndex($pageIndex)
            ->setOperationId($operationId)
            ->setPostingTransactionSummaryList($postingTransactionSummaryList);
    }
    /**
     * Get status value
     * @return \StructType\Status
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetPostingTransactionSummaryResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get totalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->totalRecords;
    }
    /**
     * Set totalRecords value
     * @param int $totalRecords
     * @return \StructType\GetPostingTransactionSummaryResult
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->totalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\GetPostingTransactionSummaryResult
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get totalPages value
     * @return int|null
     */
    public function getTotalPages()
    {
        return $this->totalPages;
    }
    /**
     * Set totalPages value
     * @param int $totalPages
     * @return \StructType\GetPostingTransactionSummaryResult
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !(is_int($totalPages) || ctype_digit($totalPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPages, true), gettype($totalPages)), __LINE__);
        }
        $this->totalPages = $totalPages;
        return $this;
    }
    /**
     * Get pageIndex value
     * @return int|null
     */
    public function getPageIndex()
    {
        return $this->pageIndex;
    }
    /**
     * Set pageIndex value
     * @param int $pageIndex
     * @return \StructType\GetPostingTransactionSummaryResult
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->pageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get operationId value
     * @return string|null
     */
    public function getOperationId()
    {
        return $this->operationId;
    }
    /**
     * Set operationId value
     * @param string $operationId
     * @return \StructType\GetPostingTransactionSummaryResult
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationId, true), gettype($operationId)), __LINE__);
        }
        $this->operationId = $operationId;
        return $this;
    }
    /**
     * Get postingTransactionSummaryList value
     * @return \StructType\PostingTransactionSummaryList|null
     */
    public function getPostingTransactionSummaryList()
    {
        return $this->postingTransactionSummaryList;
    }
    /**
     * Set postingTransactionSummaryList value
     * @param \StructType\PostingTransactionSummaryList $postingTransactionSummaryList
     * @return \StructType\GetPostingTransactionSummaryResult
     */
    public function setPostingTransactionSummaryList(\StructType\PostingTransactionSummaryList $postingTransactionSummaryList = null)
    {
        $this->postingTransactionSummaryList = $postingTransactionSummaryList;
        return $this;
    }
}
