<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPostingTransactionSummaryRequest StructType
 * @subpackage Structs
 */
class GetPostingTransactionSummaryRequest extends AbstractStructBase
{
    /**
     * The pageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageIndex;
    /**
     * The fields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PostingTransactionSummaryField
     */
    public $fields;
    /**
     * The filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PostingTransactionSummaryFilter
     */
    public $filters;
    /**
     * The operationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operationId;
    /**
     * Constructor method for GetPostingTransactionSummaryRequest
     * @uses GetPostingTransactionSummaryRequest::setPageIndex()
     * @uses GetPostingTransactionSummaryRequest::setFields()
     * @uses GetPostingTransactionSummaryRequest::setFilters()
     * @uses GetPostingTransactionSummaryRequest::setOperationId()
     * @param int $pageIndex
     * @param \StructType\PostingTransactionSummaryField $fields
     * @param \StructType\PostingTransactionSummaryFilter $filters
     * @param string $operationId
     */
    public function __construct($pageIndex = null, \StructType\PostingTransactionSummaryField $fields = null, \StructType\PostingTransactionSummaryFilter $filters = null, $operationId = null)
    {
        $this
            ->setPageIndex($pageIndex)
            ->setFields($fields)
            ->setFilters($filters)
            ->setOperationId($operationId);
    }
    /**
     * Get pageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->pageIndex;
    }
    /**
     * Set pageIndex value
     * @param int $pageIndex
     * @return \StructType\GetPostingTransactionSummaryRequest
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->pageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get fields value
     * @return \StructType\PostingTransactionSummaryField|null
     */
    public function getFields()
    {
        return $this->fields;
    }
    /**
     * Set fields value
     * @param \StructType\PostingTransactionSummaryField $fields
     * @return \StructType\GetPostingTransactionSummaryRequest
     */
    public function setFields(\StructType\PostingTransactionSummaryField $fields = null)
    {
        $this->fields = $fields;
        return $this;
    }
    /**
     * Get filters value
     * @return \StructType\PostingTransactionSummaryFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \StructType\PostingTransactionSummaryFilter $filters
     * @return \StructType\GetPostingTransactionSummaryRequest
     */
    public function setFilters(\StructType\PostingTransactionSummaryFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
    /**
     * Get operationId value
     * @return string|null
     */
    public function getOperationId()
    {
        return $this->operationId;
    }
    /**
     * Set operationId value
     * @param string $operationId
     * @return \StructType\GetPostingTransactionSummaryRequest
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationId, true), gettype($operationId)), __LINE__);
        }
        $this->operationId = $operationId;
        return $this;
    }
}
