<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDeletedResult StructType
 * @subpackage Structs
 */
class GetDeletedResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The totalRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalRecords;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pageSize;
    /**
     * The totalPages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalPages;
    /**
     * The pageIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pageIndex;
    /**
     * The deletedRecordList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:deletedRecordList
     * @var \StructType\DeletedRecordList
     */
    public $deletedRecordList;
    /**
     * Constructor method for GetDeletedResult
     * @uses GetDeletedResult::setStatus()
     * @uses GetDeletedResult::setTotalRecords()
     * @uses GetDeletedResult::setPageSize()
     * @uses GetDeletedResult::setTotalPages()
     * @uses GetDeletedResult::setPageIndex()
     * @uses GetDeletedResult::setDeletedRecordList()
     * @param \StructType\Status $status
     * @param int $totalRecords
     * @param int $pageSize
     * @param int $totalPages
     * @param int $pageIndex
     * @param \StructType\DeletedRecordList $deletedRecordList
     */
    public function __construct(\StructType\Status $status = null, $totalRecords = null, $pageSize = null, $totalPages = null, $pageIndex = null, \StructType\DeletedRecordList $deletedRecordList = null)
    {
        $this
            ->setStatus($status)
            ->setTotalRecords($totalRecords)
            ->setPageSize($pageSize)
            ->setTotalPages($totalPages)
            ->setPageIndex($pageIndex)
            ->setDeletedRecordList($deletedRecordList);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetDeletedResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get totalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->totalRecords;
    }
    /**
     * Set totalRecords value
     * @param int $totalRecords
     * @return \StructType\GetDeletedResult
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->totalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\GetDeletedResult
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get totalPages value
     * @return int|null
     */
    public function getTotalPages()
    {
        return $this->totalPages;
    }
    /**
     * Set totalPages value
     * @param int $totalPages
     * @return \StructType\GetDeletedResult
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !(is_int($totalPages) || ctype_digit($totalPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPages, true), gettype($totalPages)), __LINE__);
        }
        $this->totalPages = $totalPages;
        return $this;
    }
    /**
     * Get pageIndex value
     * @return int|null
     */
    public function getPageIndex()
    {
        return $this->pageIndex;
    }
    /**
     * Set pageIndex value
     * @param int $pageIndex
     * @return \StructType\GetDeletedResult
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->pageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get deletedRecordList value
     * @return \StructType\DeletedRecordList|null
     */
    public function getDeletedRecordList()
    {
        return $this->deletedRecordList;
    }
    /**
     * Set deletedRecordList value
     * @param \StructType\DeletedRecordList $deletedRecordList
     * @return \StructType\GetDeletedResult
     */
    public function setDeletedRecordList(\StructType\DeletedRecordList $deletedRecordList = null)
    {
        $this->deletedRecordList = $deletedRecordList;
        return $this;
    }
}
