<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomizationIdResult StructType
 * @subpackage Structs
 */
class GetCustomizationIdResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The totalRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalRecords;
    /**
     * The customizationRefList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:customizationRefList
     * @var \StructType\CustomizationRefList
     */
    public $customizationRefList;
    /**
     * Constructor method for GetCustomizationIdResult
     * @uses GetCustomizationIdResult::setStatus()
     * @uses GetCustomizationIdResult::setTotalRecords()
     * @uses GetCustomizationIdResult::setCustomizationRefList()
     * @param \StructType\Status $status
     * @param int $totalRecords
     * @param \StructType\CustomizationRefList $customizationRefList
     */
    public function __construct(\StructType\Status $status = null, $totalRecords = null, \StructType\CustomizationRefList $customizationRefList = null)
    {
        $this
            ->setStatus($status)
            ->setTotalRecords($totalRecords)
            ->setCustomizationRefList($customizationRefList);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetCustomizationIdResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get totalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->totalRecords;
    }
    /**
     * Set totalRecords value
     * @param int $totalRecords
     * @return \StructType\GetCustomizationIdResult
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->totalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get customizationRefList value
     * @return \StructType\CustomizationRefList|null
     */
    public function getCustomizationRefList()
    {
        return $this->customizationRefList;
    }
    /**
     * Set customizationRefList value
     * @param \StructType\CustomizationRefList $customizationRefList
     * @return \StructType\GetCustomizationIdResult
     */
    public function setCustomizationRefList(\StructType\CustomizationRefList $customizationRefList = null)
    {
        $this->customizationRefList = $customizationRefList;
        return $this;
    }
}
