<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllRecord StructType
 * @subpackage Structs
 */
class GetAllRecord extends AbstractStructBase
{
    /**
     * The recordType
     * @var string
     */
    public $recordType;
    /**
     * Constructor method for GetAllRecord
     * @uses GetAllRecord::setRecordType()
     * @param string $recordType
     */
    public function __construct($recordType = null)
    {
        $this
            ->setRecordType($recordType);
    }
    /**
     * Get recordType value
     * @return string|null
     */
    public function getRecordType()
    {
        return $this->recordType;
    }
    /**
     * Set recordType value
     * @uses \EnumType\GetAllRecordType::valueIsValid()
     * @uses \EnumType\GetAllRecordType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordType
     * @return \StructType\GetAllRecord
     */
    public function setRecordType($recordType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GetAllRecordType::valueIsValid($recordType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GetAllRecordType', is_array($recordType) ? implode(', ', $recordType) : var_export($recordType, true), implode(', ', \EnumType\GetAllRecordType::getValidValues())), __LINE__);
        }
        $this->recordType = $recordType;
        return $this;
    }
}
