<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralTokenSupportedOperationsListList StructType
 * @subpackage Structs
 */
class GeneralTokenSupportedOperationsListList extends AbstractStructBase
{
    /**
     * The GeneralTokenSupportedOperationsList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $GeneralTokenSupportedOperationsList;
    /**
     * Constructor method for GeneralTokenSupportedOperationsListList
     * @uses GeneralTokenSupportedOperationsListList::setGeneralTokenSupportedOperationsList()
     * @param string[] $generalTokenSupportedOperationsList
     */
    public function __construct(array $generalTokenSupportedOperationsList = array())
    {
        $this
            ->setGeneralTokenSupportedOperationsList($generalTokenSupportedOperationsList);
    }
    /**
     * Get GeneralTokenSupportedOperationsList value
     * @return string[]|null
     */
    public function getGeneralTokenSupportedOperationsList()
    {
        return $this->GeneralTokenSupportedOperationsList;
    }
    /**
     * This method is responsible for validating the values passed to the setGeneralTokenSupportedOperationsList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneralTokenSupportedOperationsList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeneralTokenSupportedOperationsListForArrayConstraintsFromSetGeneralTokenSupportedOperationsList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $generalTokenSupportedOperationsListListGeneralTokenSupportedOperationsListItem) {
            // validation for constraint: enumeration
            if (!\EnumType\PaymentInstrumentSupportedOperation::valueIsValid($generalTokenSupportedOperationsListListGeneralTokenSupportedOperationsListItem)) {
                $invalidValues[] = is_object($generalTokenSupportedOperationsListListGeneralTokenSupportedOperationsListItem) ? get_class($generalTokenSupportedOperationsListListGeneralTokenSupportedOperationsListItem) : sprintf('%s(%s)', gettype($generalTokenSupportedOperationsListListGeneralTokenSupportedOperationsListItem), var_export($generalTokenSupportedOperationsListListGeneralTokenSupportedOperationsListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentInstrumentSupportedOperation', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\PaymentInstrumentSupportedOperation::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GeneralTokenSupportedOperationsList value
     * @uses \EnumType\PaymentInstrumentSupportedOperation::valueIsValid()
     * @uses \EnumType\PaymentInstrumentSupportedOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $generalTokenSupportedOperationsList
     * @return \StructType\GeneralTokenSupportedOperationsListList
     */
    public function setGeneralTokenSupportedOperationsList(array $generalTokenSupportedOperationsList = array())
    {
        // validation for constraint: array
        if ('' !== ($generalTokenSupportedOperationsListArrayErrorMessage = self::validateGeneralTokenSupportedOperationsListForArrayConstraintsFromSetGeneralTokenSupportedOperationsList($generalTokenSupportedOperationsList))) {
            throw new \InvalidArgumentException($generalTokenSupportedOperationsListArrayErrorMessage, __LINE__);
        }
        $this->GeneralTokenSupportedOperationsList = $generalTokenSupportedOperationsList;
        return $this;
    }
    /**
     * Add item to GeneralTokenSupportedOperationsList value
     * @uses \EnumType\PaymentInstrumentSupportedOperation::valueIsValid()
     * @uses \EnumType\PaymentInstrumentSupportedOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GeneralTokenSupportedOperationsListList
     */
    public function addToGeneralTokenSupportedOperationsList($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentInstrumentSupportedOperation::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentInstrumentSupportedOperation', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\PaymentInstrumentSupportedOperation::getValidValues())), __LINE__);
        }
        $this->GeneralTokenSupportedOperationsList[] = $item;
        return $this;
    }
}
