<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Folder StructType
 * @subpackage Structs
 */
class Folder extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The isPrivate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPrivate;
    /**
     * The bundleable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $bundleable;
    /**
     * The hideInBundle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hideInBundle;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The group
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $group;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The folderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $folderType;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Folder
     * @uses Folder::setName()
     * @uses Folder::setDepartment()
     * @uses Folder::setDescription()
     * @uses Folder::setIsInactive()
     * @uses Folder::setIsPrivate()
     * @uses Folder::setBundleable()
     * @uses Folder::setHideInBundle()
     * @uses Folder::setIsOnline()
     * @uses Folder::setGroup()
     * @uses Folder::setParent()
     * @uses Folder::setFolderType()
     * @uses Folder::setClass()
     * @uses Folder::setLocation()
     * @uses Folder::setSubsidiary()
     * @uses Folder::setInternalId()
     * @uses Folder::setExternalId()
     * @param string $name
     * @param \StructType\RecordRef $department
     * @param string $description
     * @param bool $isInactive
     * @param bool $isPrivate
     * @param bool $bundleable
     * @param bool $hideInBundle
     * @param bool $isOnline
     * @param \StructType\RecordRef $group
     * @param \StructType\RecordRef $parent
     * @param string $folderType
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, \StructType\RecordRef $department = null, $description = null, $isInactive = null, $isPrivate = null, $bundleable = null, $hideInBundle = null, $isOnline = null, \StructType\RecordRef $group = null, \StructType\RecordRef $parent = null, $folderType = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setDepartment($department)
            ->setDescription($description)
            ->setIsInactive($isInactive)
            ->setIsPrivate($isPrivate)
            ->setBundleable($bundleable)
            ->setHideInBundle($hideInBundle)
            ->setIsOnline($isOnline)
            ->setGroup($group)
            ->setParent($parent)
            ->setFolderType($folderType)
            ->setClass($class)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Folder
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Folder
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Folder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Folder
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get isPrivate value
     * @return bool|null
     */
    public function getIsPrivate()
    {
        return $this->isPrivate;
    }
    /**
     * Set isPrivate value
     * @param bool $isPrivate
     * @return \StructType\Folder
     */
    public function setIsPrivate($isPrivate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrivate) && !is_bool($isPrivate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrivate, true), gettype($isPrivate)), __LINE__);
        }
        $this->isPrivate = $isPrivate;
        return $this;
    }
    /**
     * Get bundleable value
     * @return bool|null
     */
    public function getBundleable()
    {
        return $this->bundleable;
    }
    /**
     * Set bundleable value
     * @param bool $bundleable
     * @return \StructType\Folder
     */
    public function setBundleable($bundleable = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundleable) && !is_bool($bundleable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundleable, true), gettype($bundleable)), __LINE__);
        }
        $this->bundleable = $bundleable;
        return $this;
    }
    /**
     * Get hideInBundle value
     * @return bool|null
     */
    public function getHideInBundle()
    {
        return $this->hideInBundle;
    }
    /**
     * Set hideInBundle value
     * @param bool $hideInBundle
     * @return \StructType\Folder
     */
    public function setHideInBundle($hideInBundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideInBundle) && !is_bool($hideInBundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideInBundle, true), gettype($hideInBundle)), __LINE__);
        }
        $this->hideInBundle = $hideInBundle;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\Folder
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get group value
     * @return \StructType\RecordRef|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param \StructType\RecordRef $group
     * @return \StructType\Folder
     */
    public function setGroup(\StructType\RecordRef $group = null)
    {
        $this->group = $group;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\Folder
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get folderType value
     * @return string|null
     */
    public function getFolderType()
    {
        return $this->folderType;
    }
    /**
     * Set folderType value
     * @uses \EnumType\FolderFolderType::valueIsValid()
     * @uses \EnumType\FolderFolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $folderType
     * @return \StructType\Folder
     */
    public function setFolderType($folderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FolderFolderType::valueIsValid($folderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FolderFolderType', is_array($folderType) ? implode(', ', $folderType) : var_export($folderType, true), implode(', ', \EnumType\FolderFolderType::getValidValues())), __LINE__);
        }
        $this->folderType = $folderType;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Folder
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Folder
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\Folder
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Folder
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Folder
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
