<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileSiteCategory StructType
 * @subpackage Structs
 */
class FileSiteCategory extends AbstractStructBase
{
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDefault;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The categoryDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $categoryDescription;
    /**
     * The website
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $website;
    /**
     * Constructor method for FileSiteCategory
     * @uses FileSiteCategory::setIsDefault()
     * @uses FileSiteCategory::setCategory()
     * @uses FileSiteCategory::setCategoryDescription()
     * @uses FileSiteCategory::setWebsite()
     * @param bool $isDefault
     * @param \StructType\RecordRef $category
     * @param string $categoryDescription
     * @param \StructType\RecordRef $website
     */
    public function __construct($isDefault = null, \StructType\RecordRef $category = null, $categoryDescription = null, \StructType\RecordRef $website = null)
    {
        $this
            ->setIsDefault($isDefault)
            ->setCategory($category)
            ->setCategoryDescription($categoryDescription)
            ->setWebsite($website);
    }
    /**
     * Get isDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param bool $isDefault
     * @return \StructType\FileSiteCategory
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\FileSiteCategory
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get categoryDescription value
     * @return string|null
     */
    public function getCategoryDescription()
    {
        return $this->categoryDescription;
    }
    /**
     * Set categoryDescription value
     * @param string $categoryDescription
     * @return \StructType\FileSiteCategory
     */
    public function setCategoryDescription($categoryDescription = null)
    {
        // validation for constraint: string
        if (!is_null($categoryDescription) && !is_string($categoryDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryDescription, true), gettype($categoryDescription)), __LINE__);
        }
        $this->categoryDescription = $categoryDescription;
        return $this;
    }
    /**
     * Get website value
     * @return \StructType\RecordRef|null
     */
    public function getWebsite()
    {
        return $this->website;
    }
    /**
     * Set website value
     * @param \StructType\RecordRef $website
     * @return \StructType\FileSiteCategory
     */
    public function setWebsite(\StructType\RecordRef $website = null)
    {
        $this->website = $website;
        return $this;
    }
}
