<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for File StructType
 * @subpackage Structs
 */
class File extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The attachFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $attachFrom;
    /**
     * The mediaTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mediaTypeName;
    /**
     * The fileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fileType;
    /**
     * The content
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $content;
    /**
     * The folder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $folder;
    /**
     * The fileSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fileSize;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The urlComponent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $urlComponent;
    /**
     * The mediaFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $mediaFile;
    /**
     * The textFileEncoding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $textFileEncoding;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The encoding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $encoding;
    /**
     * The altTagCaption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altTagCaption;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The bundleable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $bundleable;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The hideInBundle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hideInBundle;
    /**
     * The isPrivate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPrivate;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $owner;
    /**
     * The caption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $caption;
    /**
     * The storeDisplayThumbnail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeDisplayThumbnail;
    /**
     * The siteDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $siteDescription;
    /**
     * The featuredDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $featuredDescription;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The siteCategoryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FileSiteCategoryList
     */
    public $siteCategoryList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for File
     * @uses File::setName()
     * @uses File::setAttachFrom()
     * @uses File::setMediaTypeName()
     * @uses File::setFileType()
     * @uses File::setContent()
     * @uses File::setFolder()
     * @uses File::setFileSize()
     * @uses File::setUrl()
     * @uses File::setUrlComponent()
     * @uses File::setMediaFile()
     * @uses File::setTextFileEncoding()
     * @uses File::setDescription()
     * @uses File::setEncoding()
     * @uses File::setAltTagCaption()
     * @uses File::setIsOnline()
     * @uses File::setIsInactive()
     * @uses File::setClass()
     * @uses File::setBundleable()
     * @uses File::setDepartment()
     * @uses File::setHideInBundle()
     * @uses File::setIsPrivate()
     * @uses File::setOwner()
     * @uses File::setCaption()
     * @uses File::setStoreDisplayThumbnail()
     * @uses File::setSiteDescription()
     * @uses File::setFeaturedDescription()
     * @uses File::setLastModifiedDate()
     * @uses File::setCreatedDate()
     * @uses File::setSiteCategoryList()
     * @uses File::setInternalId()
     * @uses File::setExternalId()
     * @param string $name
     * @param string $attachFrom
     * @param string $mediaTypeName
     * @param string $fileType
     * @param string $content
     * @param \StructType\RecordRef $folder
     * @param float $fileSize
     * @param string $url
     * @param string $urlComponent
     * @param \StructType\RecordRef $mediaFile
     * @param string $textFileEncoding
     * @param string $description
     * @param string $encoding
     * @param string $altTagCaption
     * @param bool $isOnline
     * @param bool $isInactive
     * @param string $class
     * @param bool $bundleable
     * @param string $department
     * @param bool $hideInBundle
     * @param bool $isPrivate
     * @param \StructType\RecordRef $owner
     * @param string $caption
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @param string $siteDescription
     * @param string $featuredDescription
     * @param string $lastModifiedDate
     * @param string $createdDate
     * @param \StructType\FileSiteCategoryList $siteCategoryList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $attachFrom = null, $mediaTypeName = null, $fileType = null, $content = null, \StructType\RecordRef $folder = null, $fileSize = null, $url = null, $urlComponent = null, \StructType\RecordRef $mediaFile = null, $textFileEncoding = null, $description = null, $encoding = null, $altTagCaption = null, $isOnline = null, $isInactive = null, $class = null, $bundleable = null, $department = null, $hideInBundle = null, $isPrivate = null, \StructType\RecordRef $owner = null, $caption = null, \StructType\RecordRef $storeDisplayThumbnail = null, $siteDescription = null, $featuredDescription = null, $lastModifiedDate = null, $createdDate = null, \StructType\FileSiteCategoryList $siteCategoryList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setAttachFrom($attachFrom)
            ->setMediaTypeName($mediaTypeName)
            ->setFileType($fileType)
            ->setContent($content)
            ->setFolder($folder)
            ->setFileSize($fileSize)
            ->setUrl($url)
            ->setUrlComponent($urlComponent)
            ->setMediaFile($mediaFile)
            ->setTextFileEncoding($textFileEncoding)
            ->setDescription($description)
            ->setEncoding($encoding)
            ->setAltTagCaption($altTagCaption)
            ->setIsOnline($isOnline)
            ->setIsInactive($isInactive)
            ->setClass($class)
            ->setBundleable($bundleable)
            ->setDepartment($department)
            ->setHideInBundle($hideInBundle)
            ->setIsPrivate($isPrivate)
            ->setOwner($owner)
            ->setCaption($caption)
            ->setStoreDisplayThumbnail($storeDisplayThumbnail)
            ->setSiteDescription($siteDescription)
            ->setFeaturedDescription($featuredDescription)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCreatedDate($createdDate)
            ->setSiteCategoryList($siteCategoryList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\File
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get attachFrom value
     * @return string|null
     */
    public function getAttachFrom()
    {
        return $this->attachFrom;
    }
    /**
     * Set attachFrom value
     * @uses \EnumType\FileAttachFrom::valueIsValid()
     * @uses \EnumType\FileAttachFrom::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attachFrom
     * @return \StructType\File
     */
    public function setAttachFrom($attachFrom = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FileAttachFrom::valueIsValid($attachFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FileAttachFrom', is_array($attachFrom) ? implode(', ', $attachFrom) : var_export($attachFrom, true), implode(', ', \EnumType\FileAttachFrom::getValidValues())), __LINE__);
        }
        $this->attachFrom = $attachFrom;
        return $this;
    }
    /**
     * Get mediaTypeName value
     * @return string|null
     */
    public function getMediaTypeName()
    {
        return $this->mediaTypeName;
    }
    /**
     * Set mediaTypeName value
     * @param string $mediaTypeName
     * @return \StructType\File
     */
    public function setMediaTypeName($mediaTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($mediaTypeName) && !is_string($mediaTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaTypeName, true), gettype($mediaTypeName)), __LINE__);
        }
        $this->mediaTypeName = $mediaTypeName;
        return $this;
    }
    /**
     * Get fileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->fileType;
    }
    /**
     * Set fileType value
     * @uses \EnumType\MediaType::valueIsValid()
     * @uses \EnumType\MediaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileType
     * @return \StructType\File
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MediaType::valueIsValid($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MediaType', is_array($fileType) ? implode(', ', $fileType) : var_export($fileType, true), implode(', ', \EnumType\MediaType::getValidValues())), __LINE__);
        }
        $this->fileType = $fileType;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\File
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get folder value
     * @return \StructType\RecordRef|null
     */
    public function getFolder()
    {
        return $this->folder;
    }
    /**
     * Set folder value
     * @param \StructType\RecordRef $folder
     * @return \StructType\File
     */
    public function setFolder(\StructType\RecordRef $folder = null)
    {
        $this->folder = $folder;
        return $this;
    }
    /**
     * Get fileSize value
     * @return float|null
     */
    public function getFileSize()
    {
        return $this->fileSize;
    }
    /**
     * Set fileSize value
     * @param float $fileSize
     * @return \StructType\File
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: float
        if (!is_null($fileSize) && !(is_float($fileSize) || is_numeric($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->fileSize = $fileSize;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\File
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get urlComponent value
     * @return string|null
     */
    public function getUrlComponent()
    {
        return $this->urlComponent;
    }
    /**
     * Set urlComponent value
     * @param string $urlComponent
     * @return \StructType\File
     */
    public function setUrlComponent($urlComponent = null)
    {
        // validation for constraint: string
        if (!is_null($urlComponent) && !is_string($urlComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlComponent, true), gettype($urlComponent)), __LINE__);
        }
        $this->urlComponent = $urlComponent;
        return $this;
    }
    /**
     * Get mediaFile value
     * @return \StructType\RecordRef|null
     */
    public function getMediaFile()
    {
        return $this->mediaFile;
    }
    /**
     * Set mediaFile value
     * @param \StructType\RecordRef $mediaFile
     * @return \StructType\File
     */
    public function setMediaFile(\StructType\RecordRef $mediaFile = null)
    {
        $this->mediaFile = $mediaFile;
        return $this;
    }
    /**
     * Get textFileEncoding value
     * @return string|null
     */
    public function getTextFileEncoding()
    {
        return $this->textFileEncoding;
    }
    /**
     * Set textFileEncoding value
     * @uses \EnumType\TextFileEncoding::valueIsValid()
     * @uses \EnumType\TextFileEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $textFileEncoding
     * @return \StructType\File
     */
    public function setTextFileEncoding($textFileEncoding = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TextFileEncoding::valueIsValid($textFileEncoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TextFileEncoding', is_array($textFileEncoding) ? implode(', ', $textFileEncoding) : var_export($textFileEncoding, true), implode(', ', \EnumType\TextFileEncoding::getValidValues())), __LINE__);
        }
        $this->textFileEncoding = $textFileEncoding;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\File
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @uses \EnumType\FileEncoding::valueIsValid()
     * @uses \EnumType\FileEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encoding
     * @return \StructType\File
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FileEncoding::valueIsValid($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FileEncoding', is_array($encoding) ? implode(', ', $encoding) : var_export($encoding, true), implode(', ', \EnumType\FileEncoding::getValidValues())), __LINE__);
        }
        $this->encoding = $encoding;
        return $this;
    }
    /**
     * Get altTagCaption value
     * @return string|null
     */
    public function getAltTagCaption()
    {
        return $this->altTagCaption;
    }
    /**
     * Set altTagCaption value
     * @param string $altTagCaption
     * @return \StructType\File
     */
    public function setAltTagCaption($altTagCaption = null)
    {
        // validation for constraint: string
        if (!is_null($altTagCaption) && !is_string($altTagCaption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altTagCaption, true), gettype($altTagCaption)), __LINE__);
        }
        $this->altTagCaption = $altTagCaption;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\File
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\File
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \StructType\File
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class, true), gettype($class)), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get bundleable value
     * @return bool|null
     */
    public function getBundleable()
    {
        return $this->bundleable;
    }
    /**
     * Set bundleable value
     * @param bool $bundleable
     * @return \StructType\File
     */
    public function setBundleable($bundleable = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundleable) && !is_bool($bundleable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundleable, true), gettype($bundleable)), __LINE__);
        }
        $this->bundleable = $bundleable;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \StructType\File
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get hideInBundle value
     * @return bool|null
     */
    public function getHideInBundle()
    {
        return $this->hideInBundle;
    }
    /**
     * Set hideInBundle value
     * @param bool $hideInBundle
     * @return \StructType\File
     */
    public function setHideInBundle($hideInBundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideInBundle) && !is_bool($hideInBundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideInBundle, true), gettype($hideInBundle)), __LINE__);
        }
        $this->hideInBundle = $hideInBundle;
        return $this;
    }
    /**
     * Get isPrivate value
     * @return bool|null
     */
    public function getIsPrivate()
    {
        return $this->isPrivate;
    }
    /**
     * Set isPrivate value
     * @param bool $isPrivate
     * @return \StructType\File
     */
    public function setIsPrivate($isPrivate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrivate) && !is_bool($isPrivate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrivate, true), gettype($isPrivate)), __LINE__);
        }
        $this->isPrivate = $isPrivate;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\RecordRef|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\RecordRef $owner
     * @return \StructType\File
     */
    public function setOwner(\StructType\RecordRef $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->caption;
    }
    /**
     * Set caption value
     * @param string $caption
     * @return \StructType\File
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caption, true), gettype($caption)), __LINE__);
        }
        $this->caption = $caption;
        return $this;
    }
    /**
     * Get storeDisplayThumbnail value
     * @return \StructType\RecordRef|null
     */
    public function getStoreDisplayThumbnail()
    {
        return $this->storeDisplayThumbnail;
    }
    /**
     * Set storeDisplayThumbnail value
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @return \StructType\File
     */
    public function setStoreDisplayThumbnail(\StructType\RecordRef $storeDisplayThumbnail = null)
    {
        $this->storeDisplayThumbnail = $storeDisplayThumbnail;
        return $this;
    }
    /**
     * Get siteDescription value
     * @return string|null
     */
    public function getSiteDescription()
    {
        return $this->siteDescription;
    }
    /**
     * Set siteDescription value
     * @param string $siteDescription
     * @return \StructType\File
     */
    public function setSiteDescription($siteDescription = null)
    {
        // validation for constraint: string
        if (!is_null($siteDescription) && !is_string($siteDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteDescription, true), gettype($siteDescription)), __LINE__);
        }
        $this->siteDescription = $siteDescription;
        return $this;
    }
    /**
     * Get featuredDescription value
     * @return string|null
     */
    public function getFeaturedDescription()
    {
        return $this->featuredDescription;
    }
    /**
     * Set featuredDescription value
     * @param string $featuredDescription
     * @return \StructType\File
     */
    public function setFeaturedDescription($featuredDescription = null)
    {
        // validation for constraint: string
        if (!is_null($featuredDescription) && !is_string($featuredDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featuredDescription, true), gettype($featuredDescription)), __LINE__);
        }
        $this->featuredDescription = $featuredDescription;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\File
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\File
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get siteCategoryList value
     * @return \StructType\FileSiteCategoryList|null
     */
    public function getSiteCategoryList()
    {
        return $this->siteCategoryList;
    }
    /**
     * Set siteCategoryList value
     * @param \StructType\FileSiteCategoryList $siteCategoryList
     * @return \StructType\File
     */
    public function setSiteCategoryList(\StructType\FileSiteCategoryList $siteCategoryList = null)
    {
        $this->siteCategoryList = $siteCategoryList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\File
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\File
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
