<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Estimate StructType
 * Meta information extracted from the WSDL
 * - type: tranSales:Estimate
 * @subpackage Structs
 */
class Estimate extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The taxPointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPointDate;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The entityStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityStatus;
    /**
     * The probability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $probability;
    /**
     * The includeInForecast
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeInForecast;
    /**
     * The forecastType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $forecastType;
    /**
     * The opportunity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $opportunity;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The terms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $terms;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The salesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesRep;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partner;
    /**
     * The contribPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contribPct;
    /**
     * The leadSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $leadSource;
    /**
     * The expectedCloseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedCloseDate;
    /**
     * The otherRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $otherRefNum;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The totalCostEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalCostEstimate;
    /**
     * The estGrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfit;
    /**
     * The estGrossProfitPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfitPercent;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The promoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $promoCode;
    /**
     * The discountItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $discountItem;
    /**
     * The discountRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountRate;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The taxItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxItem;
    /**
     * The taxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate;
    /**
     * The vatRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNum;
    /**
     * The toBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBePrinted;
    /**
     * The toBeEmailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeEmailed;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The toBeFaxed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeFaxed;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The visibleToCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $visibleToCustomer;
    /**
     * The messageSel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $messageSel;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shippingAddress;
    /**
     * The shipIsResidential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $shipIsResidential;
    /**
     * The shipAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddressList;
    /**
     * The fob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fob;
    /**
     * The shipDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipDate;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The shippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingCost;
    /**
     * The shippingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingTax1Rate;
    /**
     * The shippingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shippingTaxCode;
    /**
     * The shippingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingTax2Rate;
    /**
     * The handlingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $handlingTaxCode;
    /**
     * The handlingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingTax1Rate;
    /**
     * The handlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingCost;
    /**
     * The trackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $trackingNumbers;
    /**
     * The handlingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlingTax2Rate;
    /**
     * The linkedTrackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkedTrackingNumbers;
    /**
     * The salesGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesGroup;
    /**
     * The syncSalesTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncSalesTeams;
    /**
     * The altSalesTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altSalesTotal;
    /**
     * The canHaveStackable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canHaveStackable;
    /**
     * The oneTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $oneTime;
    /**
     * The recurWeekly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recurWeekly;
    /**
     * The recurMonthly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recurMonthly;
    /**
     * The recurQuarterly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recurQuarterly;
    /**
     * The recurAnnually
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recurAnnually;
    /**
     * The subTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subTotal;
    /**
     * The discountTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountTotal;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The altShippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altShippingCost;
    /**
     * The altHandlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altHandlingCost;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The tax2Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Total;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EstimateItemList
     */
    public $itemList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The salesTeamList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EstimateSalesTeamList
     */
    public $salesTeamList;
    /**
     * The syncPartnerTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncPartnerTeams;
    /**
     * The partnersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EstimatePartnersList
     */
    public $partnersList;
    /**
     * The promotionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PromotionsList
     */
    public $promotionsList;
    /**
     * The shipGroupList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EstimateShipGroupList
     */
    public $shipGroupList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Estimate
     * @uses Estimate::setCreatedDate()
     * @uses Estimate::setLastModifiedDate()
     * @uses Estimate::setNexus()
     * @uses Estimate::setSubsidiaryTaxRegNum()
     * @uses Estimate::setTaxRegOverride()
     * @uses Estimate::setTaxDetailsOverride()
     * @uses Estimate::setEntity()
     * @uses Estimate::setJob()
     * @uses Estimate::setTranDate()
     * @uses Estimate::setTranId()
     * @uses Estimate::setEntityTaxRegNum()
     * @uses Estimate::setTaxPointDate()
     * @uses Estimate::setSource()
     * @uses Estimate::setCustomForm()
     * @uses Estimate::setCurrency()
     * @uses Estimate::setTitle()
     * @uses Estimate::setEntityStatus()
     * @uses Estimate::setProbability()
     * @uses Estimate::setIncludeInForecast()
     * @uses Estimate::setForecastType()
     * @uses Estimate::setOpportunity()
     * @uses Estimate::setDepartment()
     * @uses Estimate::setClass()
     * @uses Estimate::setTerms()
     * @uses Estimate::setDueDate()
     * @uses Estimate::setLocation()
     * @uses Estimate::setSubsidiary()
     * @uses Estimate::setBillingSchedule()
     * @uses Estimate::setStatus()
     * @uses Estimate::setSalesRep()
     * @uses Estimate::setPartner()
     * @uses Estimate::setContribPct()
     * @uses Estimate::setLeadSource()
     * @uses Estimate::setExpectedCloseDate()
     * @uses Estimate::setOtherRefNum()
     * @uses Estimate::setMemo()
     * @uses Estimate::setEndDate()
     * @uses Estimate::setStartDate()
     * @uses Estimate::setTotalCostEstimate()
     * @uses Estimate::setEstGrossProfit()
     * @uses Estimate::setEstGrossProfitPercent()
     * @uses Estimate::setCreatedFrom()
     * @uses Estimate::setExchangeRate()
     * @uses Estimate::setCurrencyName()
     * @uses Estimate::setPromoCode()
     * @uses Estimate::setDiscountItem()
     * @uses Estimate::setDiscountRate()
     * @uses Estimate::setIsTaxable()
     * @uses Estimate::setTaxItem()
     * @uses Estimate::setTaxRate()
     * @uses Estimate::setVatRegNum()
     * @uses Estimate::setToBePrinted()
     * @uses Estimate::setToBeEmailed()
     * @uses Estimate::setEmail()
     * @uses Estimate::setToBeFaxed()
     * @uses Estimate::setFax()
     * @uses Estimate::setVisibleToCustomer()
     * @uses Estimate::setMessageSel()
     * @uses Estimate::setMessage()
     * @uses Estimate::setBillingAddress()
     * @uses Estimate::setBillAddressList()
     * @uses Estimate::setShippingAddress()
     * @uses Estimate::setShipIsResidential()
     * @uses Estimate::setShipAddressList()
     * @uses Estimate::setFob()
     * @uses Estimate::setShipDate()
     * @uses Estimate::setShipMethod()
     * @uses Estimate::setShippingCost()
     * @uses Estimate::setShippingTax1Rate()
     * @uses Estimate::setShippingTaxCode()
     * @uses Estimate::setShippingTax2Rate()
     * @uses Estimate::setHandlingTaxCode()
     * @uses Estimate::setHandlingTax1Rate()
     * @uses Estimate::setHandlingCost()
     * @uses Estimate::setTrackingNumbers()
     * @uses Estimate::setHandlingTax2Rate()
     * @uses Estimate::setLinkedTrackingNumbers()
     * @uses Estimate::setSalesGroup()
     * @uses Estimate::setSyncSalesTeams()
     * @uses Estimate::setAltSalesTotal()
     * @uses Estimate::setCanHaveStackable()
     * @uses Estimate::setOneTime()
     * @uses Estimate::setRecurWeekly()
     * @uses Estimate::setRecurMonthly()
     * @uses Estimate::setRecurQuarterly()
     * @uses Estimate::setRecurAnnually()
     * @uses Estimate::setSubTotal()
     * @uses Estimate::setDiscountTotal()
     * @uses Estimate::setTaxTotal()
     * @uses Estimate::setAltShippingCost()
     * @uses Estimate::setAltHandlingCost()
     * @uses Estimate::setTotal()
     * @uses Estimate::setTax2Total()
     * @uses Estimate::setItemList()
     * @uses Estimate::setAccountingBookDetailList()
     * @uses Estimate::setSalesTeamList()
     * @uses Estimate::setSyncPartnerTeams()
     * @uses Estimate::setPartnersList()
     * @uses Estimate::setPromotionsList()
     * @uses Estimate::setShipGroupList()
     * @uses Estimate::setTaxDetailsList()
     * @uses Estimate::setCustomFieldList()
     * @uses Estimate::setInternalId()
     * @uses Estimate::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $job
     * @param string $tranDate
     * @param string $tranId
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param string $taxPointDate
     * @param string $source
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $currency
     * @param string $title
     * @param \StructType\RecordRef $entityStatus
     * @param float $probability
     * @param bool $includeInForecast
     * @param \StructType\RecordRef $forecastType
     * @param \StructType\RecordRef $opportunity
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $terms
     * @param string $dueDate
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $billingSchedule
     * @param string $status
     * @param \StructType\RecordRef $salesRep
     * @param \StructType\RecordRef $partner
     * @param string $contribPct
     * @param \StructType\RecordRef $leadSource
     * @param string $expectedCloseDate
     * @param string $otherRefNum
     * @param string $memo
     * @param string $endDate
     * @param string $startDate
     * @param float $totalCostEstimate
     * @param float $estGrossProfit
     * @param float $estGrossProfitPercent
     * @param \StructType\RecordRef $createdFrom
     * @param float $exchangeRate
     * @param string $currencyName
     * @param \StructType\RecordRef $promoCode
     * @param \StructType\RecordRef $discountItem
     * @param string $discountRate
     * @param bool $isTaxable
     * @param \StructType\RecordRef $taxItem
     * @param float $taxRate
     * @param string $vatRegNum
     * @param bool $toBePrinted
     * @param bool $toBeEmailed
     * @param string $email
     * @param bool $toBeFaxed
     * @param string $fax
     * @param bool $visibleToCustomer
     * @param \StructType\RecordRef $messageSel
     * @param string $message
     * @param \StructType\Address $billingAddress
     * @param \StructType\RecordRef $billAddressList
     * @param \StructType\Address $shippingAddress
     * @param bool $shipIsResidential
     * @param \StructType\RecordRef $shipAddressList
     * @param string $fob
     * @param string $shipDate
     * @param \StructType\RecordRef $shipMethod
     * @param float $shippingCost
     * @param float $shippingTax1Rate
     * @param \StructType\RecordRef $shippingTaxCode
     * @param string $shippingTax2Rate
     * @param \StructType\RecordRef $handlingTaxCode
     * @param float $handlingTax1Rate
     * @param float $handlingCost
     * @param string $trackingNumbers
     * @param string $handlingTax2Rate
     * @param string $linkedTrackingNumbers
     * @param \StructType\RecordRef $salesGroup
     * @param bool $syncSalesTeams
     * @param float $altSalesTotal
     * @param bool $canHaveStackable
     * @param float $oneTime
     * @param float $recurWeekly
     * @param float $recurMonthly
     * @param float $recurQuarterly
     * @param float $recurAnnually
     * @param float $subTotal
     * @param float $discountTotal
     * @param float $taxTotal
     * @param float $altShippingCost
     * @param float $altHandlingCost
     * @param float $total
     * @param float $tax2Total
     * @param \StructType\EstimateItemList $itemList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\EstimateSalesTeamList $salesTeamList
     * @param bool $syncPartnerTeams
     * @param \StructType\EstimatePartnersList $partnersList
     * @param \StructType\PromotionsList $promotionsList
     * @param \StructType\EstimateShipGroupList $shipGroupList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $job = null, $tranDate = null, $tranId = null, \StructType\RecordRef $entityTaxRegNum = null, $taxPointDate = null, $source = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $currency = null, $title = null, \StructType\RecordRef $entityStatus = null, $probability = null, $includeInForecast = null, \StructType\RecordRef $forecastType = null, \StructType\RecordRef $opportunity = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $terms = null, $dueDate = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $billingSchedule = null, $status = null, \StructType\RecordRef $salesRep = null, \StructType\RecordRef $partner = null, $contribPct = null, \StructType\RecordRef $leadSource = null, $expectedCloseDate = null, $otherRefNum = null, $memo = null, $endDate = null, $startDate = null, $totalCostEstimate = null, $estGrossProfit = null, $estGrossProfitPercent = null, \StructType\RecordRef $createdFrom = null, $exchangeRate = null, $currencyName = null, \StructType\RecordRef $promoCode = null, \StructType\RecordRef $discountItem = null, $discountRate = null, $isTaxable = null, \StructType\RecordRef $taxItem = null, $taxRate = null, $vatRegNum = null, $toBePrinted = null, $toBeEmailed = null, $email = null, $toBeFaxed = null, $fax = null, $visibleToCustomer = null, \StructType\RecordRef $messageSel = null, $message = null, \StructType\Address $billingAddress = null, \StructType\RecordRef $billAddressList = null, \StructType\Address $shippingAddress = null, $shipIsResidential = null, \StructType\RecordRef $shipAddressList = null, $fob = null, $shipDate = null, \StructType\RecordRef $shipMethod = null, $shippingCost = null, $shippingTax1Rate = null, \StructType\RecordRef $shippingTaxCode = null, $shippingTax2Rate = null, \StructType\RecordRef $handlingTaxCode = null, $handlingTax1Rate = null, $handlingCost = null, $trackingNumbers = null, $handlingTax2Rate = null, $linkedTrackingNumbers = null, \StructType\RecordRef $salesGroup = null, $syncSalesTeams = null, $altSalesTotal = null, $canHaveStackable = null, $oneTime = null, $recurWeekly = null, $recurMonthly = null, $recurQuarterly = null, $recurAnnually = null, $subTotal = null, $discountTotal = null, $taxTotal = null, $altShippingCost = null, $altHandlingCost = null, $total = null, $tax2Total = null, \StructType\EstimateItemList $itemList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\EstimateSalesTeamList $salesTeamList = null, $syncPartnerTeams = null, \StructType\EstimatePartnersList $partnersList = null, \StructType\PromotionsList $promotionsList = null, \StructType\EstimateShipGroupList $shipGroupList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setEntity($entity)
            ->setJob($job)
            ->setTranDate($tranDate)
            ->setTranId($tranId)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setTaxPointDate($taxPointDate)
            ->setSource($source)
            ->setCustomForm($customForm)
            ->setCurrency($currency)
            ->setTitle($title)
            ->setEntityStatus($entityStatus)
            ->setProbability($probability)
            ->setIncludeInForecast($includeInForecast)
            ->setForecastType($forecastType)
            ->setOpportunity($opportunity)
            ->setDepartment($department)
            ->setClass($class)
            ->setTerms($terms)
            ->setDueDate($dueDate)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setBillingSchedule($billingSchedule)
            ->setStatus($status)
            ->setSalesRep($salesRep)
            ->setPartner($partner)
            ->setContribPct($contribPct)
            ->setLeadSource($leadSource)
            ->setExpectedCloseDate($expectedCloseDate)
            ->setOtherRefNum($otherRefNum)
            ->setMemo($memo)
            ->setEndDate($endDate)
            ->setStartDate($startDate)
            ->setTotalCostEstimate($totalCostEstimate)
            ->setEstGrossProfit($estGrossProfit)
            ->setEstGrossProfitPercent($estGrossProfitPercent)
            ->setCreatedFrom($createdFrom)
            ->setExchangeRate($exchangeRate)
            ->setCurrencyName($currencyName)
            ->setPromoCode($promoCode)
            ->setDiscountItem($discountItem)
            ->setDiscountRate($discountRate)
            ->setIsTaxable($isTaxable)
            ->setTaxItem($taxItem)
            ->setTaxRate($taxRate)
            ->setVatRegNum($vatRegNum)
            ->setToBePrinted($toBePrinted)
            ->setToBeEmailed($toBeEmailed)
            ->setEmail($email)
            ->setToBeFaxed($toBeFaxed)
            ->setFax($fax)
            ->setVisibleToCustomer($visibleToCustomer)
            ->setMessageSel($messageSel)
            ->setMessage($message)
            ->setBillingAddress($billingAddress)
            ->setBillAddressList($billAddressList)
            ->setShippingAddress($shippingAddress)
            ->setShipIsResidential($shipIsResidential)
            ->setShipAddressList($shipAddressList)
            ->setFob($fob)
            ->setShipDate($shipDate)
            ->setShipMethod($shipMethod)
            ->setShippingCost($shippingCost)
            ->setShippingTax1Rate($shippingTax1Rate)
            ->setShippingTaxCode($shippingTaxCode)
            ->setShippingTax2Rate($shippingTax2Rate)
            ->setHandlingTaxCode($handlingTaxCode)
            ->setHandlingTax1Rate($handlingTax1Rate)
            ->setHandlingCost($handlingCost)
            ->setTrackingNumbers($trackingNumbers)
            ->setHandlingTax2Rate($handlingTax2Rate)
            ->setLinkedTrackingNumbers($linkedTrackingNumbers)
            ->setSalesGroup($salesGroup)
            ->setSyncSalesTeams($syncSalesTeams)
            ->setAltSalesTotal($altSalesTotal)
            ->setCanHaveStackable($canHaveStackable)
            ->setOneTime($oneTime)
            ->setRecurWeekly($recurWeekly)
            ->setRecurMonthly($recurMonthly)
            ->setRecurQuarterly($recurQuarterly)
            ->setRecurAnnually($recurAnnually)
            ->setSubTotal($subTotal)
            ->setDiscountTotal($discountTotal)
            ->setTaxTotal($taxTotal)
            ->setAltShippingCost($altShippingCost)
            ->setAltHandlingCost($altHandlingCost)
            ->setTotal($total)
            ->setTax2Total($tax2Total)
            ->setItemList($itemList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setSalesTeamList($salesTeamList)
            ->setSyncPartnerTeams($syncPartnerTeams)
            ->setPartnersList($partnersList)
            ->setPromotionsList($promotionsList)
            ->setShipGroupList($shipGroupList)
            ->setTaxDetailsList($taxDetailsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Estimate
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Estimate
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\Estimate
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\Estimate
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\Estimate
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\Estimate
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\Estimate
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\Estimate
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\Estimate
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\Estimate
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\Estimate
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get taxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->taxPointDate;
    }
    /**
     * Set taxPointDate value
     * @param string $taxPointDate
     * @return \StructType\Estimate
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->taxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\Estimate
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Estimate
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Estimate
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Estimate
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get entityStatus value
     * @return \StructType\RecordRef|null
     */
    public function getEntityStatus()
    {
        return $this->entityStatus;
    }
    /**
     * Set entityStatus value
     * @param \StructType\RecordRef $entityStatus
     * @return \StructType\Estimate
     */
    public function setEntityStatus(\StructType\RecordRef $entityStatus = null)
    {
        $this->entityStatus = $entityStatus;
        return $this;
    }
    /**
     * Get probability value
     * @return float|null
     */
    public function getProbability()
    {
        return $this->probability;
    }
    /**
     * Set probability value
     * @param float $probability
     * @return \StructType\Estimate
     */
    public function setProbability($probability = null)
    {
        // validation for constraint: float
        if (!is_null($probability) && !(is_float($probability) || is_numeric($probability))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($probability, true), gettype($probability)), __LINE__);
        }
        $this->probability = $probability;
        return $this;
    }
    /**
     * Get includeInForecast value
     * @return bool|null
     */
    public function getIncludeInForecast()
    {
        return $this->includeInForecast;
    }
    /**
     * Set includeInForecast value
     * @param bool $includeInForecast
     * @return \StructType\Estimate
     */
    public function setIncludeInForecast($includeInForecast = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInForecast) && !is_bool($includeInForecast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInForecast, true), gettype($includeInForecast)), __LINE__);
        }
        $this->includeInForecast = $includeInForecast;
        return $this;
    }
    /**
     * Get forecastType value
     * @return \StructType\RecordRef|null
     */
    public function getForecastType()
    {
        return $this->forecastType;
    }
    /**
     * Set forecastType value
     * @param \StructType\RecordRef $forecastType
     * @return \StructType\Estimate
     */
    public function setForecastType(\StructType\RecordRef $forecastType = null)
    {
        $this->forecastType = $forecastType;
        return $this;
    }
    /**
     * Get opportunity value
     * @return \StructType\RecordRef|null
     */
    public function getOpportunity()
    {
        return $this->opportunity;
    }
    /**
     * Set opportunity value
     * @param \StructType\RecordRef $opportunity
     * @return \StructType\Estimate
     */
    public function setOpportunity(\StructType\RecordRef $opportunity = null)
    {
        $this->opportunity = $opportunity;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Estimate
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Estimate
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get terms value
     * @return \StructType\RecordRef|null
     */
    public function getTerms()
    {
        return $this->terms;
    }
    /**
     * Set terms value
     * @param \StructType\RecordRef $terms
     * @return \StructType\Estimate
     */
    public function setTerms(\StructType\RecordRef $terms = null)
    {
        $this->terms = $terms;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\Estimate
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Estimate
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\Estimate
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\Estimate
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Estimate
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get salesRep value
     * @return \StructType\RecordRef|null
     */
    public function getSalesRep()
    {
        return $this->salesRep;
    }
    /**
     * Set salesRep value
     * @param \StructType\RecordRef $salesRep
     * @return \StructType\Estimate
     */
    public function setSalesRep(\StructType\RecordRef $salesRep = null)
    {
        $this->salesRep = $salesRep;
        return $this;
    }
    /**
     * Get partner value
     * @return \StructType\RecordRef|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\RecordRef $partner
     * @return \StructType\Estimate
     */
    public function setPartner(\StructType\RecordRef $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get contribPct value
     * @return string|null
     */
    public function getContribPct()
    {
        return $this->contribPct;
    }
    /**
     * Set contribPct value
     * @param string $contribPct
     * @return \StructType\Estimate
     */
    public function setContribPct($contribPct = null)
    {
        // validation for constraint: string
        if (!is_null($contribPct) && !is_string($contribPct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contribPct, true), gettype($contribPct)), __LINE__);
        }
        $this->contribPct = $contribPct;
        return $this;
    }
    /**
     * Get leadSource value
     * @return \StructType\RecordRef|null
     */
    public function getLeadSource()
    {
        return $this->leadSource;
    }
    /**
     * Set leadSource value
     * @param \StructType\RecordRef $leadSource
     * @return \StructType\Estimate
     */
    public function setLeadSource(\StructType\RecordRef $leadSource = null)
    {
        $this->leadSource = $leadSource;
        return $this;
    }
    /**
     * Get expectedCloseDate value
     * @return string|null
     */
    public function getExpectedCloseDate()
    {
        return $this->expectedCloseDate;
    }
    /**
     * Set expectedCloseDate value
     * @param string $expectedCloseDate
     * @return \StructType\Estimate
     */
    public function setExpectedCloseDate($expectedCloseDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedCloseDate) && !is_string($expectedCloseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedCloseDate, true), gettype($expectedCloseDate)), __LINE__);
        }
        $this->expectedCloseDate = $expectedCloseDate;
        return $this;
    }
    /**
     * Get otherRefNum value
     * @return string|null
     */
    public function getOtherRefNum()
    {
        return $this->otherRefNum;
    }
    /**
     * Set otherRefNum value
     * @param string $otherRefNum
     * @return \StructType\Estimate
     */
    public function setOtherRefNum($otherRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($otherRefNum) && !is_string($otherRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRefNum, true), gettype($otherRefNum)), __LINE__);
        }
        $this->otherRefNum = $otherRefNum;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\Estimate
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\Estimate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\Estimate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get totalCostEstimate value
     * @return float|null
     */
    public function getTotalCostEstimate()
    {
        return $this->totalCostEstimate;
    }
    /**
     * Set totalCostEstimate value
     * @param float $totalCostEstimate
     * @return \StructType\Estimate
     */
    public function setTotalCostEstimate($totalCostEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($totalCostEstimate) && !(is_float($totalCostEstimate) || is_numeric($totalCostEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCostEstimate, true), gettype($totalCostEstimate)), __LINE__);
        }
        $this->totalCostEstimate = $totalCostEstimate;
        return $this;
    }
    /**
     * Get estGrossProfit value
     * @return float|null
     */
    public function getEstGrossProfit()
    {
        return $this->estGrossProfit;
    }
    /**
     * Set estGrossProfit value
     * @param float $estGrossProfit
     * @return \StructType\Estimate
     */
    public function setEstGrossProfit($estGrossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfit) && !(is_float($estGrossProfit) || is_numeric($estGrossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfit, true), gettype($estGrossProfit)), __LINE__);
        }
        $this->estGrossProfit = $estGrossProfit;
        return $this;
    }
    /**
     * Get estGrossProfitPercent value
     * @return float|null
     */
    public function getEstGrossProfitPercent()
    {
        return $this->estGrossProfitPercent;
    }
    /**
     * Set estGrossProfitPercent value
     * @param float $estGrossProfitPercent
     * @return \StructType\Estimate
     */
    public function setEstGrossProfitPercent($estGrossProfitPercent = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfitPercent) && !(is_float($estGrossProfitPercent) || is_numeric($estGrossProfitPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfitPercent, true), gettype($estGrossProfitPercent)), __LINE__);
        }
        $this->estGrossProfitPercent = $estGrossProfitPercent;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\Estimate
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Estimate
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\Estimate
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get promoCode value
     * @return \StructType\RecordRef|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * Set promoCode value
     * @param \StructType\RecordRef $promoCode
     * @return \StructType\Estimate
     */
    public function setPromoCode(\StructType\RecordRef $promoCode = null)
    {
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Get discountItem value
     * @return \StructType\RecordRef|null
     */
    public function getDiscountItem()
    {
        return $this->discountItem;
    }
    /**
     * Set discountItem value
     * @param \StructType\RecordRef $discountItem
     * @return \StructType\Estimate
     */
    public function setDiscountItem(\StructType\RecordRef $discountItem = null)
    {
        $this->discountItem = $discountItem;
        return $this;
    }
    /**
     * Get discountRate value
     * @return string|null
     */
    public function getDiscountRate()
    {
        return $this->discountRate;
    }
    /**
     * Set discountRate value
     * @param string $discountRate
     * @return \StructType\Estimate
     */
    public function setDiscountRate($discountRate = null)
    {
        // validation for constraint: string
        if (!is_null($discountRate) && !is_string($discountRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountRate, true), gettype($discountRate)), __LINE__);
        }
        $this->discountRate = $discountRate;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\Estimate
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get taxItem value
     * @return \StructType\RecordRef|null
     */
    public function getTaxItem()
    {
        return $this->taxItem;
    }
    /**
     * Set taxItem value
     * @param \StructType\RecordRef $taxItem
     * @return \StructType\Estimate
     */
    public function setTaxItem(\StructType\RecordRef $taxItem = null)
    {
        $this->taxItem = $taxItem;
        return $this;
    }
    /**
     * Get taxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }
    /**
     * Set taxRate value
     * @param float $taxRate
     * @return \StructType\Estimate
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->taxRate = $taxRate;
        return $this;
    }
    /**
     * Get vatRegNum value
     * @return string|null
     */
    public function getVatRegNum()
    {
        return $this->vatRegNum;
    }
    /**
     * Set vatRegNum value
     * @param string $vatRegNum
     * @return \StructType\Estimate
     */
    public function setVatRegNum($vatRegNum = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNum) && !is_string($vatRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNum, true), gettype($vatRegNum)), __LINE__);
        }
        $this->vatRegNum = $vatRegNum;
        return $this;
    }
    /**
     * Get toBePrinted value
     * @return bool|null
     */
    public function getToBePrinted()
    {
        return $this->toBePrinted;
    }
    /**
     * Set toBePrinted value
     * @param bool $toBePrinted
     * @return \StructType\Estimate
     */
    public function setToBePrinted($toBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBePrinted) && !is_bool($toBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBePrinted, true), gettype($toBePrinted)), __LINE__);
        }
        $this->toBePrinted = $toBePrinted;
        return $this;
    }
    /**
     * Get toBeEmailed value
     * @return bool|null
     */
    public function getToBeEmailed()
    {
        return $this->toBeEmailed;
    }
    /**
     * Set toBeEmailed value
     * @param bool $toBeEmailed
     * @return \StructType\Estimate
     */
    public function setToBeEmailed($toBeEmailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeEmailed) && !is_bool($toBeEmailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeEmailed, true), gettype($toBeEmailed)), __LINE__);
        }
        $this->toBeEmailed = $toBeEmailed;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Estimate
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get toBeFaxed value
     * @return bool|null
     */
    public function getToBeFaxed()
    {
        return $this->toBeFaxed;
    }
    /**
     * Set toBeFaxed value
     * @param bool $toBeFaxed
     * @return \StructType\Estimate
     */
    public function setToBeFaxed($toBeFaxed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeFaxed) && !is_bool($toBeFaxed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeFaxed, true), gettype($toBeFaxed)), __LINE__);
        }
        $this->toBeFaxed = $toBeFaxed;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Estimate
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get visibleToCustomer value
     * @return bool|null
     */
    public function getVisibleToCustomer()
    {
        return $this->visibleToCustomer;
    }
    /**
     * Set visibleToCustomer value
     * @param bool $visibleToCustomer
     * @return \StructType\Estimate
     */
    public function setVisibleToCustomer($visibleToCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleToCustomer) && !is_bool($visibleToCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleToCustomer, true), gettype($visibleToCustomer)), __LINE__);
        }
        $this->visibleToCustomer = $visibleToCustomer;
        return $this;
    }
    /**
     * Get messageSel value
     * @return \StructType\RecordRef|null
     */
    public function getMessageSel()
    {
        return $this->messageSel;
    }
    /**
     * Set messageSel value
     * @param \StructType\RecordRef $messageSel
     * @return \StructType\Estimate
     */
    public function setMessageSel(\StructType\RecordRef $messageSel = null)
    {
        $this->messageSel = $messageSel;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Estimate
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\Estimate
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\Estimate
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\Address $shippingAddress
     * @return \StructType\Estimate
     */
    public function setShippingAddress(\StructType\Address $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get shipIsResidential value
     * @return bool|null
     */
    public function getShipIsResidential()
    {
        return $this->shipIsResidential;
    }
    /**
     * Set shipIsResidential value
     * @param bool $shipIsResidential
     * @return \StructType\Estimate
     */
    public function setShipIsResidential($shipIsResidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipIsResidential) && !is_bool($shipIsResidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipIsResidential, true), gettype($shipIsResidential)), __LINE__);
        }
        $this->shipIsResidential = $shipIsResidential;
        return $this;
    }
    /**
     * Get shipAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddressList()
    {
        return $this->shipAddressList;
    }
    /**
     * Set shipAddressList value
     * @param \StructType\RecordRef $shipAddressList
     * @return \StructType\Estimate
     */
    public function setShipAddressList(\StructType\RecordRef $shipAddressList = null)
    {
        $this->shipAddressList = $shipAddressList;
        return $this;
    }
    /**
     * Get fob value
     * @return string|null
     */
    public function getFob()
    {
        return $this->fob;
    }
    /**
     * Set fob value
     * @param string $fob
     * @return \StructType\Estimate
     */
    public function setFob($fob = null)
    {
        // validation for constraint: string
        if (!is_null($fob) && !is_string($fob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fob, true), gettype($fob)), __LINE__);
        }
        $this->fob = $fob;
        return $this;
    }
    /**
     * Get shipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->shipDate;
    }
    /**
     * Set shipDate value
     * @param string $shipDate
     * @return \StructType\Estimate
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->shipDate = $shipDate;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\Estimate
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \StructType\Estimate
     */
    public function setShippingCost($shippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCost) && !(is_float($shippingCost) || is_numeric($shippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCost, true), gettype($shippingCost)), __LINE__);
        }
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get shippingTax1Rate value
     * @return float|null
     */
    public function getShippingTax1Rate()
    {
        return $this->shippingTax1Rate;
    }
    /**
     * Set shippingTax1Rate value
     * @param float $shippingTax1Rate
     * @return \StructType\Estimate
     */
    public function setShippingTax1Rate($shippingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTax1Rate) && !(is_float($shippingTax1Rate) || is_numeric($shippingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTax1Rate, true), gettype($shippingTax1Rate)), __LINE__);
        }
        $this->shippingTax1Rate = $shippingTax1Rate;
        return $this;
    }
    /**
     * Get shippingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getShippingTaxCode()
    {
        return $this->shippingTaxCode;
    }
    /**
     * Set shippingTaxCode value
     * @param \StructType\RecordRef $shippingTaxCode
     * @return \StructType\Estimate
     */
    public function setShippingTaxCode(\StructType\RecordRef $shippingTaxCode = null)
    {
        $this->shippingTaxCode = $shippingTaxCode;
        return $this;
    }
    /**
     * Get shippingTax2Rate value
     * @return string|null
     */
    public function getShippingTax2Rate()
    {
        return $this->shippingTax2Rate;
    }
    /**
     * Set shippingTax2Rate value
     * @param string $shippingTax2Rate
     * @return \StructType\Estimate
     */
    public function setShippingTax2Rate($shippingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingTax2Rate) && !is_string($shippingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingTax2Rate, true), gettype($shippingTax2Rate)), __LINE__);
        }
        $this->shippingTax2Rate = $shippingTax2Rate;
        return $this;
    }
    /**
     * Get handlingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getHandlingTaxCode()
    {
        return $this->handlingTaxCode;
    }
    /**
     * Set handlingTaxCode value
     * @param \StructType\RecordRef $handlingTaxCode
     * @return \StructType\Estimate
     */
    public function setHandlingTaxCode(\StructType\RecordRef $handlingTaxCode = null)
    {
        $this->handlingTaxCode = $handlingTaxCode;
        return $this;
    }
    /**
     * Get handlingTax1Rate value
     * @return float|null
     */
    public function getHandlingTax1Rate()
    {
        return $this->handlingTax1Rate;
    }
    /**
     * Set handlingTax1Rate value
     * @param float $handlingTax1Rate
     * @return \StructType\Estimate
     */
    public function setHandlingTax1Rate($handlingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($handlingTax1Rate) && !(is_float($handlingTax1Rate) || is_numeric($handlingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingTax1Rate, true), gettype($handlingTax1Rate)), __LINE__);
        }
        $this->handlingTax1Rate = $handlingTax1Rate;
        return $this;
    }
    /**
     * Get handlingCost value
     * @return float|null
     */
    public function getHandlingCost()
    {
        return $this->handlingCost;
    }
    /**
     * Set handlingCost value
     * @param float $handlingCost
     * @return \StructType\Estimate
     */
    public function setHandlingCost($handlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($handlingCost) && !(is_float($handlingCost) || is_numeric($handlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingCost, true), gettype($handlingCost)), __LINE__);
        }
        $this->handlingCost = $handlingCost;
        return $this;
    }
    /**
     * Get trackingNumbers value
     * @return string|null
     */
    public function getTrackingNumbers()
    {
        return $this->trackingNumbers;
    }
    /**
     * Set trackingNumbers value
     * @param string $trackingNumbers
     * @return \StructType\Estimate
     */
    public function setTrackingNumbers($trackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumbers) && !is_string($trackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumbers, true), gettype($trackingNumbers)), __LINE__);
        }
        $this->trackingNumbers = $trackingNumbers;
        return $this;
    }
    /**
     * Get handlingTax2Rate value
     * @return string|null
     */
    public function getHandlingTax2Rate()
    {
        return $this->handlingTax2Rate;
    }
    /**
     * Set handlingTax2Rate value
     * @param string $handlingTax2Rate
     * @return \StructType\Estimate
     */
    public function setHandlingTax2Rate($handlingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($handlingTax2Rate) && !is_string($handlingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingTax2Rate, true), gettype($handlingTax2Rate)), __LINE__);
        }
        $this->handlingTax2Rate = $handlingTax2Rate;
        return $this;
    }
    /**
     * Get linkedTrackingNumbers value
     * @return string|null
     */
    public function getLinkedTrackingNumbers()
    {
        return $this->linkedTrackingNumbers;
    }
    /**
     * Set linkedTrackingNumbers value
     * @param string $linkedTrackingNumbers
     * @return \StructType\Estimate
     */
    public function setLinkedTrackingNumbers($linkedTrackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($linkedTrackingNumbers) && !is_string($linkedTrackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedTrackingNumbers, true), gettype($linkedTrackingNumbers)), __LINE__);
        }
        $this->linkedTrackingNumbers = $linkedTrackingNumbers;
        return $this;
    }
    /**
     * Get salesGroup value
     * @return \StructType\RecordRef|null
     */
    public function getSalesGroup()
    {
        return $this->salesGroup;
    }
    /**
     * Set salesGroup value
     * @param \StructType\RecordRef $salesGroup
     * @return \StructType\Estimate
     */
    public function setSalesGroup(\StructType\RecordRef $salesGroup = null)
    {
        $this->salesGroup = $salesGroup;
        return $this;
    }
    /**
     * Get syncSalesTeams value
     * @return bool|null
     */
    public function getSyncSalesTeams()
    {
        return $this->syncSalesTeams;
    }
    /**
     * Set syncSalesTeams value
     * @param bool $syncSalesTeams
     * @return \StructType\Estimate
     */
    public function setSyncSalesTeams($syncSalesTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncSalesTeams) && !is_bool($syncSalesTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncSalesTeams, true), gettype($syncSalesTeams)), __LINE__);
        }
        $this->syncSalesTeams = $syncSalesTeams;
        return $this;
    }
    /**
     * Get altSalesTotal value
     * @return float|null
     */
    public function getAltSalesTotal()
    {
        return $this->altSalesTotal;
    }
    /**
     * Set altSalesTotal value
     * @param float $altSalesTotal
     * @return \StructType\Estimate
     */
    public function setAltSalesTotal($altSalesTotal = null)
    {
        // validation for constraint: float
        if (!is_null($altSalesTotal) && !(is_float($altSalesTotal) || is_numeric($altSalesTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altSalesTotal, true), gettype($altSalesTotal)), __LINE__);
        }
        $this->altSalesTotal = $altSalesTotal;
        return $this;
    }
    /**
     * Get canHaveStackable value
     * @return bool|null
     */
    public function getCanHaveStackable()
    {
        return $this->canHaveStackable;
    }
    /**
     * Set canHaveStackable value
     * @param bool $canHaveStackable
     * @return \StructType\Estimate
     */
    public function setCanHaveStackable($canHaveStackable = null)
    {
        // validation for constraint: boolean
        if (!is_null($canHaveStackable) && !is_bool($canHaveStackable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canHaveStackable, true), gettype($canHaveStackable)), __LINE__);
        }
        $this->canHaveStackable = $canHaveStackable;
        return $this;
    }
    /**
     * Get oneTime value
     * @return float|null
     */
    public function getOneTime()
    {
        return $this->oneTime;
    }
    /**
     * Set oneTime value
     * @param float $oneTime
     * @return \StructType\Estimate
     */
    public function setOneTime($oneTime = null)
    {
        // validation for constraint: float
        if (!is_null($oneTime) && !(is_float($oneTime) || is_numeric($oneTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oneTime, true), gettype($oneTime)), __LINE__);
        }
        $this->oneTime = $oneTime;
        return $this;
    }
    /**
     * Get recurWeekly value
     * @return float|null
     */
    public function getRecurWeekly()
    {
        return $this->recurWeekly;
    }
    /**
     * Set recurWeekly value
     * @param float $recurWeekly
     * @return \StructType\Estimate
     */
    public function setRecurWeekly($recurWeekly = null)
    {
        // validation for constraint: float
        if (!is_null($recurWeekly) && !(is_float($recurWeekly) || is_numeric($recurWeekly))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recurWeekly, true), gettype($recurWeekly)), __LINE__);
        }
        $this->recurWeekly = $recurWeekly;
        return $this;
    }
    /**
     * Get recurMonthly value
     * @return float|null
     */
    public function getRecurMonthly()
    {
        return $this->recurMonthly;
    }
    /**
     * Set recurMonthly value
     * @param float $recurMonthly
     * @return \StructType\Estimate
     */
    public function setRecurMonthly($recurMonthly = null)
    {
        // validation for constraint: float
        if (!is_null($recurMonthly) && !(is_float($recurMonthly) || is_numeric($recurMonthly))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recurMonthly, true), gettype($recurMonthly)), __LINE__);
        }
        $this->recurMonthly = $recurMonthly;
        return $this;
    }
    /**
     * Get recurQuarterly value
     * @return float|null
     */
    public function getRecurQuarterly()
    {
        return $this->recurQuarterly;
    }
    /**
     * Set recurQuarterly value
     * @param float $recurQuarterly
     * @return \StructType\Estimate
     */
    public function setRecurQuarterly($recurQuarterly = null)
    {
        // validation for constraint: float
        if (!is_null($recurQuarterly) && !(is_float($recurQuarterly) || is_numeric($recurQuarterly))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recurQuarterly, true), gettype($recurQuarterly)), __LINE__);
        }
        $this->recurQuarterly = $recurQuarterly;
        return $this;
    }
    /**
     * Get recurAnnually value
     * @return float|null
     */
    public function getRecurAnnually()
    {
        return $this->recurAnnually;
    }
    /**
     * Set recurAnnually value
     * @param float $recurAnnually
     * @return \StructType\Estimate
     */
    public function setRecurAnnually($recurAnnually = null)
    {
        // validation for constraint: float
        if (!is_null($recurAnnually) && !(is_float($recurAnnually) || is_numeric($recurAnnually))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recurAnnually, true), gettype($recurAnnually)), __LINE__);
        }
        $this->recurAnnually = $recurAnnually;
        return $this;
    }
    /**
     * Get subTotal value
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->subTotal;
    }
    /**
     * Set subTotal value
     * @param float $subTotal
     * @return \StructType\Estimate
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        $this->subTotal = $subTotal;
        return $this;
    }
    /**
     * Get discountTotal value
     * @return float|null
     */
    public function getDiscountTotal()
    {
        return $this->discountTotal;
    }
    /**
     * Set discountTotal value
     * @param float $discountTotal
     * @return \StructType\Estimate
     */
    public function setDiscountTotal($discountTotal = null)
    {
        // validation for constraint: float
        if (!is_null($discountTotal) && !(is_float($discountTotal) || is_numeric($discountTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountTotal, true), gettype($discountTotal)), __LINE__);
        }
        $this->discountTotal = $discountTotal;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\Estimate
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get altShippingCost value
     * @return float|null
     */
    public function getAltShippingCost()
    {
        return $this->altShippingCost;
    }
    /**
     * Set altShippingCost value
     * @param float $altShippingCost
     * @return \StructType\Estimate
     */
    public function setAltShippingCost($altShippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altShippingCost) && !(is_float($altShippingCost) || is_numeric($altShippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altShippingCost, true), gettype($altShippingCost)), __LINE__);
        }
        $this->altShippingCost = $altShippingCost;
        return $this;
    }
    /**
     * Get altHandlingCost value
     * @return float|null
     */
    public function getAltHandlingCost()
    {
        return $this->altHandlingCost;
    }
    /**
     * Set altHandlingCost value
     * @param float $altHandlingCost
     * @return \StructType\Estimate
     */
    public function setAltHandlingCost($altHandlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altHandlingCost) && !(is_float($altHandlingCost) || is_numeric($altHandlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altHandlingCost, true), gettype($altHandlingCost)), __LINE__);
        }
        $this->altHandlingCost = $altHandlingCost;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\Estimate
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get tax2Total value
     * @return float|null
     */
    public function getTax2Total()
    {
        return $this->tax2Total;
    }
    /**
     * Set tax2Total value
     * @param float $tax2Total
     * @return \StructType\Estimate
     */
    public function setTax2Total($tax2Total = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Total) && !(is_float($tax2Total) || is_numeric($tax2Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Total, true), gettype($tax2Total)), __LINE__);
        }
        $this->tax2Total = $tax2Total;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\EstimateItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\EstimateItemList $itemList
     * @return \StructType\Estimate
     */
    public function setItemList(\StructType\EstimateItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\Estimate
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get salesTeamList value
     * @return \StructType\EstimateSalesTeamList|null
     */
    public function getSalesTeamList()
    {
        return $this->salesTeamList;
    }
    /**
     * Set salesTeamList value
     * @param \StructType\EstimateSalesTeamList $salesTeamList
     * @return \StructType\Estimate
     */
    public function setSalesTeamList(\StructType\EstimateSalesTeamList $salesTeamList = null)
    {
        $this->salesTeamList = $salesTeamList;
        return $this;
    }
    /**
     * Get syncPartnerTeams value
     * @return bool|null
     */
    public function getSyncPartnerTeams()
    {
        return $this->syncPartnerTeams;
    }
    /**
     * Set syncPartnerTeams value
     * @param bool $syncPartnerTeams
     * @return \StructType\Estimate
     */
    public function setSyncPartnerTeams($syncPartnerTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncPartnerTeams) && !is_bool($syncPartnerTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncPartnerTeams, true), gettype($syncPartnerTeams)), __LINE__);
        }
        $this->syncPartnerTeams = $syncPartnerTeams;
        return $this;
    }
    /**
     * Get partnersList value
     * @return \StructType\EstimatePartnersList|null
     */
    public function getPartnersList()
    {
        return $this->partnersList;
    }
    /**
     * Set partnersList value
     * @param \StructType\EstimatePartnersList $partnersList
     * @return \StructType\Estimate
     */
    public function setPartnersList(\StructType\EstimatePartnersList $partnersList = null)
    {
        $this->partnersList = $partnersList;
        return $this;
    }
    /**
     * Get promotionsList value
     * @return \StructType\PromotionsList|null
     */
    public function getPromotionsList()
    {
        return $this->promotionsList;
    }
    /**
     * Set promotionsList value
     * @param \StructType\PromotionsList $promotionsList
     * @return \StructType\Estimate
     */
    public function setPromotionsList(\StructType\PromotionsList $promotionsList = null)
    {
        $this->promotionsList = $promotionsList;
        return $this;
    }
    /**
     * Get shipGroupList value
     * @return \StructType\EstimateShipGroupList|null
     */
    public function getShipGroupList()
    {
        return $this->shipGroupList;
    }
    /**
     * Set shipGroupList value
     * @param \StructType\EstimateShipGroupList $shipGroupList
     * @return \StructType\Estimate
     */
    public function setShipGroupList(\StructType\EstimateShipGroupList $shipGroupList = null)
    {
        $this->shipGroupList = $shipGroupList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\Estimate
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Estimate
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Estimate
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Estimate
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
