<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityGroupSearchRowBasic StructType
 * @subpackage Structs
 */
class EntityGroupSearchRowBasic extends SearchRowBasic
{
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $email;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The groupName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $groupName;
    /**
     * The groupType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $groupType;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isDynamic
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isDynamic;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The isManufacturingWorkCenter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isManufacturingWorkCenter;
    /**
     * The isPrivate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isPrivate;
    /**
     * The laborResources
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $laborResources;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $lastModifiedDate;
    /**
     * The machineResources
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $machineResources;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $owner;
    /**
     * The savedSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $savedSearch;
    /**
     * The size
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $size;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiary;
    /**
     * The workCalendar
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $workCalendar;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for EntityGroupSearchRowBasic
     * @uses EntityGroupSearchRowBasic::setEmail()
     * @uses EntityGroupSearchRowBasic::setExternalId()
     * @uses EntityGroupSearchRowBasic::setGroupName()
     * @uses EntityGroupSearchRowBasic::setGroupType()
     * @uses EntityGroupSearchRowBasic::setInternalId()
     * @uses EntityGroupSearchRowBasic::setIsDynamic()
     * @uses EntityGroupSearchRowBasic::setIsInactive()
     * @uses EntityGroupSearchRowBasic::setIsManufacturingWorkCenter()
     * @uses EntityGroupSearchRowBasic::setIsPrivate()
     * @uses EntityGroupSearchRowBasic::setLaborResources()
     * @uses EntityGroupSearchRowBasic::setLastModifiedDate()
     * @uses EntityGroupSearchRowBasic::setMachineResources()
     * @uses EntityGroupSearchRowBasic::setOwner()
     * @uses EntityGroupSearchRowBasic::setSavedSearch()
     * @uses EntityGroupSearchRowBasic::setSize()
     * @uses EntityGroupSearchRowBasic::setSubsidiary()
     * @uses EntityGroupSearchRowBasic::setWorkCalendar()
     * @uses EntityGroupSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnStringField[] $email
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnStringField[] $groupName
     * @param \StructType\SearchColumnStringField[] $groupType
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isDynamic
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnBooleanField[] $isManufacturingWorkCenter
     * @param \StructType\SearchColumnBooleanField[] $isPrivate
     * @param \StructType\SearchColumnDoubleField[] $laborResources
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @param \StructType\SearchColumnDoubleField[] $machineResources
     * @param \StructType\SearchColumnSelectField[] $owner
     * @param \StructType\SearchColumnStringField[] $savedSearch
     * @param \StructType\SearchColumnLongField[] $size
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @param \StructType\SearchColumnSelectField[] $workCalendar
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $email = array(), array $externalId = array(), array $groupName = array(), array $groupType = array(), array $internalId = array(), array $isDynamic = array(), array $isInactive = array(), array $isManufacturingWorkCenter = array(), array $isPrivate = array(), array $laborResources = array(), array $lastModifiedDate = array(), array $machineResources = array(), array $owner = array(), array $savedSearch = array(), array $size = array(), array $subsidiary = array(), array $workCalendar = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setEmail($email)
            ->setExternalId($externalId)
            ->setGroupName($groupName)
            ->setGroupType($groupType)
            ->setInternalId($internalId)
            ->setIsDynamic($isDynamic)
            ->setIsInactive($isInactive)
            ->setIsManufacturingWorkCenter($isManufacturingWorkCenter)
            ->setIsPrivate($isPrivate)
            ->setLaborResources($laborResources)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMachineResources($machineResources)
            ->setOwner($owner)
            ->setSavedSearch($savedSearch)
            ->setSize($size)
            ->setSubsidiary($subsidiary)
            ->setWorkCalendar($workCalendar)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get email value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicEmailItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicEmailItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicEmailItem) ? get_class($entityGroupSearchRowBasicEmailItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicEmailItem), var_export($entityGroupSearchRowBasicEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The email property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set email value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $email
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Add item to email value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToEmail(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The email property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->email[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicExternalIdItem) ? get_class($entityGroupSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicExternalIdItem), var_export($entityGroupSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get groupName value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupNameForArrayConstraintsFromSetGroupName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicGroupNameItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicGroupNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicGroupNameItem) ? get_class($entityGroupSearchRowBasicGroupNameItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicGroupNameItem), var_export($entityGroupSearchRowBasicGroupNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The groupName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set groupName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $groupName
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setGroupName(array $groupName = array())
    {
        // validation for constraint: array
        if ('' !== ($groupNameArrayErrorMessage = self::validateGroupNameForArrayConstraintsFromSetGroupName($groupName))) {
            throw new \InvalidArgumentException($groupNameArrayErrorMessage, __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
    /**
     * Add item to groupName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToGroupName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The groupName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->groupName[] = $item;
        return $this;
    }
    /**
     * Get groupType value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getGroupType()
    {
        return $this->groupType;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupTypeForArrayConstraintsFromSetGroupType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicGroupTypeItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicGroupTypeItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicGroupTypeItem) ? get_class($entityGroupSearchRowBasicGroupTypeItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicGroupTypeItem), var_export($entityGroupSearchRowBasicGroupTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The groupType property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set groupType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $groupType
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setGroupType(array $groupType = array())
    {
        // validation for constraint: array
        if ('' !== ($groupTypeArrayErrorMessage = self::validateGroupTypeForArrayConstraintsFromSetGroupType($groupType))) {
            throw new \InvalidArgumentException($groupTypeArrayErrorMessage, __LINE__);
        }
        $this->groupType = $groupType;
        return $this;
    }
    /**
     * Add item to groupType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToGroupType(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The groupType property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->groupType[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicInternalIdItem) ? get_class($entityGroupSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicInternalIdItem), var_export($entityGroupSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isDynamic value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsDynamic()
    {
        return $this->isDynamic;
    }
    /**
     * This method is responsible for validating the values passed to the setIsDynamic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsDynamic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsDynamicForArrayConstraintsFromSetIsDynamic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicIsDynamicItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicIsDynamicItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicIsDynamicItem) ? get_class($entityGroupSearchRowBasicIsDynamicItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicIsDynamicItem), var_export($entityGroupSearchRowBasicIsDynamicItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isDynamic property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isDynamic value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isDynamic
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setIsDynamic(array $isDynamic = array())
    {
        // validation for constraint: array
        if ('' !== ($isDynamicArrayErrorMessage = self::validateIsDynamicForArrayConstraintsFromSetIsDynamic($isDynamic))) {
            throw new \InvalidArgumentException($isDynamicArrayErrorMessage, __LINE__);
        }
        $this->isDynamic = $isDynamic;
        return $this;
    }
    /**
     * Add item to isDynamic value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToIsDynamic(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isDynamic property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isDynamic[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicIsInactiveItem) ? get_class($entityGroupSearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicIsInactiveItem), var_export($entityGroupSearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get isManufacturingWorkCenter value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsManufacturingWorkCenter()
    {
        return $this->isManufacturingWorkCenter;
    }
    /**
     * This method is responsible for validating the values passed to the setIsManufacturingWorkCenter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsManufacturingWorkCenter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsManufacturingWorkCenterForArrayConstraintsFromSetIsManufacturingWorkCenter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicIsManufacturingWorkCenterItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicIsManufacturingWorkCenterItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicIsManufacturingWorkCenterItem) ? get_class($entityGroupSearchRowBasicIsManufacturingWorkCenterItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicIsManufacturingWorkCenterItem), var_export($entityGroupSearchRowBasicIsManufacturingWorkCenterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isManufacturingWorkCenter property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isManufacturingWorkCenter value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isManufacturingWorkCenter
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setIsManufacturingWorkCenter(array $isManufacturingWorkCenter = array())
    {
        // validation for constraint: array
        if ('' !== ($isManufacturingWorkCenterArrayErrorMessage = self::validateIsManufacturingWorkCenterForArrayConstraintsFromSetIsManufacturingWorkCenter($isManufacturingWorkCenter))) {
            throw new \InvalidArgumentException($isManufacturingWorkCenterArrayErrorMessage, __LINE__);
        }
        $this->isManufacturingWorkCenter = $isManufacturingWorkCenter;
        return $this;
    }
    /**
     * Add item to isManufacturingWorkCenter value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToIsManufacturingWorkCenter(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isManufacturingWorkCenter property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isManufacturingWorkCenter[] = $item;
        return $this;
    }
    /**
     * Get isPrivate value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsPrivate()
    {
        return $this->isPrivate;
    }
    /**
     * This method is responsible for validating the values passed to the setIsPrivate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsPrivate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsPrivateForArrayConstraintsFromSetIsPrivate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicIsPrivateItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicIsPrivateItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicIsPrivateItem) ? get_class($entityGroupSearchRowBasicIsPrivateItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicIsPrivateItem), var_export($entityGroupSearchRowBasicIsPrivateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isPrivate property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isPrivate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isPrivate
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setIsPrivate(array $isPrivate = array())
    {
        // validation for constraint: array
        if ('' !== ($isPrivateArrayErrorMessage = self::validateIsPrivateForArrayConstraintsFromSetIsPrivate($isPrivate))) {
            throw new \InvalidArgumentException($isPrivateArrayErrorMessage, __LINE__);
        }
        $this->isPrivate = $isPrivate;
        return $this;
    }
    /**
     * Add item to isPrivate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToIsPrivate(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isPrivate property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isPrivate[] = $item;
        return $this;
    }
    /**
     * Get laborResources value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getLaborResources()
    {
        return $this->laborResources;
    }
    /**
     * This method is responsible for validating the values passed to the setLaborResources method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLaborResources method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLaborResourcesForArrayConstraintsFromSetLaborResources(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicLaborResourcesItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicLaborResourcesItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicLaborResourcesItem) ? get_class($entityGroupSearchRowBasicLaborResourcesItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicLaborResourcesItem), var_export($entityGroupSearchRowBasicLaborResourcesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The laborResources property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set laborResources value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $laborResources
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setLaborResources(array $laborResources = array())
    {
        // validation for constraint: array
        if ('' !== ($laborResourcesArrayErrorMessage = self::validateLaborResourcesForArrayConstraintsFromSetLaborResources($laborResources))) {
            throw new \InvalidArgumentException($laborResourcesArrayErrorMessage, __LINE__);
        }
        $this->laborResources = $laborResources;
        return $this;
    }
    /**
     * Add item to laborResources value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToLaborResources(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The laborResources property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->laborResources[] = $item;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * This method is responsible for validating the values passed to the setLastModifiedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastModifiedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicLastModifiedDateItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicLastModifiedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicLastModifiedDateItem) ? get_class($entityGroupSearchRowBasicLastModifiedDateItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicLastModifiedDateItem), var_export($entityGroupSearchRowBasicLastModifiedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setLastModifiedDate(array $lastModifiedDate = array())
    {
        // validation for constraint: array
        if ('' !== ($lastModifiedDateArrayErrorMessage = self::validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate($lastModifiedDate))) {
            throw new \InvalidArgumentException($lastModifiedDateArrayErrorMessage, __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Add item to lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToLastModifiedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lastModifiedDate[] = $item;
        return $this;
    }
    /**
     * Get machineResources value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getMachineResources()
    {
        return $this->machineResources;
    }
    /**
     * This method is responsible for validating the values passed to the setMachineResources method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMachineResources method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMachineResourcesForArrayConstraintsFromSetMachineResources(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicMachineResourcesItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicMachineResourcesItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicMachineResourcesItem) ? get_class($entityGroupSearchRowBasicMachineResourcesItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicMachineResourcesItem), var_export($entityGroupSearchRowBasicMachineResourcesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The machineResources property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set machineResources value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $machineResources
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setMachineResources(array $machineResources = array())
    {
        // validation for constraint: array
        if ('' !== ($machineResourcesArrayErrorMessage = self::validateMachineResourcesForArrayConstraintsFromSetMachineResources($machineResources))) {
            throw new \InvalidArgumentException($machineResourcesArrayErrorMessage, __LINE__);
        }
        $this->machineResources = $machineResources;
        return $this;
    }
    /**
     * Add item to machineResources value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToMachineResources(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The machineResources property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->machineResources[] = $item;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * This method is responsible for validating the values passed to the setOwner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOwner method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOwnerForArrayConstraintsFromSetOwner(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicOwnerItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicOwnerItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicOwnerItem) ? get_class($entityGroupSearchRowBasicOwnerItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicOwnerItem), var_export($entityGroupSearchRowBasicOwnerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The owner property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set owner value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $owner
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setOwner(array $owner = array())
    {
        // validation for constraint: array
        if ('' !== ($ownerArrayErrorMessage = self::validateOwnerForArrayConstraintsFromSetOwner($owner))) {
            throw new \InvalidArgumentException($ownerArrayErrorMessage, __LINE__);
        }
        $this->owner = $owner;
        return $this;
    }
    /**
     * Add item to owner value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToOwner(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The owner property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->owner[] = $item;
        return $this;
    }
    /**
     * Get savedSearch value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getSavedSearch()
    {
        return $this->savedSearch;
    }
    /**
     * This method is responsible for validating the values passed to the setSavedSearch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSavedSearch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSavedSearchForArrayConstraintsFromSetSavedSearch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicSavedSearchItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicSavedSearchItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicSavedSearchItem) ? get_class($entityGroupSearchRowBasicSavedSearchItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicSavedSearchItem), var_export($entityGroupSearchRowBasicSavedSearchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The savedSearch property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set savedSearch value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $savedSearch
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setSavedSearch(array $savedSearch = array())
    {
        // validation for constraint: array
        if ('' !== ($savedSearchArrayErrorMessage = self::validateSavedSearchForArrayConstraintsFromSetSavedSearch($savedSearch))) {
            throw new \InvalidArgumentException($savedSearchArrayErrorMessage, __LINE__);
        }
        $this->savedSearch = $savedSearch;
        return $this;
    }
    /**
     * Add item to savedSearch value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToSavedSearch(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The savedSearch property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->savedSearch[] = $item;
        return $this;
    }
    /**
     * Get size value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * This method is responsible for validating the values passed to the setSize method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSize method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSizeForArrayConstraintsFromSetSize(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicSizeItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicSizeItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicSizeItem) ? get_class($entityGroupSearchRowBasicSizeItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicSizeItem), var_export($entityGroupSearchRowBasicSizeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The size property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set size value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $size
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setSize(array $size = array())
    {
        // validation for constraint: array
        if ('' !== ($sizeArrayErrorMessage = self::validateSizeForArrayConstraintsFromSetSize($size))) {
            throw new \InvalidArgumentException($sizeArrayErrorMessage, __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Add item to size value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToSize(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The size property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->size[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicSubsidiaryItem) ? get_class($entityGroupSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicSubsidiaryItem), var_export($entityGroupSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get workCalendar value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getWorkCalendar()
    {
        return $this->workCalendar;
    }
    /**
     * This method is responsible for validating the values passed to the setWorkCalendar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorkCalendar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorkCalendarForArrayConstraintsFromSetWorkCalendar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityGroupSearchRowBasicWorkCalendarItem) {
            // validation for constraint: itemType
            if (!$entityGroupSearchRowBasicWorkCalendarItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($entityGroupSearchRowBasicWorkCalendarItem) ? get_class($entityGroupSearchRowBasicWorkCalendarItem) : sprintf('%s(%s)', gettype($entityGroupSearchRowBasicWorkCalendarItem), var_export($entityGroupSearchRowBasicWorkCalendarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The workCalendar property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set workCalendar value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $workCalendar
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setWorkCalendar(array $workCalendar = array())
    {
        // validation for constraint: array
        if ('' !== ($workCalendarArrayErrorMessage = self::validateWorkCalendarForArrayConstraintsFromSetWorkCalendar($workCalendar))) {
            throw new \InvalidArgumentException($workCalendarArrayErrorMessage, __LINE__);
        }
        $this->workCalendar = $workCalendar;
        return $this;
    }
    /**
     * Add item to workCalendar value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function addToWorkCalendar(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The workCalendar property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->workCalendar[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\EntityGroupSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
