<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityCustomField StructType
 * Meta information extracted from the WSDL
 * - type: setupCustom:EntityCustomField
 * @subpackage Structs
 */
class EntityCustomField extends CustomFieldType
{
    /**
     * The label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $owner;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The selectRecordType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $selectRecordType;
    /**
     * The storeValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $storeValue;
    /**
     * The showInList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showInList;
    /**
     * The globalSearch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $globalSearch;
    /**
     * The isParent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isParent;
    /**
     * The insertBefore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $insertBefore;
    /**
     * The availableToSso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableToSso;
    /**
     * The subtab
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subtab;
    /**
     * The displayType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayType;
    /**
     * The displayWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $displayWidth;
    /**
     * The displayHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $displayHeight;
    /**
     * The help
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $help;
    /**
     * The parentSubtab
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parentSubtab;
    /**
     * The linkText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkText;
    /**
     * The isMandatory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isMandatory;
    /**
     * The checkSpelling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $checkSpelling;
    /**
     * The maxLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxLength;
    /**
     * The minValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $minValue;
    /**
     * The maxValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $maxValue;
    /**
     * The defaultChecked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $defaultChecked;
    /**
     * The defaultValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $defaultValue;
    /**
     * The isFormula
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFormula;
    /**
     * The defaultSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $defaultSelection;
    /**
     * The dynamicDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dynamicDefault;
    /**
     * The searchDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $searchDefault;
    /**
     * The searchCompareField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $searchCompareField;
    /**
     * The sourceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $sourceList;
    /**
     * The sourceFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $sourceFrom;
    /**
     * The sourceFilterBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $sourceFilterBy;
    /**
     * The customSegment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customSegment;
    /**
     * The appliesToCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToCustomer;
    /**
     * The appliesToProject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToProject;
    /**
     * The appliesToVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToVendor;
    /**
     * The appliesToEmployee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToEmployee;
    /**
     * The appliesToOtherName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToOtherName;
    /**
     * The appliesToContact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToContact;
    /**
     * The appliesToPartner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToPartner;
    /**
     * The appliesToWebSite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToWebSite;
    /**
     * The appliesToGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToGroup;
    /**
     * The availableExternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableExternally;
    /**
     * The filterList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EntityCustomFieldFilterList
     */
    public $filterList;
    /**
     * The accessLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessLevel;
    /**
     * The appliesToStatement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToStatement;
    /**
     * The searchLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchLevel;
    /**
     * The appliesToPriceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $appliesToPriceList;
    /**
     * The roleAccessList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldRoleAccessList
     */
    public $roleAccessList;
    /**
     * The deptAccessList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldDepartmentAccessList
     */
    public $deptAccessList;
    /**
     * The subAccessList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldSubAccessList
     */
    public $subAccessList;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldTranslationsList
     */
    public $translationsList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for EntityCustomField
     * @uses EntityCustomField::setLabel()
     * @uses EntityCustomField::setOwner()
     * @uses EntityCustomField::setDescription()
     * @uses EntityCustomField::setSelectRecordType()
     * @uses EntityCustomField::setStoreValue()
     * @uses EntityCustomField::setShowInList()
     * @uses EntityCustomField::setGlobalSearch()
     * @uses EntityCustomField::setIsParent()
     * @uses EntityCustomField::setInsertBefore()
     * @uses EntityCustomField::setAvailableToSso()
     * @uses EntityCustomField::setSubtab()
     * @uses EntityCustomField::setDisplayType()
     * @uses EntityCustomField::setDisplayWidth()
     * @uses EntityCustomField::setDisplayHeight()
     * @uses EntityCustomField::setHelp()
     * @uses EntityCustomField::setParentSubtab()
     * @uses EntityCustomField::setLinkText()
     * @uses EntityCustomField::setIsMandatory()
     * @uses EntityCustomField::setCheckSpelling()
     * @uses EntityCustomField::setMaxLength()
     * @uses EntityCustomField::setMinValue()
     * @uses EntityCustomField::setMaxValue()
     * @uses EntityCustomField::setDefaultChecked()
     * @uses EntityCustomField::setDefaultValue()
     * @uses EntityCustomField::setIsFormula()
     * @uses EntityCustomField::setDefaultSelection()
     * @uses EntityCustomField::setDynamicDefault()
     * @uses EntityCustomField::setSearchDefault()
     * @uses EntityCustomField::setSearchCompareField()
     * @uses EntityCustomField::setSourceList()
     * @uses EntityCustomField::setSourceFrom()
     * @uses EntityCustomField::setSourceFilterBy()
     * @uses EntityCustomField::setCustomSegment()
     * @uses EntityCustomField::setAppliesToCustomer()
     * @uses EntityCustomField::setAppliesToProject()
     * @uses EntityCustomField::setAppliesToVendor()
     * @uses EntityCustomField::setAppliesToEmployee()
     * @uses EntityCustomField::setAppliesToOtherName()
     * @uses EntityCustomField::setAppliesToContact()
     * @uses EntityCustomField::setAppliesToPartner()
     * @uses EntityCustomField::setAppliesToWebSite()
     * @uses EntityCustomField::setAppliesToGroup()
     * @uses EntityCustomField::setAvailableExternally()
     * @uses EntityCustomField::setFilterList()
     * @uses EntityCustomField::setAccessLevel()
     * @uses EntityCustomField::setAppliesToStatement()
     * @uses EntityCustomField::setSearchLevel()
     * @uses EntityCustomField::setAppliesToPriceList()
     * @uses EntityCustomField::setRoleAccessList()
     * @uses EntityCustomField::setDeptAccessList()
     * @uses EntityCustomField::setSubAccessList()
     * @uses EntityCustomField::setTranslationsList()
     * @uses EntityCustomField::setInternalId()
     * @param string $label
     * @param \StructType\RecordRef $owner
     * @param string $description
     * @param \StructType\RecordRef $selectRecordType
     * @param bool $storeValue
     * @param bool $showInList
     * @param bool $globalSearch
     * @param bool $isParent
     * @param \StructType\RecordRef $insertBefore
     * @param bool $availableToSso
     * @param \StructType\RecordRef $subtab
     * @param string $displayType
     * @param int $displayWidth
     * @param int $displayHeight
     * @param string $help
     * @param \StructType\RecordRef $parentSubtab
     * @param string $linkText
     * @param bool $isMandatory
     * @param bool $checkSpelling
     * @param int $maxLength
     * @param float $minValue
     * @param float $maxValue
     * @param bool $defaultChecked
     * @param string $defaultValue
     * @param bool $isFormula
     * @param \StructType\RecordRef $defaultSelection
     * @param string $dynamicDefault
     * @param \StructType\RecordRef $searchDefault
     * @param \StructType\RecordRef $searchCompareField
     * @param \StructType\RecordRef $sourceList
     * @param \StructType\RecordRef $sourceFrom
     * @param \StructType\RecordRef $sourceFilterBy
     * @param \StructType\RecordRef $customSegment
     * @param bool $appliesToCustomer
     * @param bool $appliesToProject
     * @param bool $appliesToVendor
     * @param bool $appliesToEmployee
     * @param bool $appliesToOtherName
     * @param bool $appliesToContact
     * @param bool $appliesToPartner
     * @param bool $appliesToWebSite
     * @param bool $appliesToGroup
     * @param bool $availableExternally
     * @param \StructType\EntityCustomFieldFilterList $filterList
     * @param string $accessLevel
     * @param bool $appliesToStatement
     * @param string $searchLevel
     * @param bool $appliesToPriceList
     * @param \StructType\CustomFieldRoleAccessList $roleAccessList
     * @param \StructType\CustomFieldDepartmentAccessList $deptAccessList
     * @param \StructType\CustomFieldSubAccessList $subAccessList
     * @param \StructType\CustomFieldTranslationsList $translationsList
     * @param string $internalId
     */
    public function __construct($label = null, \StructType\RecordRef $owner = null, $description = null, \StructType\RecordRef $selectRecordType = null, $storeValue = null, $showInList = null, $globalSearch = null, $isParent = null, \StructType\RecordRef $insertBefore = null, $availableToSso = null, \StructType\RecordRef $subtab = null, $displayType = null, $displayWidth = null, $displayHeight = null, $help = null, \StructType\RecordRef $parentSubtab = null, $linkText = null, $isMandatory = null, $checkSpelling = null, $maxLength = null, $minValue = null, $maxValue = null, $defaultChecked = null, $defaultValue = null, $isFormula = null, \StructType\RecordRef $defaultSelection = null, $dynamicDefault = null, \StructType\RecordRef $searchDefault = null, \StructType\RecordRef $searchCompareField = null, \StructType\RecordRef $sourceList = null, \StructType\RecordRef $sourceFrom = null, \StructType\RecordRef $sourceFilterBy = null, \StructType\RecordRef $customSegment = null, $appliesToCustomer = null, $appliesToProject = null, $appliesToVendor = null, $appliesToEmployee = null, $appliesToOtherName = null, $appliesToContact = null, $appliesToPartner = null, $appliesToWebSite = null, $appliesToGroup = null, $availableExternally = null, \StructType\EntityCustomFieldFilterList $filterList = null, $accessLevel = null, $appliesToStatement = null, $searchLevel = null, $appliesToPriceList = null, \StructType\CustomFieldRoleAccessList $roleAccessList = null, \StructType\CustomFieldDepartmentAccessList $deptAccessList = null, \StructType\CustomFieldSubAccessList $subAccessList = null, \StructType\CustomFieldTranslationsList $translationsList = null, $internalId = null)
    {
        $this
            ->setLabel($label)
            ->setOwner($owner)
            ->setDescription($description)
            ->setSelectRecordType($selectRecordType)
            ->setStoreValue($storeValue)
            ->setShowInList($showInList)
            ->setGlobalSearch($globalSearch)
            ->setIsParent($isParent)
            ->setInsertBefore($insertBefore)
            ->setAvailableToSso($availableToSso)
            ->setSubtab($subtab)
            ->setDisplayType($displayType)
            ->setDisplayWidth($displayWidth)
            ->setDisplayHeight($displayHeight)
            ->setHelp($help)
            ->setParentSubtab($parentSubtab)
            ->setLinkText($linkText)
            ->setIsMandatory($isMandatory)
            ->setCheckSpelling($checkSpelling)
            ->setMaxLength($maxLength)
            ->setMinValue($minValue)
            ->setMaxValue($maxValue)
            ->setDefaultChecked($defaultChecked)
            ->setDefaultValue($defaultValue)
            ->setIsFormula($isFormula)
            ->setDefaultSelection($defaultSelection)
            ->setDynamicDefault($dynamicDefault)
            ->setSearchDefault($searchDefault)
            ->setSearchCompareField($searchCompareField)
            ->setSourceList($sourceList)
            ->setSourceFrom($sourceFrom)
            ->setSourceFilterBy($sourceFilterBy)
            ->setCustomSegment($customSegment)
            ->setAppliesToCustomer($appliesToCustomer)
            ->setAppliesToProject($appliesToProject)
            ->setAppliesToVendor($appliesToVendor)
            ->setAppliesToEmployee($appliesToEmployee)
            ->setAppliesToOtherName($appliesToOtherName)
            ->setAppliesToContact($appliesToContact)
            ->setAppliesToPartner($appliesToPartner)
            ->setAppliesToWebSite($appliesToWebSite)
            ->setAppliesToGroup($appliesToGroup)
            ->setAvailableExternally($availableExternally)
            ->setFilterList($filterList)
            ->setAccessLevel($accessLevel)
            ->setAppliesToStatement($appliesToStatement)
            ->setSearchLevel($searchLevel)
            ->setAppliesToPriceList($appliesToPriceList)
            ->setRoleAccessList($roleAccessList)
            ->setDeptAccessList($deptAccessList)
            ->setSubAccessList($subAccessList)
            ->setTranslationsList($translationsList)
            ->setInternalId($internalId);
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\EntityCustomField
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\RecordRef|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\RecordRef $owner
     * @return \StructType\EntityCustomField
     */
    public function setOwner(\StructType\RecordRef $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\EntityCustomField
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get selectRecordType value
     * @return \StructType\RecordRef|null
     */
    public function getSelectRecordType()
    {
        return $this->selectRecordType;
    }
    /**
     * Set selectRecordType value
     * @param \StructType\RecordRef $selectRecordType
     * @return \StructType\EntityCustomField
     */
    public function setSelectRecordType(\StructType\RecordRef $selectRecordType = null)
    {
        $this->selectRecordType = $selectRecordType;
        return $this;
    }
    /**
     * Get storeValue value
     * @return bool|null
     */
    public function getStoreValue()
    {
        return $this->storeValue;
    }
    /**
     * Set storeValue value
     * @param bool $storeValue
     * @return \StructType\EntityCustomField
     */
    public function setStoreValue($storeValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($storeValue) && !is_bool($storeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($storeValue, true), gettype($storeValue)), __LINE__);
        }
        $this->storeValue = $storeValue;
        return $this;
    }
    /**
     * Get showInList value
     * @return bool|null
     */
    public function getShowInList()
    {
        return $this->showInList;
    }
    /**
     * Set showInList value
     * @param bool $showInList
     * @return \StructType\EntityCustomField
     */
    public function setShowInList($showInList = null)
    {
        // validation for constraint: boolean
        if (!is_null($showInList) && !is_bool($showInList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showInList, true), gettype($showInList)), __LINE__);
        }
        $this->showInList = $showInList;
        return $this;
    }
    /**
     * Get globalSearch value
     * @return bool|null
     */
    public function getGlobalSearch()
    {
        return $this->globalSearch;
    }
    /**
     * Set globalSearch value
     * @param bool $globalSearch
     * @return \StructType\EntityCustomField
     */
    public function setGlobalSearch($globalSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($globalSearch) && !is_bool($globalSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($globalSearch, true), gettype($globalSearch)), __LINE__);
        }
        $this->globalSearch = $globalSearch;
        return $this;
    }
    /**
     * Get isParent value
     * @return bool|null
     */
    public function getIsParent()
    {
        return $this->isParent;
    }
    /**
     * Set isParent value
     * @param bool $isParent
     * @return \StructType\EntityCustomField
     */
    public function setIsParent($isParent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isParent) && !is_bool($isParent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isParent, true), gettype($isParent)), __LINE__);
        }
        $this->isParent = $isParent;
        return $this;
    }
    /**
     * Get insertBefore value
     * @return \StructType\RecordRef|null
     */
    public function getInsertBefore()
    {
        return $this->insertBefore;
    }
    /**
     * Set insertBefore value
     * @param \StructType\RecordRef $insertBefore
     * @return \StructType\EntityCustomField
     */
    public function setInsertBefore(\StructType\RecordRef $insertBefore = null)
    {
        $this->insertBefore = $insertBefore;
        return $this;
    }
    /**
     * Get availableToSso value
     * @return bool|null
     */
    public function getAvailableToSso()
    {
        return $this->availableToSso;
    }
    /**
     * Set availableToSso value
     * @param bool $availableToSso
     * @return \StructType\EntityCustomField
     */
    public function setAvailableToSso($availableToSso = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToSso) && !is_bool($availableToSso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToSso, true), gettype($availableToSso)), __LINE__);
        }
        $this->availableToSso = $availableToSso;
        return $this;
    }
    /**
     * Get subtab value
     * @return \StructType\RecordRef|null
     */
    public function getSubtab()
    {
        return $this->subtab;
    }
    /**
     * Set subtab value
     * @param \StructType\RecordRef $subtab
     * @return \StructType\EntityCustomField
     */
    public function setSubtab(\StructType\RecordRef $subtab = null)
    {
        $this->subtab = $subtab;
        return $this;
    }
    /**
     * Get displayType value
     * @return string|null
     */
    public function getDisplayType()
    {
        return $this->displayType;
    }
    /**
     * Set displayType value
     * @uses \EnumType\CustomizationDisplayType::valueIsValid()
     * @uses \EnumType\CustomizationDisplayType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $displayType
     * @return \StructType\EntityCustomField
     */
    public function setDisplayType($displayType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationDisplayType::valueIsValid($displayType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationDisplayType', is_array($displayType) ? implode(', ', $displayType) : var_export($displayType, true), implode(', ', \EnumType\CustomizationDisplayType::getValidValues())), __LINE__);
        }
        $this->displayType = $displayType;
        return $this;
    }
    /**
     * Get displayWidth value
     * @return int|null
     */
    public function getDisplayWidth()
    {
        return $this->displayWidth;
    }
    /**
     * Set displayWidth value
     * @param int $displayWidth
     * @return \StructType\EntityCustomField
     */
    public function setDisplayWidth($displayWidth = null)
    {
        // validation for constraint: int
        if (!is_null($displayWidth) && !(is_int($displayWidth) || ctype_digit($displayWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayWidth, true), gettype($displayWidth)), __LINE__);
        }
        $this->displayWidth = $displayWidth;
        return $this;
    }
    /**
     * Get displayHeight value
     * @return int|null
     */
    public function getDisplayHeight()
    {
        return $this->displayHeight;
    }
    /**
     * Set displayHeight value
     * @param int $displayHeight
     * @return \StructType\EntityCustomField
     */
    public function setDisplayHeight($displayHeight = null)
    {
        // validation for constraint: int
        if (!is_null($displayHeight) && !(is_int($displayHeight) || ctype_digit($displayHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayHeight, true), gettype($displayHeight)), __LINE__);
        }
        $this->displayHeight = $displayHeight;
        return $this;
    }
    /**
     * Get help value
     * @return string|null
     */
    public function getHelp()
    {
        return $this->help;
    }
    /**
     * Set help value
     * @param string $help
     * @return \StructType\EntityCustomField
     */
    public function setHelp($help = null)
    {
        // validation for constraint: string
        if (!is_null($help) && !is_string($help)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($help, true), gettype($help)), __LINE__);
        }
        $this->help = $help;
        return $this;
    }
    /**
     * Get parentSubtab value
     * @return \StructType\RecordRef|null
     */
    public function getParentSubtab()
    {
        return $this->parentSubtab;
    }
    /**
     * Set parentSubtab value
     * @param \StructType\RecordRef $parentSubtab
     * @return \StructType\EntityCustomField
     */
    public function setParentSubtab(\StructType\RecordRef $parentSubtab = null)
    {
        $this->parentSubtab = $parentSubtab;
        return $this;
    }
    /**
     * Get linkText value
     * @return string|null
     */
    public function getLinkText()
    {
        return $this->linkText;
    }
    /**
     * Set linkText value
     * @param string $linkText
     * @return \StructType\EntityCustomField
     */
    public function setLinkText($linkText = null)
    {
        // validation for constraint: string
        if (!is_null($linkText) && !is_string($linkText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkText, true), gettype($linkText)), __LINE__);
        }
        $this->linkText = $linkText;
        return $this;
    }
    /**
     * Get isMandatory value
     * @return bool|null
     */
    public function getIsMandatory()
    {
        return $this->isMandatory;
    }
    /**
     * Set isMandatory value
     * @param bool $isMandatory
     * @return \StructType\EntityCustomField
     */
    public function setIsMandatory($isMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMandatory) && !is_bool($isMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMandatory, true), gettype($isMandatory)), __LINE__);
        }
        $this->isMandatory = $isMandatory;
        return $this;
    }
    /**
     * Get checkSpelling value
     * @return bool|null
     */
    public function getCheckSpelling()
    {
        return $this->checkSpelling;
    }
    /**
     * Set checkSpelling value
     * @param bool $checkSpelling
     * @return \StructType\EntityCustomField
     */
    public function setCheckSpelling($checkSpelling = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkSpelling) && !is_bool($checkSpelling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkSpelling, true), gettype($checkSpelling)), __LINE__);
        }
        $this->checkSpelling = $checkSpelling;
        return $this;
    }
    /**
     * Get maxLength value
     * @return int|null
     */
    public function getMaxLength()
    {
        return $this->maxLength;
    }
    /**
     * Set maxLength value
     * @param int $maxLength
     * @return \StructType\EntityCustomField
     */
    public function setMaxLength($maxLength = null)
    {
        // validation for constraint: int
        if (!is_null($maxLength) && !(is_int($maxLength) || ctype_digit($maxLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxLength, true), gettype($maxLength)), __LINE__);
        }
        $this->maxLength = $maxLength;
        return $this;
    }
    /**
     * Get minValue value
     * @return float|null
     */
    public function getMinValue()
    {
        return $this->minValue;
    }
    /**
     * Set minValue value
     * @param float $minValue
     * @return \StructType\EntityCustomField
     */
    public function setMinValue($minValue = null)
    {
        // validation for constraint: float
        if (!is_null($minValue) && !(is_float($minValue) || is_numeric($minValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minValue, true), gettype($minValue)), __LINE__);
        }
        $this->minValue = $minValue;
        return $this;
    }
    /**
     * Get maxValue value
     * @return float|null
     */
    public function getMaxValue()
    {
        return $this->maxValue;
    }
    /**
     * Set maxValue value
     * @param float $maxValue
     * @return \StructType\EntityCustomField
     */
    public function setMaxValue($maxValue = null)
    {
        // validation for constraint: float
        if (!is_null($maxValue) && !(is_float($maxValue) || is_numeric($maxValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxValue, true), gettype($maxValue)), __LINE__);
        }
        $this->maxValue = $maxValue;
        return $this;
    }
    /**
     * Get defaultChecked value
     * @return bool|null
     */
    public function getDefaultChecked()
    {
        return $this->defaultChecked;
    }
    /**
     * Set defaultChecked value
     * @param bool $defaultChecked
     * @return \StructType\EntityCustomField
     */
    public function setDefaultChecked($defaultChecked = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultChecked) && !is_bool($defaultChecked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultChecked, true), gettype($defaultChecked)), __LINE__);
        }
        $this->defaultChecked = $defaultChecked;
        return $this;
    }
    /**
     * Get defaultValue value
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }
    /**
     * Set defaultValue value
     * @param string $defaultValue
     * @return \StructType\EntityCustomField
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: string
        if (!is_null($defaultValue) && !is_string($defaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultValue, true), gettype($defaultValue)), __LINE__);
        }
        $this->defaultValue = $defaultValue;
        return $this;
    }
    /**
     * Get isFormula value
     * @return bool|null
     */
    public function getIsFormula()
    {
        return $this->isFormula;
    }
    /**
     * Set isFormula value
     * @param bool $isFormula
     * @return \StructType\EntityCustomField
     */
    public function setIsFormula($isFormula = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFormula) && !is_bool($isFormula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFormula, true), gettype($isFormula)), __LINE__);
        }
        $this->isFormula = $isFormula;
        return $this;
    }
    /**
     * Get defaultSelection value
     * @return \StructType\RecordRef|null
     */
    public function getDefaultSelection()
    {
        return $this->defaultSelection;
    }
    /**
     * Set defaultSelection value
     * @param \StructType\RecordRef $defaultSelection
     * @return \StructType\EntityCustomField
     */
    public function setDefaultSelection(\StructType\RecordRef $defaultSelection = null)
    {
        $this->defaultSelection = $defaultSelection;
        return $this;
    }
    /**
     * Get dynamicDefault value
     * @return string|null
     */
    public function getDynamicDefault()
    {
        return $this->dynamicDefault;
    }
    /**
     * Set dynamicDefault value
     * @uses \EnumType\CustomizationDynamicDefault::valueIsValid()
     * @uses \EnumType\CustomizationDynamicDefault::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dynamicDefault
     * @return \StructType\EntityCustomField
     */
    public function setDynamicDefault($dynamicDefault = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationDynamicDefault::valueIsValid($dynamicDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationDynamicDefault', is_array($dynamicDefault) ? implode(', ', $dynamicDefault) : var_export($dynamicDefault, true), implode(', ', \EnumType\CustomizationDynamicDefault::getValidValues())), __LINE__);
        }
        $this->dynamicDefault = $dynamicDefault;
        return $this;
    }
    /**
     * Get searchDefault value
     * @return \StructType\RecordRef|null
     */
    public function getSearchDefault()
    {
        return $this->searchDefault;
    }
    /**
     * Set searchDefault value
     * @param \StructType\RecordRef $searchDefault
     * @return \StructType\EntityCustomField
     */
    public function setSearchDefault(\StructType\RecordRef $searchDefault = null)
    {
        $this->searchDefault = $searchDefault;
        return $this;
    }
    /**
     * Get searchCompareField value
     * @return \StructType\RecordRef|null
     */
    public function getSearchCompareField()
    {
        return $this->searchCompareField;
    }
    /**
     * Set searchCompareField value
     * @param \StructType\RecordRef $searchCompareField
     * @return \StructType\EntityCustomField
     */
    public function setSearchCompareField(\StructType\RecordRef $searchCompareField = null)
    {
        $this->searchCompareField = $searchCompareField;
        return $this;
    }
    /**
     * Get sourceList value
     * @return \StructType\RecordRef|null
     */
    public function getSourceList()
    {
        return $this->sourceList;
    }
    /**
     * Set sourceList value
     * @param \StructType\RecordRef $sourceList
     * @return \StructType\EntityCustomField
     */
    public function setSourceList(\StructType\RecordRef $sourceList = null)
    {
        $this->sourceList = $sourceList;
        return $this;
    }
    /**
     * Get sourceFrom value
     * @return \StructType\RecordRef|null
     */
    public function getSourceFrom()
    {
        return $this->sourceFrom;
    }
    /**
     * Set sourceFrom value
     * @param \StructType\RecordRef $sourceFrom
     * @return \StructType\EntityCustomField
     */
    public function setSourceFrom(\StructType\RecordRef $sourceFrom = null)
    {
        $this->sourceFrom = $sourceFrom;
        return $this;
    }
    /**
     * Get sourceFilterBy value
     * @return \StructType\RecordRef|null
     */
    public function getSourceFilterBy()
    {
        return $this->sourceFilterBy;
    }
    /**
     * Set sourceFilterBy value
     * @param \StructType\RecordRef $sourceFilterBy
     * @return \StructType\EntityCustomField
     */
    public function setSourceFilterBy(\StructType\RecordRef $sourceFilterBy = null)
    {
        $this->sourceFilterBy = $sourceFilterBy;
        return $this;
    }
    /**
     * Get customSegment value
     * @return \StructType\RecordRef|null
     */
    public function getCustomSegment()
    {
        return $this->customSegment;
    }
    /**
     * Set customSegment value
     * @param \StructType\RecordRef $customSegment
     * @return \StructType\EntityCustomField
     */
    public function setCustomSegment(\StructType\RecordRef $customSegment = null)
    {
        $this->customSegment = $customSegment;
        return $this;
    }
    /**
     * Get appliesToCustomer value
     * @return bool|null
     */
    public function getAppliesToCustomer()
    {
        return $this->appliesToCustomer;
    }
    /**
     * Set appliesToCustomer value
     * @param bool $appliesToCustomer
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToCustomer($appliesToCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToCustomer) && !is_bool($appliesToCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToCustomer, true), gettype($appliesToCustomer)), __LINE__);
        }
        $this->appliesToCustomer = $appliesToCustomer;
        return $this;
    }
    /**
     * Get appliesToProject value
     * @return bool|null
     */
    public function getAppliesToProject()
    {
        return $this->appliesToProject;
    }
    /**
     * Set appliesToProject value
     * @param bool $appliesToProject
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToProject($appliesToProject = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToProject) && !is_bool($appliesToProject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToProject, true), gettype($appliesToProject)), __LINE__);
        }
        $this->appliesToProject = $appliesToProject;
        return $this;
    }
    /**
     * Get appliesToVendor value
     * @return bool|null
     */
    public function getAppliesToVendor()
    {
        return $this->appliesToVendor;
    }
    /**
     * Set appliesToVendor value
     * @param bool $appliesToVendor
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToVendor($appliesToVendor = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToVendor) && !is_bool($appliesToVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToVendor, true), gettype($appliesToVendor)), __LINE__);
        }
        $this->appliesToVendor = $appliesToVendor;
        return $this;
    }
    /**
     * Get appliesToEmployee value
     * @return bool|null
     */
    public function getAppliesToEmployee()
    {
        return $this->appliesToEmployee;
    }
    /**
     * Set appliesToEmployee value
     * @param bool $appliesToEmployee
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToEmployee($appliesToEmployee = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToEmployee) && !is_bool($appliesToEmployee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToEmployee, true), gettype($appliesToEmployee)), __LINE__);
        }
        $this->appliesToEmployee = $appliesToEmployee;
        return $this;
    }
    /**
     * Get appliesToOtherName value
     * @return bool|null
     */
    public function getAppliesToOtherName()
    {
        return $this->appliesToOtherName;
    }
    /**
     * Set appliesToOtherName value
     * @param bool $appliesToOtherName
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToOtherName($appliesToOtherName = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToOtherName) && !is_bool($appliesToOtherName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToOtherName, true), gettype($appliesToOtherName)), __LINE__);
        }
        $this->appliesToOtherName = $appliesToOtherName;
        return $this;
    }
    /**
     * Get appliesToContact value
     * @return bool|null
     */
    public function getAppliesToContact()
    {
        return $this->appliesToContact;
    }
    /**
     * Set appliesToContact value
     * @param bool $appliesToContact
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToContact($appliesToContact = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToContact) && !is_bool($appliesToContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToContact, true), gettype($appliesToContact)), __LINE__);
        }
        $this->appliesToContact = $appliesToContact;
        return $this;
    }
    /**
     * Get appliesToPartner value
     * @return bool|null
     */
    public function getAppliesToPartner()
    {
        return $this->appliesToPartner;
    }
    /**
     * Set appliesToPartner value
     * @param bool $appliesToPartner
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToPartner($appliesToPartner = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToPartner) && !is_bool($appliesToPartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToPartner, true), gettype($appliesToPartner)), __LINE__);
        }
        $this->appliesToPartner = $appliesToPartner;
        return $this;
    }
    /**
     * Get appliesToWebSite value
     * @return bool|null
     */
    public function getAppliesToWebSite()
    {
        return $this->appliesToWebSite;
    }
    /**
     * Set appliesToWebSite value
     * @param bool $appliesToWebSite
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToWebSite($appliesToWebSite = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToWebSite) && !is_bool($appliesToWebSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToWebSite, true), gettype($appliesToWebSite)), __LINE__);
        }
        $this->appliesToWebSite = $appliesToWebSite;
        return $this;
    }
    /**
     * Get appliesToGroup value
     * @return bool|null
     */
    public function getAppliesToGroup()
    {
        return $this->appliesToGroup;
    }
    /**
     * Set appliesToGroup value
     * @param bool $appliesToGroup
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToGroup($appliesToGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToGroup) && !is_bool($appliesToGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToGroup, true), gettype($appliesToGroup)), __LINE__);
        }
        $this->appliesToGroup = $appliesToGroup;
        return $this;
    }
    /**
     * Get availableExternally value
     * @return bool|null
     */
    public function getAvailableExternally()
    {
        return $this->availableExternally;
    }
    /**
     * Set availableExternally value
     * @param bool $availableExternally
     * @return \StructType\EntityCustomField
     */
    public function setAvailableExternally($availableExternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableExternally) && !is_bool($availableExternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableExternally, true), gettype($availableExternally)), __LINE__);
        }
        $this->availableExternally = $availableExternally;
        return $this;
    }
    /**
     * Get filterList value
     * @return \StructType\EntityCustomFieldFilterList|null
     */
    public function getFilterList()
    {
        return $this->filterList;
    }
    /**
     * Set filterList value
     * @param \StructType\EntityCustomFieldFilterList $filterList
     * @return \StructType\EntityCustomField
     */
    public function setFilterList(\StructType\EntityCustomFieldFilterList $filterList = null)
    {
        $this->filterList = $filterList;
        return $this;
    }
    /**
     * Get accessLevel value
     * @return string|null
     */
    public function getAccessLevel()
    {
        return $this->accessLevel;
    }
    /**
     * Set accessLevel value
     * @uses \EnumType\CustomizationAccessLevel::valueIsValid()
     * @uses \EnumType\CustomizationAccessLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessLevel
     * @return \StructType\EntityCustomField
     */
    public function setAccessLevel($accessLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationAccessLevel::valueIsValid($accessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationAccessLevel', is_array($accessLevel) ? implode(', ', $accessLevel) : var_export($accessLevel, true), implode(', ', \EnumType\CustomizationAccessLevel::getValidValues())), __LINE__);
        }
        $this->accessLevel = $accessLevel;
        return $this;
    }
    /**
     * Get appliesToStatement value
     * @return bool|null
     */
    public function getAppliesToStatement()
    {
        return $this->appliesToStatement;
    }
    /**
     * Set appliesToStatement value
     * @param bool $appliesToStatement
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToStatement($appliesToStatement = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToStatement) && !is_bool($appliesToStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToStatement, true), gettype($appliesToStatement)), __LINE__);
        }
        $this->appliesToStatement = $appliesToStatement;
        return $this;
    }
    /**
     * Get searchLevel value
     * @return string|null
     */
    public function getSearchLevel()
    {
        return $this->searchLevel;
    }
    /**
     * Set searchLevel value
     * @uses \EnumType\CustomizationSearchLevel::valueIsValid()
     * @uses \EnumType\CustomizationSearchLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchLevel
     * @return \StructType\EntityCustomField
     */
    public function setSearchLevel($searchLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationSearchLevel::valueIsValid($searchLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationSearchLevel', is_array($searchLevel) ? implode(', ', $searchLevel) : var_export($searchLevel, true), implode(', ', \EnumType\CustomizationSearchLevel::getValidValues())), __LINE__);
        }
        $this->searchLevel = $searchLevel;
        return $this;
    }
    /**
     * Get appliesToPriceList value
     * @return bool|null
     */
    public function getAppliesToPriceList()
    {
        return $this->appliesToPriceList;
    }
    /**
     * Set appliesToPriceList value
     * @param bool $appliesToPriceList
     * @return \StructType\EntityCustomField
     */
    public function setAppliesToPriceList($appliesToPriceList = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToPriceList) && !is_bool($appliesToPriceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToPriceList, true), gettype($appliesToPriceList)), __LINE__);
        }
        $this->appliesToPriceList = $appliesToPriceList;
        return $this;
    }
    /**
     * Get roleAccessList value
     * @return \StructType\CustomFieldRoleAccessList|null
     */
    public function getRoleAccessList()
    {
        return $this->roleAccessList;
    }
    /**
     * Set roleAccessList value
     * @param \StructType\CustomFieldRoleAccessList $roleAccessList
     * @return \StructType\EntityCustomField
     */
    public function setRoleAccessList(\StructType\CustomFieldRoleAccessList $roleAccessList = null)
    {
        $this->roleAccessList = $roleAccessList;
        return $this;
    }
    /**
     * Get deptAccessList value
     * @return \StructType\CustomFieldDepartmentAccessList|null
     */
    public function getDeptAccessList()
    {
        return $this->deptAccessList;
    }
    /**
     * Set deptAccessList value
     * @param \StructType\CustomFieldDepartmentAccessList $deptAccessList
     * @return \StructType\EntityCustomField
     */
    public function setDeptAccessList(\StructType\CustomFieldDepartmentAccessList $deptAccessList = null)
    {
        $this->deptAccessList = $deptAccessList;
        return $this;
    }
    /**
     * Get subAccessList value
     * @return \StructType\CustomFieldSubAccessList|null
     */
    public function getSubAccessList()
    {
        return $this->subAccessList;
    }
    /**
     * Set subAccessList value
     * @param \StructType\CustomFieldSubAccessList $subAccessList
     * @return \StructType\EntityCustomField
     */
    public function setSubAccessList(\StructType\CustomFieldSubAccessList $subAccessList = null)
    {
        $this->subAccessList = $subAccessList;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\CustomFieldTranslationsList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\CustomFieldTranslationsList $translationsList
     * @return \StructType\EntityCustomField
     */
    public function setTranslationsList(\StructType\CustomFieldTranslationsList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\EntityCustomField
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
