<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeSubscriptions StructType
 * @subpackage Structs
 */
class EmployeeSubscriptions extends AbstractStructBase
{
    /**
     * The subscribed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscribed;
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscription;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * Constructor method for EmployeeSubscriptions
     * @uses EmployeeSubscriptions::setSubscribed()
     * @uses EmployeeSubscriptions::setSubscription()
     * @uses EmployeeSubscriptions::setLastModifiedDate()
     * @param string $subscribed
     * @param string $subscription
     * @param string $lastModifiedDate
     */
    public function __construct($subscribed = null, $subscription = null, $lastModifiedDate = null)
    {
        $this
            ->setSubscribed($subscribed)
            ->setSubscription($subscription)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get subscribed value
     * @return string|null
     */
    public function getSubscribed()
    {
        return $this->subscribed;
    }
    /**
     * Set subscribed value
     * @param string $subscribed
     * @return \StructType\EmployeeSubscriptions
     */
    public function setSubscribed($subscribed = null)
    {
        // validation for constraint: string
        if (!is_null($subscribed) && !is_string($subscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscribed, true), gettype($subscribed)), __LINE__);
        }
        $this->subscribed = $subscribed;
        return $this;
    }
    /**
     * Get subscription value
     * @return string|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @param string $subscription
     * @return \StructType\EmployeeSubscriptions
     */
    public function setSubscription($subscription = null)
    {
        // validation for constraint: string
        if (!is_null($subscription) && !is_string($subscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscription, true), gettype($subscription)), __LINE__);
        }
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\EmployeeSubscriptions
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
}
